/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;

public interface Namespace {
    public static final String URI_ANDROID = ObjectsUtil.of("http://schemas.android.com/apk/res/android");
    public static final String URI_RES_AUTO = ObjectsUtil.of("http://schemas.android.com/apk/res-auto");
    public static final String PREFIX_ANDROID = ObjectsUtil.of("android");
    public static final String PREFIX_APP = ObjectsUtil.of("app");

    public String getPrefix();

    public String getUri();

    public static boolean isValidNamespace(String uri, String prefix) {
        return Namespace.isValidUri(uri) && Namespace.isValidPrefix(prefix);
    }

    public static boolean isValidUri(String uri, int resourceId) {
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId == 0) {
            if (StringsUtil.isEmpty(uri)) {
                return true;
            }
            return Namespace.isExternalUri(uri);
        }
        if (packageId == 1) {
            return URI_ANDROID.equals(uri);
        }
        if (URI_ANDROID.equals(uri) || !Namespace.isValidUri(uri)) {
            return false;
        }
        return !Namespace.isExternalUri(uri);
    }

    public static boolean isValidUri(String uri, String packageName) {
        if (PREFIX_ANDROID.equals(packageName)) {
            return URI_ANDROID.equals(uri);
        }
        if (URI_ANDROID.equals(uri)) {
            return false;
        }
        return Namespace.isValidUri(uri);
    }

    public static boolean isValidUri(String uri) {
        if (uri == null || uri.length() < 3) {
            return false;
        }
        return uri.contains("://");
    }

    public static boolean isExternalUri(String uri) {
        return uri != null && !uri.contains("schemas.android.com");
    }

    public static boolean isValidPrefix(String prefix, String packageName) {
        if (PREFIX_ANDROID.equals(packageName)) {
            return PREFIX_ANDROID.equals(prefix);
        }
        if (PREFIX_ANDROID.equals(prefix)) {
            return false;
        }
        return Namespace.isValidPrefix(prefix);
    }

    public static boolean isValidPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return false;
        }
        char[] chars = prefix.toCharArray();
        if (!Namespace.isValidPrefixChar(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            char ch = chars[i];
            if (Namespace.isValidPrefixChar(ch) || Namespace.isValidPrefixSymbol(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefixChar(char ch) {
        return ch <= 'Z' && ch >= 'A' || ch <= 'z' && ch >= 'a';
    }

    public static boolean isValidPrefixSymbol(char ch) {
        return ch <= '9' && ch >= '0' || ch == '_';
    }

    public static String prefixForResourceId(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId == 1) {
            return PREFIX_ANDROID;
        }
        if (packageId != 0) {
            return PREFIX_APP;
        }
        return null;
    }

    public static String uriForResourceId(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId == 1) {
            return URI_ANDROID;
        }
        if (packageId != 0) {
            return URI_RES_AUTO;
        }
        return null;
    }
}

