/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.utils.collection.CollectionUtil;
import java.util.Set;

public class SymbolGenerator {
    private final char[] characters;
    private final int totalCharacters;
    private final int lowercaseAndSuffix;
    private final int suffixLength;
    private final Set<String> reservedNames;

    public SymbolGenerator(char[] characters, int lowercaseLength, int suffixLength, Set<String> reservedNames) {
        this.characters = characters;
        this.totalCharacters = characters.length;
        this.lowercaseAndSuffix = lowercaseLength + suffixLength;
        this.suffixLength = suffixLength;
        this.reservedNames = reservedNames;
    }

    public SymbolGenerator(char[] characters, int lowercaseLength, int suffixLength) {
        this(characters, lowercaseLength, suffixLength, SymbolGenerator.loadDefaultReservedNames());
    }

    public String generateLowercase(int index) {
        return this.generate(index, false);
    }

    public String generateMixedCase(int index) {
        return this.generate(index, true);
    }

    public String generate(int index, boolean mixedCase) {
        int firstNumberOfCharacters;
        int size = 1;
        int number = index + 1;
        int maximumNumberOfCharacters = mixedCase ? this.totalCharacters : this.lowercaseAndSuffix;
        int availableCharacters = firstNumberOfCharacters = maximumNumberOfCharacters - this.suffixLength;
        while (number > availableCharacters) {
            number = (number - 1) / availableCharacters;
            availableCharacters = maximumNumberOfCharacters;
            ++size;
        }
        char[] characters = new char[size];
        number = index + 1;
        int i = 0;
        availableCharacters = firstNumberOfCharacters;
        int firstLetterPadding = this.suffixLength;
        while (number > availableCharacters) {
            characters[i++] = this.characters[(number - 1) % availableCharacters + firstLetterPadding];
            number = (number - 1) / availableCharacters;
            availableCharacters = maximumNumberOfCharacters;
            firstLetterPadding = 0;
        }
        characters[i] = this.characters[number - 1 + firstLetterPadding];
        String symbol = new String(characters);
        if (this.isReserved(symbol)) {
            return this.generate(index + 1, mixedCase);
        }
        return symbol;
    }

    public void addReserved(String symbol) {
        this.reservedNames.add(symbol);
    }

    public boolean removeReserved(String symbol) {
        return this.reservedNames.remove(symbol);
    }

    public void clearReserved() {
        this.reservedNames.clear();
    }

    public boolean isReserved(String symbol) {
        return this.reservedNames.contains(symbol);
    }

    private static Set<String> loadDefaultReservedNames() {
        return CollectionUtil.newHashSet("boolean", "byte", "char", "double", "float", "int", "long", "short", "void", "it", "by", "class");
    }
}

