/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils;

import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class ElapsedTime {
    private long startTime = System.currentTimeMillis();
    private long previous;
    private boolean mIsPaused;

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.previous = 0L;
    }

    public String now() {
        return this.now(true);
    }

    public String now(boolean ignoreZero) {
        long diff = this.elapsed();
        return this.msToDisplayTime(diff, true, ignoreZero);
    }

    public boolean isExpired(long ms) {
        return this.elapsed() >= ms;
    }

    public String remaining(long ms) {
        long el = this.elapsed();
        long diff = ms - el;
        if (diff < 0L) {
            return "--:--";
        }
        return this.msToDisplayTime(diff, true, true);
    }

    public void pause() {
        if (this.mIsPaused) {
            return;
        }
        this.previous = this.elapsed();
        this.mIsPaused = true;
    }

    public void resume() {
        if (!this.mIsPaused) {
            return;
        }
        this.mIsPaused = false;
        this.startTime = System.currentTimeMillis();
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public long elapsed() {
        return this.getDiff() + this.previous;
    }

    private long getDiff() {
        if (this.mIsPaused) {
            return 0L;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    private String msToDisplayTime(long l, boolean includeMs, boolean ignoreZero) {
        boolean showMs;
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        if (!includeMs) {
            return String.format(Locale.ENGLISH, "%02d:%02d:%02d", hr, min, sec);
        }
        long ms = TimeUnit.MILLISECONDS.toMillis(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec));
        boolean bl = showMs = min < 10L;
        if (ignoreZero) {
            if (hr == 0L && min == 0L) {
                return String.format(Locale.ENGLISH, "%02d.%03d", sec, ms);
            }
            if (hr == 0L) {
                if (showMs) {
                    return String.format(Locale.ENGLISH, "%02d:%02d.%03d", min, sec, ms);
                }
                return String.format(Locale.ENGLISH, "%02d:%02d", min, sec);
            }
        }
        if (showMs) {
            return String.format(Locale.ENGLISH, "%02d:%02d:%02d.%03d", hr, min, sec, ms);
        }
        return String.format(Locale.ENGLISH, "%02d:%02d:%02d", hr, min, sec);
    }
}

