/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.ParallelReference;
import com.reandroid.utils.ObjectsUtil;

public class ParallelIntegerPair
implements IntegerPair,
BlockRefresh {
    private final ParallelReference first;
    private final ParallelReference second;

    public ParallelIntegerPair(IntegerPair integerPair) {
        this.first = new ParallelReference(integerPair.getFirst());
        this.second = new ParallelReference(integerPair.getSecond());
    }

    public void add(IntegerPair pair) {
        this.getFirst().add(pair.getFirst());
        this.getSecond().add(pair.getSecond());
    }

    public void remove(IntegerPair pair) {
        this.getFirst().remove(pair.getFirst());
        this.getSecond().remove(pair.getSecond());
    }

    public boolean contains(IntegerPair pair) {
        return this.getFirst().contains(pair.getFirst()) && this.getSecond().contains(pair.getSecond());
    }

    @Override
    public ParallelReference getFirst() {
        return this.first;
    }

    @Override
    public ParallelReference getSecond() {
        return this.second;
    }

    @Override
    public void refresh() {
        this.getFirst().refresh();
        this.getSecond().refresh();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParallelIntegerPair pair = (ParallelIntegerPair)obj;
        return ObjectsUtil.equals(this.first, pair.first) && ObjectsUtil.equals(this.second, pair.second);
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.first, this.second);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public static IntegerPair combine(IntegerPair pair1, IntegerPair pair2) {
        if (pair1 == null) {
            return pair2;
        }
        if (pair2 == null) {
            return pair1;
        }
        if (pair1 instanceof ParallelIntegerPair) {
            ParallelIntegerPair p = (ParallelIntegerPair)pair1;
            p.add(pair2);
            return p;
        }
        ParallelIntegerPair p = new ParallelIntegerPair(pair1);
        p.add(pair2);
        return p;
    }
}

