/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Iterator;

public class ParallelReference
implements IntegerReference,
BlockRefresh {
    private final IntegerReference reference1;
    private IntegerReference reference2;

    public ParallelReference(IntegerReference reference1, IntegerReference reference2) {
        this.reference1 = reference1;
        this.reference2 = reference2;
    }

    public ParallelReference(IntegerReference reference1) {
        this(reference1, null);
    }

    public IntegerReference getReference2() {
        return this.reference2;
    }

    public boolean contains(IntegerReference reference) {
        if (reference == this) {
            return true;
        }
        if (!(reference instanceof ParallelReference)) {
            return CollectionUtil.contains(this.getRootReferences(), reference);
        }
        Iterator<IntegerReference> iterator = ((ParallelReference)reference).getRootReferences();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Iterator<IntegerReference> getRootReferences() {
        return CombiningIterator.two(ParallelReference.getRootReferences(this.reference1), ParallelReference.getRootReferences(this.reference2));
    }

    public void remove(IntegerReference ref) {
        Iterator<IntegerReference> iterator = ParallelReference.getRootReferences(ref);
        while (iterator.hasNext()) {
            this.removeRoot(iterator.next());
        }
    }

    private void removeRoot(IntegerReference ref) {
        if (ref == this.reference2) {
            this.reference2 = null;
        } else if (this.reference2 instanceof ParallelReference) {
            ParallelReference p = (ParallelReference)this.reference2;
            if (p.reference1 == ref) {
                if (p.reference2 == null) {
                    this.reference2 = null;
                } else {
                    p = new ParallelReference(p.reference2);
                    this.reference2 = p;
                }
            }
            p.removeRoot(ref);
        }
    }

    public void add(IntegerReference ref) {
        Iterator<IntegerReference> iterator = ParallelReference.getRootReferences(ref);
        while (iterator.hasNext()) {
            this.addRoot(iterator.next());
        }
    }

    private void addRoot(IntegerReference ref) {
        if (ref == null || this.contains(ref)) {
            return;
        }
        if (this.putOnNull(ref)) {
            return;
        }
        this.reference2 = new ParallelReference(this.reference2, ref);
    }

    private boolean putOnNull(IntegerReference ref) {
        ParallelReference p;
        IntegerReference current = this.reference1;
        if (current instanceof ParallelReference && (p = (ParallelReference)current).putOnNull(ref)) {
            return true;
        }
        current = this.reference2;
        if (current == null) {
            this.reference2 = ref;
            return true;
        }
        if (current instanceof ParallelReference) {
            return ((ParallelReference)current).putOnNull(ref);
        }
        return false;
    }

    public void setReference2(IntegerReference reference2) {
        if (reference2 == null) {
            return;
        }
        if (this.contains(reference2)) {
            return;
        }
        IntegerReference current = this.reference2;
        if (current instanceof ParallelReference) {
            ((ParallelReference)current).setReference2(reference2);
        } else if (reference2 != this) {
            this.reference2 = reference2;
        }
    }

    @Override
    public void set(int value) {
        this.reference1.set(value);
        if (this.reference2 != null) {
            this.reference2.set(value);
        }
    }

    @Override
    public int get() {
        return this.reference1.get();
    }

    @Override
    public void refresh() {
        this.set(this.get());
    }

    public int get2() {
        IntegerReference ref2 = this.reference2;
        if (ref2 != null) {
            return ref2.get();
        }
        return this.reference1.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParallelReference ref = (ParallelReference)obj;
        return this.contains(ref) && ref.contains(this);
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.reference1);
    }

    public String toString() {
        int i1 = this.reference1.get();
        if (this.reference2 == null) {
            return Integer.toString(i1);
        }
        int i2 = this.reference2.get();
        if (i1 == i2) {
            return Integer.toString(i1);
        }
        return "r1=" + this.reference1 + ", r2=" + this.reference2;
    }

    public static IntegerReference combine(IntegerReference reference1, IntegerReference reference2) {
        ParallelReference ref;
        if (reference1 == null) {
            return reference2;
        }
        if (reference2 == null) {
            return reference1;
        }
        if (reference1 instanceof ParallelReference && (ref = (ParallelReference)reference1).getReference2() == null) {
            ref.setReference2(reference2);
            return ref;
        }
        if (reference2 instanceof ParallelReference && (ref = (ParallelReference)reference2).getReference2() == null) {
            ref.setReference2(reference1);
            return ref;
        }
        if (reference1.equals(reference2)) {
            return reference1;
        }
        return new ParallelReference(reference1, reference2);
    }

    private static Iterator<IntegerReference> getRootReferences(IntegerReference ref) {
        if (ref == null) {
            return EmptyIterator.of();
        }
        if (ref instanceof ParallelReference) {
            return ((ParallelReference)ref).getRootReferences();
        }
        return SingleIterator.of(ref);
    }
}

