/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MethodHandleType
implements Comparable<MethodHandleType>,
SmaliFormat {
    public static final MethodHandleType STATIC_PUT = new MethodHandleType(0, "static-put", true);
    public static final MethodHandleType STATIC_GET = new MethodHandleType(1, "static-get", true);
    public static final MethodHandleType INSTANCE_PUT = new MethodHandleType(2, "instance-put", true);
    public static final MethodHandleType INSTANCE_GET = new MethodHandleType(3, "instance-get", true);
    public static final MethodHandleType INVOKE_STATIC = new MethodHandleType(4, "invoke-static", false);
    public static final MethodHandleType INVOKE_INSTANCE = new MethodHandleType(5, "invoke-instance", false);
    public static final MethodHandleType INVOKE_CONSTRUCTOR = new MethodHandleType(6, "invoke-constructor", false);
    public static final MethodHandleType INVOKE_DIRECT = new MethodHandleType(7, "invoke-direct", false);
    public static final MethodHandleType INVOKE_INTERFACE = new MethodHandleType(8, "invoke-interface", false);
    private static final MethodHandleType[] VALUES;
    private static final Map<String, MethodHandleType> nameMap;
    private final int type;
    private final String name;
    private final boolean field;

    private MethodHandleType(int type, String name, boolean field) {
        this.type = type;
        this.name = name;
        this.field = field;
    }

    public String name() {
        return this.name;
    }

    public int type() {
        return this.type;
    }

    public boolean isField() {
        return this.field;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.name());
    }

    @Override
    public int compareTo(MethodHandleType handleType) {
        if (handleType == this) {
            return 0;
        }
        if (handleType == null) {
            return -1;
        }
        return CompareUtil.compare(this.type(), handleType.type());
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public static MethodHandleType valueOf(int type) {
        if (type >= 0 && type < 9) {
            return VALUES[type];
        }
        return null;
    }

    public static MethodHandleType valueOf(String name) {
        return nameMap.get(name);
    }

    public static boolean startsWithHandleType(SmaliReader reader) {
        return MethodHandleType.get(reader) != null;
    }

    public static MethodHandleType get(SmaliReader reader) {
        if (reader.available() < 10) {
            return null;
        }
        int position = reader.position();
        MethodHandleType type = MethodHandleType.read(reader);
        reader.position(position);
        return type;
    }

    public static MethodHandleType read(SmaliReader reader) {
        reader.skipWhitespaces();
        int position = reader.position();
        char c = reader.getASCII(position);
        if (c != 's' && c != 'i') {
            return null;
        }
        int i = reader.indexOfBeforeLineEnd('@');
        if (i < 0) {
            return null;
        }
        MethodHandleType type = MethodHandleType.valueOf(reader.readString(i - position).trim());
        if (type == null) {
            reader.position(position);
        }
        return type;
    }

    static {
        MethodHandleType[] values = new MethodHandleType[]{STATIC_PUT, STATIC_GET, INSTANCE_PUT, INSTANCE_GET, INVOKE_STATIC, INVOKE_INSTANCE, INVOKE_CONSTRUCTOR, INVOKE_DIRECT, INVOKE_INTERFACE};
        VALUES = values;
        int length = values.length;
        HashMap<String, MethodHandleType> map = new HashMap<String, MethodHandleType>(length);
        nameMap = map;
        for (int i = 0; i < length; ++i) {
            MethodHandleType type = values[i];
            map.put(type.name, type);
        }
    }
}

