/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.AnnotationGroupKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.IterableIterator;
import java.util.Iterator;

public class AnnotationGroup
extends AnnotationsList<AnnotationSet>
implements KeyReference {
    public AnnotationGroup() {
        super(SectionType.ANNOTATION_SET, UsageMarker.USAGE_ANNOTATION, null);
    }

    @Override
    public AnnotationGroupKey getKey() {
        AnnotationGroupKey groupKey;
        int size = this.size();
        if (size == 0) {
            groupKey = AnnotationGroupKey.empty();
        } else {
            Key[] elements = new AnnotationSetKey[size];
            this.getItemKeys(elements);
            groupKey = AnnotationGroupKey.of((AnnotationSetKey[])elements);
        }
        return this.checkKey(groupKey);
    }

    @Override
    public void setKey(Key key) {
        super.setKey(key);
    }

    @Override
    public AnnotationSetKey getItemKey(int i) {
        return (AnnotationSetKey)super.getItemKey(i);
    }

    @Override
    public AnnotationSet setItemKeyAt(int index, Key key) {
        if (key != null && ((AnnotationSetKey)key).isEmpty()) {
            key = null;
        }
        return (AnnotationSet)super.setItemKeyAt(index, key);
    }

    @Override
    public boolean isBlank() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            AnnotationSet item = (AnnotationSet)this.getItem(i);
            if (item == null || item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyAt(int i) {
        AnnotationSet item = (AnnotationSet)this.getItem(i);
        return item == null || item.isEmpty();
    }

    public SectionType<AnnotationGroup> getSectionType() {
        return SectionType.ANNOTATION_GROUP;
    }

    @Override
    void removeNulls() {
    }

    public void replaceKeys(Key search, Key replace) {
        for (AnnotationSet annotationSet : this) {
            annotationSet.replaceKeys(search, replace);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<AnnotationSet, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(AnnotationSet element) {
                return element.usedIds();
            }
        };
    }

    public void merge(AnnotationGroup annotationGroup) {
        int size = annotationGroup.size();
        for (int i = 0; i < size; ++i) {
            this.addNewItem(annotationGroup.getItemKey(i));
        }
    }

    @Override
    protected boolean elementsAreEqual(AnnotationSet t1, AnnotationSet t2) {
        if (t1 == null) {
            return t2 == null || t2.isEmpty();
        }
        if (t2 == null) {
            return t1.isEmpty();
        }
        return t1.equals(t2);
    }

    public String toString() {
        return this.size() + " [" + StringsUtil.join(this.iterator(), (Object)", ") + "]";
    }
}

