/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.DefIndex;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationGroup;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.DirectoryEntry;
import com.reandroid.dex.data.DirectoryMap;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.data.MethodParameterDef;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.AnnotationGroupKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.AnnotationsKey;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;

public class AnnotationsDirectory
extends DataItem
implements KeyReference {
    private final Header header = new Header();
    private final DirectoryMap<FieldDef, AnnotationSet> fieldsAnnotationMap;
    private final DirectoryMap<MethodDef, AnnotationSet> methodsAnnotationMap;
    private final DirectoryMap<MethodDef, AnnotationGroup> parametersAnnotationMap;
    private final DataKey<AnnotationsDirectory> mKey;
    private static final Creator<DirectoryEntry<FieldDef, AnnotationSet>> CREATOR_FIELDS = () -> new DirectoryEntry(SectionType.ANNOTATION_SET);
    private static final Creator<DirectoryEntry<MethodDef, AnnotationSet>> CREATOR_METHODS = () -> new DirectoryEntry(SectionType.ANNOTATION_SET);
    private static final Creator<DirectoryEntry<MethodDef, AnnotationGroup>> CREATOR_PARAMS = () -> new DirectoryEntry(SectionType.ANNOTATION_GROUP);

    public AnnotationsDirectory() {
        super(4);
        this.fieldsAnnotationMap = new DirectoryMap(this.header.fieldCount, CREATOR_FIELDS);
        this.methodsAnnotationMap = new DirectoryMap(this.header.methodCount, CREATOR_METHODS);
        this.parametersAnnotationMap = new DirectoryMap(this.header.parameterCount, CREATOR_PARAMS);
        this.mKey = new DataKey<AnnotationsDirectory>(this);
        this.addChildBlock(0, this.header);
        this.addChildBlock(1, this.fieldsAnnotationMap);
        this.addChildBlock(2, this.methodsAnnotationMap);
        this.addChildBlock(3, this.parametersAnnotationMap);
    }

    @Override
    public DataKey<AnnotationsDirectory> getKey() {
        return this.mKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey dataKey = (DataKey)key;
        this.merge((AnnotationsDirectory)dataKey.getItem());
    }

    public SectionType<AnnotationsDirectory> getSectionType() {
        return SectionType.ANNOTATION_DIRECTORY;
    }

    @Override
    public boolean isBlank() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        AnnotationSet annotationSet = (AnnotationSet)this.header.classAnnotation.getItem();
        if (annotationSet != null && !annotationSet.isEmpty()) {
            return false;
        }
        return this.fieldsAnnotationMap.isEmpty() && this.methodsAnnotationMap.isEmpty() && this.parametersAnnotationMap.isEmpty();
    }

    public void sortFields() {
        this.fieldsAnnotationMap.sort();
    }

    public void sortMethods() {
        this.methodsAnnotationMap.sort();
        this.parametersAnnotationMap.sort();
    }

    public void link(Def<?> def) {
        if (def instanceof FieldDef) {
            this.fieldsAnnotationMap.link((FieldDef)def);
        } else if (def instanceof MethodDef) {
            MethodDef methodDef = (MethodDef)def;
            this.methodsAnnotationMap.link(methodDef);
            this.parametersAnnotationMap.link(methodDef);
        }
    }

    public void clear(DefIndex defIndex) {
        if (defIndex instanceof ClassId) {
            this.header.classAnnotation.setKey(null);
        } else if (defIndex instanceof FieldDef) {
            this.fieldsAnnotationMap.remove((FieldDef)defIndex);
        } else if (defIndex instanceof MethodDef) {
            MethodDef methodDef = (MethodDef)defIndex;
            this.methodsAnnotationMap.remove(methodDef);
            this.parametersAnnotationMap.remove(methodDef);
        }
    }

    public AnnotationSetKey get(DefIndex defIndex) {
        Iterator<AnnotationsKey<?>> result;
        if (defIndex instanceof ClassId) {
            AnnotationSetKey key = (AnnotationSetKey)this.header.classAnnotation.getKey();
            if (key == null) {
                key = AnnotationSetKey.empty();
            }
            return key;
        }
        if (defIndex instanceof FieldDef) {
            result = this.fieldsAnnotationMap.getValueKeys((FieldDef)defIndex);
        } else if (defIndex instanceof MethodDef) {
            result = this.methodsAnnotationMap.getValueKeys((MethodDef)defIndex);
        } else {
            if (defIndex instanceof MethodParameterDef) {
                return this.getParameter((MethodParameterDef)defIndex);
            }
            result = EmptyIterator.of();
        }
        return AnnotationSetKey.combine((Iterator)ObjectsUtil.cast(result));
    }

    public void put(DefIndex defIndex, AnnotationSetKey value) {
        if (value != null && value.isEmpty()) {
            value = null;
        }
        if (defIndex instanceof ClassId) {
            this.header.classAnnotation.setKey(value);
        } else if (defIndex instanceof FieldDef) {
            this.fieldsAnnotationMap.put((FieldDef)defIndex, (Key)value);
        } else if (defIndex instanceof MethodDef) {
            this.methodsAnnotationMap.put((MethodDef)defIndex, (Key)value);
        } else if (defIndex instanceof MethodParameterDef) {
            this.setParameter((MethodParameterDef)defIndex, value);
        }
    }

    public void remove(DefIndex defIndex) {
        this.put(defIndex, null);
    }

    public AnnotationItemKey getAnnotation(DefIndex defIndex, TypeKey typeKey) {
        AnnotationItem item = this.getAnnotationItem(defIndex, typeKey);
        if (item != null) {
            return item.getKey();
        }
        return null;
    }

    public Key getAnnotationValue(DefIndex defIndex, TypeKey typeKey, String name) {
        AnnotationElement element;
        AnnotationItem item = this.getAnnotationItem(defIndex, typeKey);
        if (item != null && (element = item.getElement(name)) != null) {
            return element.getValue();
        }
        return null;
    }

    private AnnotationItem getAnnotationItem(DefIndex defIndex, TypeKey typeKey) {
        Iterator<AnnotationSet> iterator;
        if (defIndex instanceof ClassId) {
            AnnotationSet set = (AnnotationSet)this.header.classAnnotation.getItem();
            if (set != null) {
                return set.get(typeKey);
            }
            return null;
        }
        if (defIndex instanceof FieldDef) {
            iterator = this.fieldsAnnotationMap.getValues((FieldDef)defIndex);
        } else if (defIndex instanceof MethodDef) {
            iterator = this.methodsAnnotationMap.getValues((MethodDef)defIndex);
        } else if (defIndex instanceof MethodParameterDef) {
            MethodParameterDef parameter = (MethodParameterDef)defIndex;
            int index = parameter.getDefinitionIndex();
            iterator = ComputeIterator.of(this.parametersAnnotationMap.getValues(parameter.getMethodDef()), group -> (AnnotationSet)group.getItem(index));
        } else {
            iterator = EmptyIterator.of();
        }
        while (iterator.hasNext()) {
            AnnotationItem item = iterator.next().get(typeKey);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public AnnotationSetKey getParameter(MethodParameterDef parameter) {
        int index = parameter.getDefinitionIndex();
        return AnnotationSetKey.combine(ComputeIterator.of(this.parametersAnnotationMap.getValues(parameter.getMethodDef()), group -> group.getItemKey(index)));
    }

    public void setParameter(MethodParameterDef parameter, AnnotationSetKey key) {
        this.setParameters(parameter.getMethodDef(), this.getParameters(parameter.getMethodDef()).set(parameter.getDefinitionIndex(), key));
    }

    public AnnotationGroupKey getParameters(MethodDef methodDef) {
        return AnnotationGroupKey.combine(ComputeIterator.of(this.parametersAnnotationMap.getValues(methodDef), AnnotationGroup::getKey));
    }

    public void setParameters(MethodDef methodDef, AnnotationGroupKey key) {
        key = key == null || key.isBlank() ? null : key.setParametersCount(methodDef.getParametersCount());
        this.parametersAnnotationMap.put(methodDef, (Key)key);
    }

    public boolean contains(DefIndex defIndex) {
        if (defIndex instanceof ClassId) {
            AnnotationSet set = (AnnotationSet)this.header.classAnnotation.getItem();
            return set != null && !set.isEmpty();
        }
        if (defIndex instanceof FieldDef) {
            return this.fieldsAnnotationMap.contains((FieldDef)defIndex);
        }
        if (defIndex instanceof MethodDef) {
            return this.methodsAnnotationMap.contains((MethodDef)defIndex);
        }
        if (defIndex instanceof MethodParameterDef) {
            Iterator<AnnotationGroup> iterator = this.parametersAnnotationMap.getValues(((MethodParameterDef)defIndex).getMethodDef());
            int index = defIndex.getDefinitionIndex();
            while (iterator.hasNext()) {
                AnnotationGroup groupBlock = iterator.next();
                if (groupBlock.isEmptyAt(index)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceKeys(Key search, Key replace) {
        AnnotationSet set = (AnnotationSet)this.header.classAnnotation.getItem();
        if (set != null) {
            set.replaceKeys(search, replace);
        }
        Iterator<AnnotationSet> iterator = this.fieldsAnnotationMap.getValues();
        while (iterator.hasNext()) {
            iterator.next().replaceKeys(search, replace);
        }
        iterator = this.methodsAnnotationMap.getValues();
        while (iterator.hasNext()) {
            iterator.next().replaceKeys(search, replace);
        }
        Iterator<AnnotationGroup> groupIterator = this.parametersAnnotationMap.getValues();
        while (groupIterator.hasNext()) {
            groupIterator.next().replaceKeys(search, replace);
        }
    }

    @Override
    public void editInternal(Block user) {
        this.header.editInternal(user);
        this.fieldsAnnotationMap.editInternal();
        this.parametersAnnotationMap.editInternal();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        AnnotationSet classAnnotation = (AnnotationSet)this.header.classAnnotation.getItem();
        Iterator<Object> iterator1 = classAnnotation == null ? EmptyIterator.of() : classAnnotation.usedIds();
        IterableIterator<AnnotationSet, IdItem> iterator2 = new IterableIterator<AnnotationSet, IdItem>(this.fieldsAnnotationMap.getValues()){

            @Override
            public Iterator<IdItem> iterator(AnnotationSet element) {
                return element.usedIds();
            }
        };
        IterableIterator<AnnotationSet, IdItem> iterator3 = new IterableIterator<AnnotationSet, IdItem>(this.methodsAnnotationMap.getValues()){

            @Override
            public Iterator<IdItem> iterator(AnnotationSet element) {
                return element.usedIds();
            }
        };
        IterableIterator<AnnotationGroup, IdItem> iterator4 = new IterableIterator<AnnotationGroup, IdItem>(this.parametersAnnotationMap.getValues()){

            @Override
            public Iterator<IdItem> iterator(AnnotationGroup element) {
                return element.usedIds();
            }
        };
        return CombiningIterator.four(iterator1, iterator2, iterator3, iterator4);
    }

    @Override
    protected void onPreRefresh() {
        this.header.refresh();
        super.onPreRefresh();
    }

    public void merge(AnnotationsDirectory directory) {
        if (directory == this) {
            return;
        }
        this.header.merge(directory.header);
        this.fieldsAnnotationMap.merge(directory.fieldsAnnotationMap);
        this.methodsAnnotationMap.merge(directory.methodsAnnotationMap);
        this.parametersAnnotationMap.merge(directory.parametersAnnotationMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationsDirectory directory = (AnnotationsDirectory)obj;
        return ObjectsUtil.equals(this.header, directory.header) && ObjectsUtil.equals(this.fieldsAnnotationMap, directory.fieldsAnnotationMap) && ObjectsUtil.equals(this.methodsAnnotationMap, directory.methodsAnnotationMap) && ObjectsUtil.equals(this.parametersAnnotationMap, directory.parametersAnnotationMap);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.header.hashCode();
        hash = hash * 31 + this.fieldsAnnotationMap.hashCode();
        hash = hash * 31 + this.methodsAnnotationMap.hashCode();
        hash = hash * 31 + this.parametersAnnotationMap.hashCode();
        return hash;
    }

    public String toString() {
        return this.header + ", fields=" + this.fieldsAnnotationMap + ", methods=" + this.methodsAnnotationMap + ", parameters=" + this.parametersAnnotationMap;
    }

    static class Header
    extends SectionItem
    implements BlockRefresh {
        final DataItemIndirectReference<AnnotationSet> classAnnotation = new DataItemIndirectReference<AnnotationSet>(SectionType.ANNOTATION_SET, this, 0, UsageMarker.USAGE_ANNOTATION);
        final IndirectInteger fieldCount = new IndirectInteger(this, 4);
        final IndirectInteger methodCount = new IndirectInteger(this, 8);
        final IndirectInteger parameterCount = new IndirectInteger(this, 12);

        public Header() {
            super(16);
        }

        public boolean isEmpty() {
            return this.classAnnotation.get() == 0 && this.fieldCount.get() == 0 && this.methodCount.get() == 0 && this.parameterCount.get() == 0;
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
            super.onReadBytes(reader);
            this.cacheItems();
        }

        private void cacheItems() {
            this.classAnnotation.pullItem();
            this.classAnnotation.addUniqueUser(this);
        }

        @Override
        public void refresh() {
            this.classAnnotation.refresh();
            this.classAnnotation.addUniqueUser(this);
        }

        public void merge(Header header) {
            this.classAnnotation.setKey(header.classAnnotation.getKey());
        }

        @Override
        public void editInternal(Block user) {
            this.classAnnotation.getUniqueItem(this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Header header = (Header)obj;
            return ObjectsUtil.equals(this.classAnnotation.getItem(), header.classAnnotation.getItem());
        }

        public int hashCode() {
            return 31 + ObjectsUtil.hash(this.classAnnotation.getItem());
        }

        public String toString() {
            return "class=" + this.classAnnotation + ", fields=" + this.fieldCount + ", methods=" + this.methodCount + ", parameters=" + this.parameterCount;
        }
    }
}

