/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.DefIndex;
import com.reandroid.dex.data.AnnotationsList;
import com.reandroid.dex.data.DirectoryEntry;
import com.reandroid.dex.key.AnnotationsKey;
import com.reandroid.dex.key.Key;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.util.Iterator;
import java.util.function.Predicate;

public class DirectoryMap<DEFINITION extends DefIndex, VALUE extends AnnotationsList<?>>
extends CountedBlockList<DirectoryEntry<DEFINITION, VALUE>>
implements Iterable<DirectoryEntry<DEFINITION, VALUE>> {
    public DirectoryMap(IntegerReference itemCount, Creator<DirectoryEntry<DEFINITION, VALUE>> creator) {
        super(creator, itemCount);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean sort() {
        return super.sort(CompareUtil.getComparableComparator());
    }

    public void put(DEFINITION definition, Key value) {
        if (value == null) {
            this.remove(definition);
        } else {
            this.getOrCreateSingleEntry(definition).setValue(value);
        }
    }

    public void put(Key definitionKey, Key value) {
        if (value == null) {
            this.removeWithDefinitionKey(definitionKey);
        } else {
            this.getOrCreateSingleEntry(definitionKey).setValue(value);
        }
    }

    public void add(DEFINITION definition, Key value) {
        if (!this.contains(definition, value)) {
            DirectoryEntry entry = (DirectoryEntry)this.createNext();
            entry.set(definition, value);
        }
    }

    public void add(DEFINITION definition, VALUE value) {
        if (!this.contains(definition, value)) {
            DirectoryEntry entry = (DirectoryEntry)this.createNext();
            entry.set(definition, value);
        }
    }

    @Override
    public boolean contains(DEFINITION definition) {
        return this.getEntries(definition).hasNext();
    }

    public boolean contains(DEFINITION definition, VALUE value) {
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definition);
        while (iterator.hasNext()) {
            if (!iterator.next().equalsValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(DEFINITION definition, Key valueKey) {
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definition);
        while (iterator.hasNext()) {
            if (!iterator.next().matchesValue(valueKey)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Key definitionKey, Key valueKey) {
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definitionKey);
        while (iterator.hasNext()) {
            if (!iterator.next().matchesValue(valueKey)) continue;
            return true;
        }
        return false;
    }

    public void removeWithDefinitionKey(Key definitionKey) {
        super.removeIf(entry -> entry.matchesDefinition(definitionKey));
    }

    public void remove(DEFINITION definition) {
        super.removeIf(entry -> entry.equalsDefIndex((DefIndex)definition));
    }

    public void remove(DEFINITION definition, Predicate<VALUE> filter) {
        super.removeIf(entry -> entry.equalsDefIndex((DefIndex)definition) && filter.test(entry.getValue()));
    }

    public void link(DEFINITION definition) {
        for (DirectoryEntry entry : this) {
            entry.link(definition);
        }
    }

    public Iterator<VALUE> getValues(int definitionIndex) {
        return ComputeIterator.of(this.getEntries((DEFINITION)definitionIndex), DirectoryEntry::getValue);
    }

    public Iterator<DirectoryEntry<DEFINITION, VALUE>> getEntries(int definitionIndex) {
        return FilterIterator.of(this.iterator(), entry -> entry.equalsDefIndex(definitionIndex));
    }

    public Iterator<VALUE> getValues(DEFINITION definition) {
        return ComputeIterator.of(this.getEntries(definition), DirectoryEntry::getValue);
    }

    public Iterator<AnnotationsKey<?>> getValueKeys(DEFINITION definition) {
        return ComputeIterator.of(this.getEntries(definition), DirectoryEntry::getValueKey);
    }

    public Iterator<VALUE> getValues() {
        return ComputeIterator.of(this.iterator(), DirectoryEntry::getValue);
    }

    public Iterator<DirectoryEntry<DEFINITION, VALUE>> getEntries(DEFINITION definition) {
        return FilterIterator.of(this.iterator(), entry -> entry.equalsDefIndex((DefIndex)definition));
    }

    public Iterator<DirectoryEntry<DEFINITION, VALUE>> getEntries(Key definitionKey) {
        return FilterIterator.of(this.iterator(), entry -> entry.matchesDefinition(definitionKey));
    }

    private DirectoryEntry<DEFINITION, VALUE> getOrCreateSingleEntry(DEFINITION definition) {
        DirectoryEntry<DEFINITION, VALUE> result;
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definition);
        if (!iterator.hasNext()) {
            result = (DirectoryEntry<DEFINITION, VALUE>)this.createNext();
            result.setDefinition(definition);
        } else {
            result = iterator.next();
            while (iterator.hasNext()) {
                this.remove((Block)iterator.next());
            }
        }
        return result;
    }

    private DirectoryEntry<DEFINITION, VALUE> getOrCreateSingleEntry(Key definitionKey) {
        DirectoryEntry<DEFINITION, VALUE> result;
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definitionKey);
        if (!iterator.hasNext()) {
            result = (DirectoryEntry<DEFINITION, VALUE>)this.createNext();
            result.setDefinitionKey(definitionKey);
        } else {
            result = iterator.next();
            while (iterator.hasNext()) {
                this.remove((Block)iterator.next());
            }
        }
        return result;
    }

    @Override
    public int countBytes() {
        return this.getCount() * 8;
    }

    public void merge(DirectoryMap<DEFINITION, VALUE> directoryMap) {
        if (directoryMap == this) {
            return;
        }
        int size = directoryMap.size();
        this.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            DirectoryEntry coming = (DirectoryEntry)directoryMap.get(i);
            DirectoryEntry item = (DirectoryEntry)this.createNext();
            item.merge(coming);
        }
    }

    public void editInternal() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((DirectoryEntry)this.get(i)).editInternal();
        }
    }
}

