/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;
import java.io.OutputStream;

class HiddenApiFlagValueList
extends BlockList<HiddenApiFlagValue>
implements Iterable<HiddenApiFlagValue> {
    private DefArray<?> defArray;
    private static final Creator<HiddenApiFlagValue> CREATOR = HiddenApiFlagValue::new;

    HiddenApiFlagValueList(Creator<? extends HiddenApiFlagValue> creator) {
        super(creator);
    }

    public HiddenApiFlagValueList() {
        this((Creator<? extends HiddenApiFlagValue>)CREATOR);
    }

    public HiddenApiFlagValue get(Def<?> def) {
        if (def == null) {
            return null;
        }
        DefArray defArray = this.defArray;
        if (defArray == null) {
            defArray = def.getParentInstance(DefArray.class);
            this.linkDefArray(defArray);
        }
        HiddenApiFlagValue flagValue = (HiddenApiFlagValue)this.get(def.getIndex());
        if (defArray == null) {
            return flagValue;
        }
        if (flagValue != null && flagValue.getDef() == def) {
            return flagValue;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            flagValue = (HiddenApiFlagValue)this.get(i);
            if (flagValue.getDef() != def) continue;
            return flagValue;
        }
        flagValue = (HiddenApiFlagValue)this.createNext();
        flagValue.linkDef(def);
        return flagValue;
    }

    HiddenApiFlagValueList newCompact() {
        return new Compact(this);
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.ensureDefLinked();
    }

    private void ensureDefLinked() {
        DefArray<?> defArray = this.defArray;
        if (defArray == null || defArray.size() == 0) {
            this.setSize(0);
            return;
        }
        this.removeIf(HiddenApiFlagValue::isEmpty);
        boolean needsSort = false;
        int size = defArray.size();
        for (int i = 0; i < size; ++i) {
            Def def = (Def)defArray.get(i);
            HiddenApiFlagValue flagValue = this.get(def);
            if (needsSort) continue;
            needsSort = def.getIndex() != flagValue.getIndex();
        }
        if (needsSort) {
            this.sort(CompareUtil.getComparableComparator());
        }
    }

    void linkDefArray(DefArray<?> defArray) {
        if (this.defArray != null) {
            if (this.defArray == defArray) {
                return;
            }
            throw new DexException("Invalid link state");
        }
        this.defArray = defArray;
        if (defArray == null) {
            this.setSize(0);
            return;
        }
        int size = defArray.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((HiddenApiFlagValue)this.get(i)).linkDef((Def)defArray.get(i));
        }
    }

    boolean isAllNoRestrictions() {
        for (HiddenApiFlagValue flagValue : this) {
            if (flagValue.isNoRestriction()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        this.readChildes(reader);
    }

    static class CompactCreator
    implements Creator<HiddenApiFlagValue> {
        private final HiddenApiFlagValueList source;

        CompactCreator(HiddenApiFlagValueList source) {
            this.source = source;
        }

        @Override
        public HiddenApiFlagValue newInstance() {
            throw new RuntimeException("Call newInstanceAt()");
        }

        @Override
        public HiddenApiFlagValue newInstanceAt(int index) {
            return ((HiddenApiFlagValue)this.source.get(index)).newCompact();
        }
    }

    static class Compact
    extends HiddenApiFlagValueList {
        private final HiddenApiFlagValueList source;

        Compact(HiddenApiFlagValueList source) {
            super(new CompactCreator(source));
            this.source = source;
        }

        @Override
        HiddenApiFlagValueList newCompact() {
            return new Compact(this.source);
        }

        @Override
        protected void onPreRefresh() {
        }

        @Override
        public int countBytes() {
            return 0;
        }

        @Override
        protected void onReadBytes(BlockReader reader) throws IOException {
        }

        @Override
        public void readChildes(BlockReader reader) throws IOException {
        }

        @Override
        protected int onWriteBytes(OutputStream stream) throws IOException {
            return 0;
        }
    }
}

