/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegisterType;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.ins.ConstNumber;
import com.reandroid.dex.ins.ConstNumberLong;
import com.reandroid.dex.ins.ConstString;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsNop;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.NullInstruction;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.RegisterReference;
import com.reandroid.dex.ins.RegistersEditor;
import com.reandroid.dex.ins.RegistersIterator;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class InstructionList
extends FixedBlockContainer
implements Iterable<Ins>,
SmaliFormat {
    private final CodeItem codeItem;
    private final InsBlockList insBlockList;
    private final DexPositionAlign blockAlign;

    public InstructionList(CodeItem codeItem) {
        super(2);
        this.codeItem = codeItem;
        DexPositionAlign blockAlign = new DexPositionAlign();
        this.insBlockList = new InsBlockList(blockAlign, codeItem.getInstructionCodeUnitsReference(), codeItem.getInstructionOutsReference(), codeItem.getExtraLines());
        this.blockAlign = blockAlign;
        this.addChild(0, this.insBlockList);
        this.addChild(1, blockAlign);
    }

    public RegistersEditor editRegisters() {
        return RegistersEditor.fromIns(this.getCodeItem(), this.iterator());
    }

    public MethodDef getMethodDef() {
        return this.getCodeItem().getMethodDef();
    }

    public DebugSequence getDebugSequence() {
        DebugInfo debugInfo = this.getDebugInfo();
        if (debugInfo != null) {
            return debugInfo.getDebugSequence();
        }
        return null;
    }

    public DebugSequence getOrCreateDebugSequence() {
        return this.getOrCreateDebugInfo().getDebugSequence();
    }

    public DebugInfo getDebugInfo() {
        return this.getCodeItem().getDebugInfo();
    }

    public DebugInfo getOrCreateDebugInfo() {
        return this.getCodeItem().getOrCreateDebugInfo();
    }

    public CodeItem getCodeItem() {
        return this.codeItem;
    }

    public RegistersTable getRegistersTable() {
        return this.getCodeItem();
    }

    public void addLocalRegisters(int amount) {
        this.addLocalRegisters(false, amount);
    }

    public void addLocalRegisters(boolean start, int amount) {
        RegistersTable registersTable = this.getRegistersTable();
        Iterator<RegistersIterator> iterator = this.getRegistersIterators();
        while (iterator.hasNext()) {
            RegistersIterator registersIterator = iterator.next();
            int count = registersIterator.isRange() ? 1 : registersIterator.size();
            for (int i = 0; i < count; ++i) {
                RegisterReference reference = registersIterator.get(i);
                if (!start && !reference.isParameter()) continue;
                reference.setRegisterValue(reference.getValue() + amount);
            }
        }
        registersTable.setRegistersCount(registersTable.getRegistersCount() + amount);
    }

    public boolean canAddLocalRegisters(int amount) {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable.getRegistersCount() + amount < 15) {
            return true;
        }
        Iterator<RegistersIterator> iterator = this.getRegistersIterators();
        while (iterator.hasNext()) {
            RegistersIterator registersIterator = iterator.next();
            int count = registersIterator.isRange() ? 1 : registersIterator.size();
            for (int i = 0; i < count; ++i) {
                RegisterReference reference = registersIterator.get(i);
                if (!reference.isParameter() || reference.getValue() + amount <= reference.getLimit()) continue;
                return false;
            }
        }
        return true;
    }

    public List<Register> getLocalFreeRegisters(int startIndex) {
        final RegistersTable registersTable = this.getRegistersTable();
        final int count = registersTable.getLocalRegistersCount();
        Iterator<Register> iterator = new ArraySupplierIterator<Register>(new ArraySupplier<Register>(){

            @Override
            public Register get(int i) {
                return new Register(i, false, registersTable);
            }

            @Override
            public int getCount() {
                return count;
            }
        });
        iterator = FilterIterator.of(iterator, reference -> {
            int registerValue = reference.getValue();
            return registerValue < count && this.isFreeRegister(registerValue, startIndex);
        });
        List<Register> list = CollectionUtil.toUniqueList(iterator);
        list.sort(CompareUtil.getComparableComparator());
        return list;
    }

    public boolean isFreeRegister(int registerValue, int startIndex) {
        Iterator<RegistersIterator> iterator = this.getRegistersIterators(startIndex);
        while (iterator.hasNext()) {
            RegistersIterator registersIterator = iterator.next();
            for (RegisterReference reference : registersIterator) {
                if (reference.getValue() != registerValue) continue;
                return reference.getRegisterType() == RegisterType.WRITE;
            }
        }
        return registerValue != this.getRegistersTable().getLocalRegistersCount();
    }

    private Iterator<RegistersIterator> getRegistersIterators() {
        return this.getRegistersIterators(0);
    }

    private Iterator<RegistersIterator> getRegistersIterators(int start) {
        return ComputeIterator.of(this.iterator(start), ins -> {
            if (ins instanceof SizeXIns) {
                return ((SizeXIns)ins).getRegistersIterator();
            }
            return null;
        });
    }

    public <T1 extends Ins> Iterator<T1> iterator(Opcode<T1> opcode) {
        return this.iterator(opcode, null);
    }

    public <T1 extends Ins> Iterator<T1> iterator(Opcode<T1> opcode, Predicate<? super T1> filter) {
        return ComputeIterator.of(this.iterator(), ins -> {
            Ins result = null;
            if (ins != null && ins.getOpcode() == opcode) {
                result = ins;
                if (filter != null && !filter.test((Object)result)) {
                    result = null;
                }
            }
            return result;
        });
    }

    @Override
    public Iterator<Ins> iterator() {
        return this.getInsBlockList().iterator();
    }

    public Iterator<Ins> clonedIterator() {
        return this.getInsBlockList().clonedIterator();
    }

    public Iterator<Ins> arrayIterator() {
        return this.getInsBlockList().arrayIterator();
    }

    public Iterator<Ins> iterator(int start, int size) {
        return this.getInsBlockList().iterator(start, size);
    }

    public Iterator<Ins> iterator(int start) {
        InsBlockList array = this.getInsBlockList();
        return array.iterator(start, this.getCount() - start);
    }

    public Iterator<Ins> iteratorByAddress(int startAddress, int codeUnits) {
        Ins insStart = this.getAtAddress(startAddress);
        if (insStart == null) {
            return EmptyIterator.of();
        }
        Ins insEnd = this.getAtAddress(startAddress + codeUnits);
        int count = insEnd.getIndex() - insStart.getIndex();
        return this.iterator(insStart.getIndex(), count);
    }

    private InsBlockList getInsBlockList() {
        return this.insBlockList;
    }

    void onEditing(InstructionList instructionList) {
        this.getInsBlockList().onEditingInternal(instructionList.getInsBlockList());
    }

    public Ins get(int i) {
        return (Ins)this.getInsBlockList().get(i);
    }

    public int getCount() {
        return this.getInsBlockList().size();
    }

    public boolean isEmpty() {
        return this.getInsBlockList().size() == 0;
    }

    public void add(Ins ins) {
        this.add(this.getInsBlockList().size(), ins);
    }

    public void add(int index, Ins item) {
        this.add(true, index, item);
    }

    public void add(boolean shiftLabels, int index, Ins item) {
        InsBlockList insBlockList = this.getInsBlockList();
        insBlockList.unlink();
        Ins exist = (Ins)insBlockList.get(index);
        Object lock = null;
        if (exist != null) {
            lock = insBlockList.linkLocked();
        }
        insBlockList.add(index, item);
        if (shiftLabels && exist != null) {
            exist.transferExtraLinesTo(item);
        }
        insBlockList.unlinkLocked(lock);
    }

    public void moveTo(Ins ins, int index) {
        int current = ins.getIndex();
        if (index == current) {
            return;
        }
        if (current < 0) {
            throw new IndexOutOfBoundsException("Removed ins, negative index: " + index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index >= this.getCount()) {
            throw new IndexOutOfBoundsException("Size = " + this.getCount() + ", " + index);
        }
        InsBlockList insBlockList = this.getInsBlockList();
        Object locked = insBlockList.linkLocked();
        insBlockList.moveTo(ins, index);
        Ins insAtPosition = this.get(current);
        ins.transferExtraLinesTo(insAtPosition);
        insBlockList.unlinkLocked(locked);
    }

    public ConstNumber createConstIntegerAt(int index, int value) {
        return this.createConstIntegerAt(index, 0, value);
    }

    public ConstNumber createConstIntegerAt(int index, int register, int value) {
        ConstNumber constNumber = register <= 15 && value <= 7 && value >= -7 ? (ConstNumber)this.createAt(index, Opcode.CONST_4) : (value <= Short.MAX_VALUE && value >= -32767 ? (ConstNumber)this.createAt(index, Opcode.CONST_16) : ((value & 0xFFFF) == 0 ? (ConstNumber)this.createAt(index, Opcode.CONST_HIGH16) : (ConstNumber)this.createAt(index, Opcode.CONST)));
        constNumber.setRegister(register);
        constNumber.set(value);
        return constNumber;
    }

    public ConstNumberLong createConstLongAt(int index, long value) {
        return this.createConstLongAt(index, 0, value);
    }

    public ConstNumberLong createConstLongAt(int index, int register, long value) {
        ConstNumberLong constNumber = (value & 0xFFFF00000000L) == 0L ? (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE_HIGH16) : ((value & 0xFFFFL) == value ? (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE_16) : ((value & 0xFFFFFFFFL) == value ? (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE_32) : (ConstNumberLong)this.createAt(index, Opcode.CONST_WIDE)));
        constNumber.setRegister(register);
        constNumber.set(value);
        return constNumber;
    }

    public ConstString createStringAt(int index, StringKey value) {
        return this.createStringAt(index, 0, value);
    }

    public ConstString createStringAt(int index, String value) {
        return this.createStringAt(index, 0, value);
    }

    public ConstString createStringAt(int index, int register, String value) {
        return this.createStringAt(index, register, StringKey.create(value));
    }

    public ConstString createStringAt(int index, int register, StringKey value) {
        StringId stringId = this.getCodeItem().getOrCreateSectionItem(SectionType.STRING_ID, value);
        int id = stringId.getIdx();
        ConstString constNumber = (id & 0xFFFF) == id ? (ConstString)this.createAt(index, Opcode.CONST_STRING) : (ConstString)this.createAt(index, Opcode.CONST_STRING_JUMBO);
        constNumber.setRegister(register);
        constNumber.setString(stringId);
        return constNumber;
    }

    public <T1 extends Ins> T1 createAt(int index, Opcode<T1> opcode) {
        if (index == this.getCount()) {
            return this.createNext(opcode);
        }
        Block item = opcode.newInstance();
        this.add(index, (Ins)item);
        return (T1)item;
    }

    public <T1 extends Ins> T1 createNext(Opcode<T1> opcode) {
        Block item = opcode.newInstance();
        this.add((Ins)item);
        return (T1)item;
    }

    public boolean isLonelyInTryCatch(Ins ins) {
        Iterator<ExceptionHandler.TryStartLabel> iterator = ins.getExtraLines(ExceptionHandler.TryStartLabel.class);
        if (!iterator.hasNext()) {
            return false;
        }
        InsBlockList insBlockList = this.getInsBlockList();
        insBlockList.link(iterator);
        int codeUnits = ins.getCodeUnits();
        boolean result = false;
        while (iterator.hasNext()) {
            ExceptionHandler.TryStartLabel startLabel = iterator.next();
            int handlerCodeUnits = startLabel.getHandler().getCodeUnit();
            if (handlerCodeUnits > codeUnits) continue;
            result = true;
            break;
        }
        insBlockList.unlink(iterator);
        return result;
    }

    public boolean contains(Ins item) {
        return this.getInsBlockList().containsExact(item);
    }

    public boolean remove(Ins item) {
        return this.remove(item, false);
    }

    public boolean remove(Ins item, boolean force) {
        InsBlockList insBlockList = this.getInsBlockList();
        if (!insBlockList.containsExact(item)) {
            return false;
        }
        Object lock = insBlockList.linkLocked();
        if (!force && this.isLonelyInTryCatch(item)) {
            return this.replaceWithNop(item) != null;
        }
        int index = item.getIndex();
        Ins next = this.get(index + 1);
        if (next == null && item.hasExtraLines()) {
            next = insBlockList.getOrCreateNullInstruction();
        }
        if (next != null) {
            item.transferExtraLinesTo(next);
        }
        insBlockList.remove(item);
        item.setParent(null);
        item.setIndex(-1);
        insBlockList.unlinkLocked(lock);
        return true;
    }

    public InsNop replaceWithNop(Ins ins) {
        return this.replace(ins, Opcode.NOP);
    }

    public <T1 extends Ins> T1 replace(Ins old, Opcode<T1> opcode) {
        if (!this.contains(old)) {
            return null;
        }
        Block item = opcode.newInstance();
        this.replace(old, (Ins)item);
        return (T1)item;
    }

    public void replace(Ins old, Ins item) {
        if (old == item) {
            return;
        }
        InsBlockList insBlockList = this.getInsBlockList();
        if (!insBlockList.containsExact(old)) {
            throw new IllegalArgumentException("Not a member of this instruction list");
        }
        Object obj = insBlockList.linkLocked();
        int index = old.getIndex();
        insBlockList.set(index, item);
        old.transferExtraLinesTo(item);
        old.setParent(null);
        old.setIndex(-1);
        insBlockList.unlinkLocked(obj);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.getInsBlockList().unlink();
    }

    public int getCodeUnits() {
        return this.getInsBlockList().getCodeUnits();
    }

    public DexPositionAlign getBlockAlign() {
        return this.blockAlign;
    }

    public Ins getAtAddress(int address) {
        return this.getInsBlockList().getAtAddress(address);
    }

    public Iterator<Label> getCodeLabels() {
        return CombiningIterator.two(this.getInsBlockList().getLabels(), this.getCodeItem().getTryBlockLabels());
    }

    public void replaceKeys(Key search, Key replace) {
        for (Ins ins : this) {
            ins.replaceKeys(search, replace);
        }
    }

    public Iterator<IdItem> usedIds() {
        return new IterableIterator<Ins, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(Ins element) {
                return element.usedIds();
            }
        };
    }

    public void linkExtraLines() {
        InsBlockList insBlockList = this.getInsBlockList();
        insBlockList.link();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        InsBlockList insBlockList = this.getInsBlockList();
        Object lock = insBlockList.linkLocked();
        writer.buildLabels(this.getCodeLabels());
        writer.setStateWritingInstructions(true);
        for (Ins ins : this) {
            writer.newLine();
            ins.append(writer);
        }
        writer.setStateWritingInstructions(false);
        NullInstruction nullInstruction = this.getInsBlockList().getNullInstruction();
        if (nullInstruction != null) {
            writer.newLine();
            nullInstruction.append(writer);
        }
        insBlockList.unlink(lock, false);
    }

    public void merge(InstructionList instructionList) {
        this.getInsBlockList().merge(instructionList.getInsBlockList());
        this.getInsBlockList().updateCodeUnits();
    }

    public void fromSmali(SmaliCodeSet smaliCodeSet) {
        int index = 0;
        int offset = smaliCodeSet.getAddressOffset();
        if (offset != 0) {
            Ins ins = this.getAtAddress(smaliCodeSet.getAddressOffset());
            if (ins != null) {
                index = ins.getIndex();
            } else if (offset >= this.getCodeUnits()) {
                index = this.getCount();
            }
        }
        this.fromSmali(index, smaliCodeSet);
    }

    public void fromSmali(int index, SmaliCodeSet smaliCodeSet) {
        InsBlockList insBlockList = this.getInsBlockList();
        Object obj = insBlockList.linkLocked();
        Iterator<SmaliInstruction> iterator = smaliCodeSet.getInstructions();
        while (iterator.hasNext()) {
            SmaliInstruction smaliInstruction = iterator.next();
            Object ins = this.createAt(index, smaliInstruction.getOpcode());
            ((Ins)ins).fromSmali(smaliInstruction);
            ++index;
        }
        insBlockList.unlinkLocked(obj);
    }

    public void toSmali(SmaliMethod smaliMethod) {
        InsBlockList insBlockList = this.getInsBlockList();
        Object obj = insBlockList.linkLocked();
        SmaliCodeSet smaliCodeSet = smaliMethod.getCodeSet();
        int size = insBlockList.size();
        for (int i = 0; i < size; ++i) {
            this.get(i).toSmali(smaliCodeSet);
        }
        insBlockList.unlinkLocked(obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InstructionList list = (InstructionList)obj;
        return this.insBlockList.equals(list.insBlockList);
    }

    public int hashCode() {
        return this.insBlockList.hashCode();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        SmaliWriter smaliWriter = new SmaliWriter(writer);
        smaliWriter.indentPlus();
        try {
            this.append(smaliWriter);
            smaliWriter.close();
        }
        catch (IOException exception) {
            return exception.toString();
        }
        return writer.toString();
    }
}

