/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.common.DefIndex;
import com.reandroid.dex.dalvik.DalvikSignature;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugParameter;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.DalvikSignatureKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ParameterisedTypeKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.MethodParameter;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class MethodParameterDef
implements DefIndex,
MethodParameter,
SmaliRegion {
    private final MethodDef methodDef;
    private final int index;

    public MethodParameterDef(MethodDef methodDef, int index) {
        this.methodDef = methodDef;
        this.index = index;
    }

    @Override
    public TypeKey getKey() {
        TypeId typeId = this.getTypeId();
        if (typeId != null) {
            return typeId.getKey();
        }
        return null;
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        AnnotationsDirectory directory = this.getMethodDef().getAnnotationsDirectory();
        if (directory != null) {
            return directory.getParameter(this);
        }
        return AnnotationSetKey.empty();
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotationSet) {
        MethodDef methodDef = this.getMethodDef();
        if (annotationSet == null || annotationSet.isEmpty()) {
            AnnotationsDirectory directory = methodDef.getAnnotationsDirectory();
            if (directory != null && directory.contains(this)) {
                directory = methodDef.getOrCreateUniqueAnnotationsDirectory();
                directory.put(this, null);
            }
        } else {
            methodDef.getOrCreateUniqueAnnotationsDirectory().put(this, annotationSet);
        }
    }

    @Override
    public void clearAnnotations() {
        this.setAnnotation(AnnotationSetKey.empty());
    }

    @Override
    public boolean hasAnnotations() {
        AnnotationsDirectory directory = this.getMethodDef().getAnnotationsDirectory();
        return directory != null && directory.contains(this);
    }

    @Override
    public AnnotationItemKey getAnnotation(TypeKey typeKey) {
        AnnotationsDirectory directory = this.getMethodDef().getAnnotationsDirectory();
        if (directory != null) {
            return directory.getAnnotation(this, typeKey);
        }
        return null;
    }

    @Override
    public Key getAnnotationValue(TypeKey typeKey, String name) {
        AnnotationsDirectory directory = this.getMethodDef().getAnnotationsDirectory();
        if (directory != null) {
            return directory.getAnnotationValue(this, typeKey, name);
        }
        return null;
    }

    public void onRemoved() {
        this.clearAnnotations();
        this.clearDebugParameter();
    }

    private TypeId getTypeId() {
        ProtoId protoId = this.getMethodDef().getProtoId();
        if (protoId != null) {
            return protoId.getParameter(this.getDefinitionIndex());
        }
        return null;
    }

    public MethodDef getMethodDef() {
        return this.methodDef;
    }

    @Override
    public int getDefinitionIndex() {
        return this.index;
    }

    @Override
    public int getRegister() {
        MethodDef methodDef = this.getMethodDef();
        int reg = methodDef.isStatic() ? 0 : 1;
        return reg += methodDef.getProtoKey().getRegister(this.getDefinitionIndex());
    }

    public void clearDebugParameter() {
        DebugInfo debugInfo = this.getMethodDef().getDebugInfo();
        if (debugInfo != null) {
            debugInfo.removeDebugParameter(this.getDefinitionIndex());
        }
    }

    @Override
    public String getDebugName() {
        DebugParameter debugParameter = this.getDebugParameter();
        if (debugParameter != null) {
            return debugParameter.getName();
        }
        return null;
    }

    @Override
    public void setDebugName(String name) {
        MethodDef methodDef;
        DebugInfo debugInfo;
        if (StringsUtil.isEmpty(name)) {
            name = null;
        }
        if ((debugInfo = (methodDef = this.getMethodDef()).getDebugInfo()) == null) {
            if (name == null) {
                return;
            }
            debugInfo = methodDef.getOrCreateDebugInfo();
        }
        if (name == null) {
            debugInfo.removeDebugParameter(this.getDefinitionIndex());
            return;
        }
        DebugParameter parameter = debugInfo.getOrCreateDebugParameter(this.getDefinitionIndex());
        parameter.setName(name);
    }

    public DebugParameter getDebugParameter() {
        DebugInfo debugInfo = this.getMethodDef().getDebugInfo();
        if (debugInfo != null) {
            return debugInfo.getDebugParameter(this.getDefinitionIndex());
        }
        return null;
    }

    public void fromSmali(SmaliMethodParameter smaliMethodParameter) {
        this.fromSmali(smaliMethodParameter, true);
    }

    public void fromSmali(SmaliMethodParameter smaliMethodParameter, boolean withAnnotations) {
        if (withAnnotations && smaliMethodParameter.hasAnnotations()) {
            this.setAnnotation(smaliMethodParameter.getAnnotation());
        }
        this.setDebugName(smaliMethodParameter.getDebugName());
    }

    public ParameterisedTypeKey getParameterisedTypeKey() {
        ParameterisedTypeKey typeKey;
        DalvikSignatureKey signatureKey;
        DalvikSignature dalvikSignature = DalvikSignature.of(this.getMethodDef());
        if (dalvikSignature != null && (signatureKey = dalvikSignature.getSignature()) != null && (typeKey = signatureKey.getProtoParameter(this.getDefinitionIndex())) != null && typeKey.isParametrisedType()) {
            return typeKey;
        }
        return null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        ParameterisedTypeKey typeKey;
        boolean has_annotation;
        DebugParameter debugParameter = this.getDebugParameter();
        boolean has_debug = debugParameter != null && debugParameter.getNameId() != null;
        AnnotationSetKey annotation = this.getAnnotation();
        boolean bl = has_annotation = !annotation.isEmpty();
        if (!has_debug && !has_annotation) {
            return;
        }
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.append('p');
        writer.appendInteger(this.getRegister());
        if (has_debug) {
            debugParameter.append(writer);
        }
        if ((typeKey = this.getParameterisedTypeKey()) != null) {
            writer.appendComment(typeKey.getComment());
        } else {
            writer.appendComment(this.getKey().getTypeName());
        }
        if (!has_annotation) {
            return;
        }
        writer.indentPlus();
        writer.appendAllWithDoubleNewLine(annotation.iterator());
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    public int hashCode() {
        return this.methodDef.hashCode() * 31 + this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodParameterDef parameter = (MethodParameterDef)obj;
        return this.index == parameter.index && this.getMethodDef() == parameter.getMethodDef();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PARAM;
    }

    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

