/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.debug.DebugAdvanceLine;
import com.reandroid.dex.debug.DebugAdvancePc;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliDebugElement;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public abstract class DebugElement
extends FixedDexContainerWithTool
implements ExtraLine {
    private final ByteItem elementType = new ByteItem();
    private int address;
    private int lineNumber;
    private Ins targetIns;

    DebugElement(int childesCount, int flag) {
        super(childesCount + 1);
        this.elementType.set((byte)flag);
        this.addChild(0, this.elementType);
    }

    DebugElement(int childesCount, DebugElementType<?> elementType) {
        this(childesCount, elementType.getFlag());
    }

    DebugElement(DebugElementType<?> elementType) {
        this(0, elementType.getFlag());
    }

    @Override
    public Ins getTargetIns() {
        return this.targetIns;
    }

    @Override
    public void setTargetIns(Ins targetIns) {
        if (targetIns != this.targetIns) {
            this.targetIns = targetIns;
            if (targetIns != null) {
                targetIns.addExtraLine(this);
            }
        }
    }

    public void removeSelf() {
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            debugSequence.remove(this);
        }
    }

    public boolean isValid() {
        return !this.isRemoved();
    }

    public boolean isVisible() {
        return this.isValid();
    }

    int getAddressDiff() {
        return 0;
    }

    void setAddressDiff(int diff) {
        if (diff == 0) {
            return;
        }
        DebugAdvancePc advancePc = this.getOrCreateDebugAdvancePc();
        if (advancePc != null) {
            advancePc.setAddressDiff(diff);
        }
    }

    int getLineDiff() {
        return 0;
    }

    void setLineDiff(int diff) {
    }

    @Override
    public boolean isRemoved() {
        return this.getDebugSequence() == null;
    }

    DebugSequence getDebugSequence() {
        DebugSequence debugSequence = this.getParent(DebugSequence.class);
        if (debugSequence != null && debugSequence.isRemoved()) {
            return null;
        }
        return debugSequence;
    }

    @Override
    public int getTargetAddress() {
        return this.address;
    }

    @Override
    public void setTargetAddress(int address) {
        DebugElement element = this;
        while (element.updateTargetAddress(address)) {
            if ((element = element.getNext()) == null) {
                return;
            }
            address += element.getAddressDiff();
        }
    }

    private boolean updateTargetAddress(int address) {
        int diff;
        if (address == this.getTargetAddress()) {
            return false;
        }
        DebugElement previous = this.getPrevious();
        if (previous == null) {
            diff = address;
        } else {
            diff = address - previous.getTargetAddress();
            if (diff < 0) {
                diff = 0;
            }
        }
        this.setAddressDiff(diff);
        this.address = address;
        return true;
    }

    private DebugElement getPrevious() {
        int index = this.getIndex();
        if (index <= 0) {
            return null;
        }
        DebugSequence sequence = this.getDebugSequence();
        if (sequence != null) {
            return sequence.get(index - 1);
        }
        return null;
    }

    private DebugElement getNext() {
        int index = this.getIndex();
        if (index < 0) {
            return null;
        }
        DebugSequence sequence = this.getDebugSequence();
        if (sequence != null) {
            return sequence.get(index + 1);
        }
        return null;
    }

    private DebugAdvancePc getOrCreateDebugAdvancePc() {
        DebugAdvancePc advancePc = this.getDebugAdvancePc();
        if (advancePc != null) {
            return advancePc;
        }
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            advancePc = debugSequence.createAtPosition(DebugElementType.ADVANCE_PC, this.getIndex());
        }
        return advancePc;
    }

    private DebugAdvancePc getDebugAdvancePc() {
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            DebugElement element = debugSequence.get(this.getIndex() - 1);
            if (element instanceof DebugAdvanceLine) {
                element = debugSequence.get(element.getIndex() - 1);
            }
            if (element instanceof DebugAdvancePc) {
                return (DebugAdvancePc)element;
            }
        }
        return null;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    int getFlag() {
        int flag = this.elementType.get();
        if (flag > 10) {
            flag = 10;
        }
        return flag;
    }

    int getFlagOffset() {
        int offset = this.elementType.get();
        if (offset < 10) {
            return 0;
        }
        return offset - 10;
    }

    void setFlagOffset(int offset) {
        int flag = this.getFlag();
        if (flag < 10) {
            if (offset == 0) {
                return;
            }
            throw new IllegalArgumentException("Can not set offset for: " + this.getElementType());
        }
        if (offset < 0 || offset > 245) {
            throw new DexException("Value out of range should be [0 - 245]: " + offset + ", prev = " + this.getFlagOffset());
        }
        int value = flag + offset;
        this.elementType.set((byte)value);
    }

    public abstract DebugElementType<?> getElementType();

    public SmaliDirective getSmaliDirective() {
        return this.getElementType().getSmaliDirective();
    }

    void cacheValues(DebugSequence debugSequence, DebugElement previous) {
        int line;
        int address;
        if (previous == null) {
            address = 0;
            line = debugSequence.getLineStart();
        } else {
            address = previous.getTargetAddress();
            line = previous.getLineNumber();
        }
        this.address = address += this.getAddressDiff();
        this.lineNumber = line += this.getLineDiff();
    }

    void updateValues(DebugSequence debugSequence, DebugElement previous) {
        int line;
        int address;
        if (previous == this) {
            return;
        }
        if (previous != null && previous.getParent() == null) {
            return;
        }
        if (previous == null) {
            address = 0;
            line = debugSequence.getLineStart();
        } else {
            address = previous.getTargetAddress();
            line = previous.getLineNumber();
        }
        int addressDiff = this.getTargetAddress() - address;
        int lineDiff = this.getLineNumber() - line;
        this.setAddressDiff(addressDiff);
        this.setLineDiff(lineDiff);
    }

    void onPreRemove(DebugSequence debugSequence) {
        this.transferLineOffset(debugSequence);
    }

    private void transferLineOffset(DebugSequence debugSequence) {
        int diff = this.getLineDiff();
        if (diff == 0) {
            return;
        }
        DebugElement prev = debugSequence.get(this.getIndex() - 1);
        if (prev == null) {
            debugSequence.setLineStart(debugSequence.getLineStart() + diff);
            return;
        }
        int available = 245 - prev.getLineDiff();
        if (available > 0) {
            if (diff > available) {
                prev.setLineDiff(prev.getLineDiff() + available);
                diff -= available;
            } else {
                prev.setLineDiff(prev.getLineDiff() + diff);
                diff = 0;
            }
        }
        if (diff == 0) {
            return;
        }
        DebugElement next = debugSequence.get(this.getIndex() + 1);
        if (next == null) {
            return;
        }
        available = 245 - next.getLineDiff();
        if (available > 0) {
            if (diff > available) {
                next.setLineDiff(prev.getLineDiff() + available);
            } else {
                next.setLineDiff(prev.getLineDiff() + diff);
            }
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.nonCheckRead(reader);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        if (this.isValid()) {
            this.getSmaliDirective().append(writer);
        }
    }

    @Override
    public boolean isEqualExtraLine(Object obj) {
        return obj == this;
    }

    @Override
    public int getSortOrder() {
        return 1;
    }

    @Override
    public int compareExtraLine(ExtraLine other) {
        if (other == this) {
            return 0;
        }
        if (!(other instanceof DebugElement)) {
            return ExtraLine.super.compareExtraLine(other);
        }
        DebugElement element = (DebugElement)other;
        return CompareUtil.compare(this.getIndex(), element.getIndex());
    }

    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public void merge(DebugElement element) {
        this.elementType.set(element.elementType.getByte());
    }

    public void fromSmali(Smali smali) {
        this.setTargetAddress(((SmaliDebugElement)smali).getAddress());
    }

    public int compareElement(DebugElement element) {
        int i = CompareUtil.compare(this.getFlag(), element.getFlag());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getTargetAddress(), element.getTargetAddress());
        if (i != 0) {
            return i;
        }
        return this.compareDetailElement(element);
    }

    int compareDetailElement(DebugElement element) {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugElement element = (DebugElement)obj;
        return this.elementType.getByte() == element.elementType.getByte();
    }

    public int hashCode() {
        return this.elementType.getByte();
    }

    public String toString() {
        return "Type = " + this.getElementType();
    }
}

