/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.arsc.base.BlockCreator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.debug.DebugAdvanceLine;
import com.reandroid.dex.debug.DebugAdvancePc;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugEndLocal;
import com.reandroid.dex.debug.DebugEndSequence;
import com.reandroid.dex.debug.DebugEpilogue;
import com.reandroid.dex.debug.DebugLineNumber;
import com.reandroid.dex.debug.DebugPrologue;
import com.reandroid.dex.debug.DebugRestartLocal;
import com.reandroid.dex.debug.DebugSetSourceFile;
import com.reandroid.dex.debug.DebugStartLocal;
import com.reandroid.dex.debug.DebugStartLocalExtended;
import com.reandroid.dex.smali.SmaliDirective;
import java.io.IOException;

public class DebugElementType<T extends DebugElement>
implements BlockCreator<T> {
    public static final DebugElementType<?>[] VALUES = new DebugElementType[11];
    public static final DebugElementType<DebugStartLocal> START_LOCAL;
    public static final DebugElementType<DebugEndLocal> END_LOCAL;
    public static final DebugElementType<DebugRestartLocal> RESTART_LOCAL;
    public static final DebugElementType<DebugPrologue> PROLOGUE;
    public static final DebugElementType<DebugEpilogue> EPILOGUE;
    public static final DebugElementType<DebugSetSourceFile> SET_SOURCE_FILE;
    public static final DebugElementType<DebugEndSequence> END_SEQUENCE;
    public static final DebugElementType<DebugAdvancePc> ADVANCE_PC;
    public static final DebugElementType<DebugAdvanceLine> ADVANCE_LINE;
    public static final DebugElementType<DebugStartLocalExtended> START_LOCAL_EXTENDED;
    public static final DebugElementType<DebugLineNumber> LINE_NUMBER;
    private final String name;
    private final SmaliDirective directive;
    private final int flag;
    private final BlockCreator<T> creator;

    private DebugElementType(String name, SmaliDirective directive, int flag, BlockCreator<T> creator) {
        this.name = name;
        this.directive = directive;
        this.flag = flag;
        this.creator = creator;
    }

    private DebugElementType(String name, int flag, BlockCreator<T> creator) {
        this(name, null, flag, creator);
    }

    public String getName() {
        return this.name;
    }

    public SmaliDirective getSmaliDirective() {
        return this.directive;
    }

    public int getFlag() {
        return this.flag;
    }

    @Override
    public T newInstance() {
        return (T)((DebugElement)this.creator.newInstance());
    }

    public boolean is(DebugElementType<?> type) {
        return type == this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugElementType debugElementType = (DebugElementType)obj;
        return this.flag == debugElementType.flag;
    }

    public int hashCode() {
        return this.flag;
    }

    public String toString() {
        if (this.directive != null) {
            return this.directive.toString();
        }
        return this.name;
    }

    public static DebugElementType<?> readFlag(BlockReader reader) throws IOException {
        int flag = reader.read();
        reader.offset(-1);
        return DebugElementType.fromFlag(flag);
    }

    public static DebugElementType<?> fromFlag(int flag) {
        if ((flag &= 0xFF) > 10) {
            flag = 10;
        }
        return VALUES[flag];
    }

    static {
        END_SEQUENCE = new DebugElementType<DebugEndSequence>("END_SEQUENCE", 0, () -> DebugEndSequence.INSTANCE);
        DebugElementType.VALUES[0] = END_SEQUENCE;
        ADVANCE_PC = new DebugElementType<DebugAdvancePc>("ADVANCE_PC", 1, DebugAdvancePc::new);
        DebugElementType.VALUES[1] = ADVANCE_PC;
        ADVANCE_LINE = new DebugElementType<DebugAdvanceLine>("ADVANCE_LINE", 2, DebugAdvanceLine::new);
        DebugElementType.VALUES[2] = ADVANCE_LINE;
        START_LOCAL = new DebugElementType<DebugStartLocal>("START_LOCAL", SmaliDirective.LOCAL, 3, DebugStartLocal::new);
        DebugElementType.VALUES[3] = START_LOCAL;
        START_LOCAL_EXTENDED = new DebugElementType<DebugStartLocalExtended>("START_LOCAL_EXTENDED", SmaliDirective.LOCAL, 4, DebugStartLocalExtended::new);
        DebugElementType.VALUES[4] = START_LOCAL_EXTENDED;
        END_LOCAL = new DebugElementType<DebugEndLocal>("END_LOCAL", SmaliDirective.END_LOCAL, 5, DebugEndLocal::new);
        DebugElementType.VALUES[5] = END_LOCAL;
        RESTART_LOCAL = new DebugElementType<DebugRestartLocal>("RESTART_LOCAL", SmaliDirective.RESTART_LOCAL, 6, DebugRestartLocal::new);
        DebugElementType.VALUES[6] = RESTART_LOCAL;
        PROLOGUE = new DebugElementType<DebugPrologue>("PROLOGUE", SmaliDirective.PROLOGUE, 7, DebugPrologue::new);
        DebugElementType.VALUES[7] = PROLOGUE;
        EPILOGUE = new DebugElementType<DebugEpilogue>("EPILOGUE", SmaliDirective.EPILOGUE, 8, DebugEpilogue::new);
        DebugElementType.VALUES[8] = EPILOGUE;
        SET_SOURCE_FILE = new DebugElementType<DebugSetSourceFile>("SET_SOURCE_FILE", SmaliDirective.SET_SOURCE_FILE, 9, DebugSetSourceFile::new);
        DebugElementType.VALUES[9] = SET_SOURCE_FILE;
        LINE_NUMBER = new DebugElementType<DebugLineNumber>("LINE_NUMBER", SmaliDirective.LINE, 10, DebugLineNumber::new);
        DebugElementType.VALUES[10] = LINE_NUMBER;
    }
}

