/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.debug.DebugAdvanceLine;
import com.reandroid.dex.debug.DebugAdvancePc;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugSequence;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliLineNumber;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;

public class DebugLineNumber
extends DebugElement {
    public DebugLineNumber() {
        super(DebugElementType.LINE_NUMBER);
    }

    @Override
    int getAddressDiff() {
        return this.getFlagOffset() / 15;
    }

    @Override
    void setAddressDiff(int diff) {
        int lineDiff = this.getLineDiff();
        int offset = diff * 15 + lineDiff + 4;
        if (offset > 245) {
            super.setAddressDiff(diff);
            offset = lineDiff + 4;
        }
        if (offset < 0) {
            offset = 0;
        }
        this.setFlagOffset(offset);
    }

    @Override
    int getLineDiff() {
        return this.getFlagOffset() % 15 - 4;
    }

    @Override
    void setLineDiff(int diff) {
        int addressDiff = this.getAddressDiff();
        int offset = addressDiff * 15 + diff + 4;
        if (offset > 245) {
            DebugAdvanceLine advanceLine = this.getOrCreateAdvanceLine();
            int advance = diff - 4;
            advanceLine.setLineDiff(advance);
            offset = addressDiff * 15;
        }
        this.setFlagOffset(offset);
    }

    private int getMaxLineDiff() {
        if (this.getAddressDiff() == 16) {
            return 1;
        }
        return 10;
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.setUpLineNumber(lineNumber);
        super.setLineNumber(lineNumber);
    }

    private int getPreviousLineNumber() {
        DebugSequence debugSequence = this.getDebugSequence();
        int index = this.getIndex();
        if (debugSequence == null || index == 0) {
            return 0;
        }
        for (int i = index - 1; i >= 0; --i) {
            DebugElement element = debugSequence.get(i);
            if (!(element instanceof DebugLineNumber)) continue;
            DebugLineNumber lineNumber = (DebugLineNumber)element;
            return lineNumber.getLineNumber();
        }
        return 0;
    }

    private void setUpLineNumber(int lineNumber) {
        int diff = lineNumber - this.getPreviousLineNumber();
        int max = this.getMaxLineDiff();
        if (diff >= -4 && diff <= max) {
            this.setLineDiff(diff);
            return;
        }
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence == null) {
            return;
        }
        if (this.getIndex() == 0) {
            diff = 0;
            debugSequence.setLineStartInternal(lineNumber);
            this.setLineDiff(diff);
            return;
        }
        DebugAdvanceLine advanceLine = this.getOrCreateAdvanceLine();
        if (advanceLine == null) {
            return;
        }
        this.setLineDiff(0);
        advanceLine.setLineDiff(diff);
    }

    private DebugAdvanceLine getOrCreateAdvanceLine() {
        DebugAdvanceLine advanceLine = this.getAdvanceLine();
        if (advanceLine != null) {
            return advanceLine;
        }
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            advanceLine = debugSequence.createAtPosition(DebugElementType.ADVANCE_LINE, this.getIndex());
        }
        return advanceLine;
    }

    private DebugAdvanceLine getAdvanceLine() {
        DebugSequence debugSequence = this.getDebugSequence();
        if (debugSequence != null) {
            DebugElement element = debugSequence.get(this.getIndex() - 1);
            if (element instanceof DebugAdvancePc) {
                element = debugSequence.get(element.getIndex() - 1);
            }
            if (element instanceof DebugAdvanceLine) {
                return (DebugAdvanceLine)element;
            }
        }
        return null;
    }

    @Override
    public boolean isEqualExtraLine(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DebugLineNumber)) {
            return false;
        }
        DebugLineNumber debugLineNumber = (DebugLineNumber)obj;
        return this.getTargetAddress() == debugLineNumber.getTargetAddress();
    }

    @Override
    public void fromSmali(Smali smali) {
        super.fromSmali(smali);
        SmaliLineNumber lineNumber = (SmaliLineNumber)smali;
        this.setLineNumber(lineNumber.getNumber());
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        if (this.isValid()) {
            int lineNum = this.getLineNumber();
            if (lineNum == -1) {
                return;
            }
            this.getSmaliDirective().append(writer);
            writer.appendInteger(lineNum);
        }
    }

    public DebugElementType<DebugLineNumber> getElementType() {
        return DebugElementType.LINE_NUMBER;
    }

    @Override
    public int getSortOrder() {
        return 0;
    }

    @Override
    public int getSortOrderFine() {
        return this.getLineNumber();
    }

    @Override
    int compareDetailElement(DebugElement element) {
        return CompareUtil.compare(this.getLineNumber(), element.getLineNumber());
    }

    @Override
    public int hashCode() {
        return this.getLineNumber() * 31 + this.getTargetAddress();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DebugLineNumber lineNumber = (DebugLineNumber)obj;
        return this.getLineNumber() == lineNumber.getLineNumber() && this.getTargetAddress() == lineNumber.getTargetAddress();
    }

    @Override
    public String toString() {
        return ".line " + this.getLineNumber();
    }
}

