/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.FixedDexContainer;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.debug.DebugAdvance;
import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugEndSequence;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliDebugElement;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class DebugSequence
extends FixedDexContainer
implements Iterable<DebugElement> {
    private final IntegerReference lineStart;
    private BlockList<DebugElement> elementList;

    public DebugSequence(IntegerReference lineStart) {
        super(2);
        this.lineStart = lineStart;
        this.addChild(1, DebugEndSequence.INSTANCE);
    }

    public <T1 extends DebugElement> T1 getOrCreateAtAddress(DebugElementType<T1> elementType, int address) {
        Block prev = null;
        Iterator<T1> iterator = this.iterator(elementType);
        while (iterator.hasNext()) {
            DebugElement element = (DebugElement)iterator.next();
            int a = element.getTargetAddress();
            if (a == address) {
                return (T1)element;
            }
            if (a > address) break;
            prev = element;
        }
        int index = 0;
        if (prev != null) {
            index = prev.getIndex() + 1;
        }
        T1 element = this.createAtPosition(elementType, index);
        ((DebugElement)element).setTargetAddress(address);
        return element;
    }

    public Iterator<DebugElement> getAtAddress(int address) {
        return FilterIterator.of(this.iterator(), element -> address == element.getTargetAddress());
    }

    public void removeInvalid() {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            DebugElement element = this.get(i);
            if (element.isValid()) continue;
            this.remove(element);
        }
    }

    public int getLineStart() {
        return this.lineStart.get();
    }

    public void setLineStart(int start) {
        if (start == this.getLineStart()) {
            return;
        }
        this.setLineStartInternal(start);
        this.cacheValues();
    }

    void setLineStartInternal(int start) {
        this.lineStart.set(start);
    }

    public Iterator<DebugElement> getExtraLines() {
        return new FilterIterator<DebugElement>(this.iterator(), element -> !(element instanceof DebugAdvance));
    }

    public boolean removeIf(Predicate<? super DebugElement> filter) {
        boolean removedOnce = false;
        Iterator<? super DebugElement> iterator = FilterIterator.of(this.clonedIterator(), filter);
        while (iterator.hasNext()) {
            boolean removed = this.removeInternal(iterator.next());
            if (!removed) continue;
            removedOnce = true;
        }
        if (removedOnce) {
            this.updateValues();
        }
        return removedOnce;
    }

    public boolean remove(DebugElement element) {
        if (element == null || element.getParent(this.getClass()) != this) {
            return false;
        }
        boolean removed = this.removeInternal(element);
        if (removed) {
            this.updateValues();
        }
        return removed;
    }

    private boolean removeInternal(DebugElement element) {
        element.onPreRemove(this);
        boolean removed = this.getElementList().remove(element);
        if (removed) {
            element.setParent(null);
            element.setIndex(-1);
        }
        return removed;
    }

    public <T1 extends DebugElement> T1 createAtPosition(DebugElementType<T1> type, int index) {
        Block element = type.newInstance();
        this.add(index, (DebugElement)element);
        return (T1)element;
    }

    public <T1 extends DebugElement> T1 createNext(DebugElementType<T1> type) {
        if (type == DebugElementType.END_SEQUENCE) {
            return (T1)DebugEndSequence.INSTANCE;
        }
        Block element = type.newInstance();
        this.add((DebugElement)element);
        return (T1)element;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int position = reader.getPosition();
        int count = 0;
        while (reader.read() != 0) {
            ++count;
        }
        if (count == 0) {
            return;
        }
        reader.seek(position);
        BlockList<DebugElement> elementList = this.unlockElementList();
        this.unlockElementList().ensureCapacity(count);
        DebugElementType<DebugEndSequence> type = this.readNext(reader);
        while (!type.is(DebugElementType.END_SEQUENCE)) {
            type = this.readNext(reader);
        }
        elementList.trimToSize();
        this.cacheValues();
    }

    private DebugElementType<?> readNext(BlockReader reader) throws IOException {
        Block debugElement;
        DebugElementType<?> type = DebugElementType.readFlag(reader);
        if (type == DebugElementType.END_SEQUENCE) {
            debugElement = DebugEndSequence.INSTANCE;
        } else {
            debugElement = type.newInstance();
            this.unlockElementList().add((DebugElement)debugElement);
        }
        debugElement.readBytes(reader);
        return type;
    }

    private void cacheValues() {
        DebugElement previous = null;
        for (DebugElement element : this) {
            element.cacheValues(this, previous);
            previous = element;
        }
    }

    private void updateValues() {
        DebugElement previous = null;
        Iterator<DebugElement> iterator = this.clonedIterator();
        while (iterator.hasNext()) {
            DebugElement element = iterator.next();
            element.updateValues(this, previous);
            previous = element;
        }
    }

    public DebugElement get(int i) {
        return this.getElementList().get(i);
    }

    public void add(int i, DebugElement element) {
        this.unlockElementList().add(i, element);
    }

    public <T1 extends DebugElement> Iterator<T1> iterator(DebugElementType<T1> type) {
        return ComputeIterator.of(this.iterator(), element -> {
            if (element.getElementType() == type) {
                return element;
            }
            return null;
        });
    }

    public int size() {
        return this.getElementList().size();
    }

    public boolean isEmpty() {
        return !this.getVisible().hasNext();
    }

    public int visibleSize() {
        return CollectionUtil.count(this.getVisible());
    }

    @Override
    public Iterator<DebugElement> iterator() {
        return this.getElementList().iterator();
    }

    public Iterator<DebugElement> getVisible() {
        return this.getElementList().iterator(DebugElement::isVisible);
    }

    public Iterator<DebugElement> clonedIterator() {
        return this.getElementList().clonedIterator();
    }

    public boolean add(DebugElement element) {
        if (element == null || element.getClass() == DebugEndSequence.class) {
            return false;
        }
        return this.unlockElementList().add(element);
    }

    public void clear() {
        this.getElementList().clearChildes();
    }

    public boolean isRemoved() {
        DebugInfo debugInfo = this.getParentInstance(DebugInfo.class);
        if (debugInfo != null) {
            return debugInfo.isRemoved();
        }
        return true;
    }

    public Iterator<IdItem> usedIds() {
        return new IterableIterator<DebugElement, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(DebugElement element) {
                return element.usedIds();
            }
        };
    }

    private BlockList<DebugElement> unlockElementList() {
        BlockList<DebugElement> elementList = this.elementList;
        if (elementList == null || BlockList.isImmutableEmpty(elementList)) {
            this.elementList = elementList = new BlockList();
            this.addChild(0, elementList);
        }
        return elementList;
    }

    private BlockList<DebugElement> getElementList() {
        BlockList<DebugElement> elementList = this.elementList;
        if (elementList == null || this.isRemoved()) {
            elementList = BlockList.empty();
        }
        return elementList;
    }

    public void merge(DebugSequence sequence) {
        this.lineStart.set(sequence.lineStart.get());
        int size = sequence.size();
        if (size == 0) {
            return;
        }
        this.unlockElementList().ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            DebugElement coming = sequence.get(i);
            Object element = this.createNext(coming.getElementType());
            ((DebugElement)element).merge(coming);
        }
        this.cacheValues();
        this.getElementList().trimToSize();
    }

    public void fromSmali(SmaliCodeSet smaliCodeSet) {
        Iterator<SmaliDebugElement> iterator = smaliCodeSet.getDebugElements();
        while (iterator.hasNext()) {
            SmaliDebugElement smaliDebug = iterator.next();
            ((DebugElement)this.createNext(smaliDebug.getDebugElementType())).fromSmali(smaliDebug);
        }
    }

    public int compareSequence(DebugSequence sequence) {
        if (sequence == null) {
            return -1;
        }
        if (sequence == this) {
            return 0;
        }
        Iterator<DebugElement> iterator1 = this.getVisible();
        Iterator<DebugElement> iterator2 = sequence.getVisible();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            DebugElement element2;
            DebugElement element1 = iterator1.next();
            int i = element1.compareElement(element2 = iterator2.next());
            if (i == 0) continue;
            return i;
        }
        if (iterator1.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public boolean startsWith(DebugSequence sequence) {
        if (sequence == null) {
            return false;
        }
        if (sequence == this) {
            return true;
        }
        Iterator<DebugElement> iterator1 = this.getVisible();
        Iterator<DebugElement> iterator2 = sequence.getVisible();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            DebugElement element2;
            DebugElement element1 = iterator1.next();
            if (element1.equals(element2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public int hashCode() {
        int hash = 1;
        Iterator<DebugElement> iterator = this.getVisible();
        while (iterator.hasNext()) {
            hash = hash * 31 + iterator.next().hashCode() * 31;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugSequence sequence = (DebugSequence)obj;
        Iterator<DebugElement> iterator1 = this.getVisible();
        Iterator<DebugElement> iterator2 = sequence.getVisible();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            DebugElement item2;
            DebugElement item1 = iterator1.next();
            if (((Object)item1).equals(item2 = iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public String toString() {
        return "start=" + this.lineStart + ", elements=" + this.getElementList();
    }
}

