/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.BooleanReference;
import com.reandroid.arsc.item.IntegerReference;
import java.io.IOException;

public class ByteOrShortItem
extends BlockItem
implements IntegerReference {
    private final BooleanReference is_byte;

    public ByteOrShortItem(BooleanReference is_byte) {
        super(2);
        this.is_byte = is_byte;
    }

    @Override
    public int get() {
        byte[] bytes = this.getBytesInternal();
        if (this.is_byte.get()) {
            return bytes[0] & 0xFF;
        }
        return Block.getShortUnsigned(bytes, 0);
    }

    @Override
    public void set(int value) {
        boolean isByte = this.is_byte.get();
        this.setBytesLength(isByte ? 1 : 2, false);
        byte[] bytes = this.getBytesInternal();
        if (isByte) {
            bytes[0] = (byte)value;
        } else {
            Block.putShort(bytes, 0, value);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.setBytesLength(this.is_byte.get() ? 1 : 2, false);
        super.onReadBytes(reader);
    }

    public String toString() {
        return Integer.toString(this.get());
    }
}

