/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.dexopt.HotMethodRegionList;
import com.reandroid.dex.dexopt.MethodBitmap;
import com.reandroid.dex.dexopt.ProfileClassList;
import com.reandroid.dex.dexopt.ProfileData;
import com.reandroid.dex.model.DexFile;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public abstract class DexProfileData
extends FixedBlockContainer
implements ProfileData {
    private boolean initialized;

    public DexProfileData(int childesCount) {
        super(childesCount);
    }

    public abstract long getChecksum();

    public abstract void setChecksum(long var1);

    public abstract HotMethodRegionList hotMethodList();

    public abstract ProfileClassList classList();

    public abstract MethodBitmap methodBitmap();

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.setInitialized(true);
    }

    @Override
    public void link(DexFile dexFile) {
        this.hotMethodList().link(dexFile);
        this.classList().link(dexFile);
        this.methodBitmap().link(dexFile);
    }

    @Override
    public void update(DexFile dexFile) {
        this.hotMethodList().update(dexFile);
        this.classList().update(dexFile);
        this.methodBitmap().update(dexFile, this.isInitialized());
        this.setInitialized(true);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", this.getName());
        jsonObject.put("checksum", this.getChecksum());
        jsonObject.put("hot_methods", this.hotMethodList().toJson());
        jsonObject.put("classes", this.classList().toJson());
        jsonObject.put("method_ids", this.methodBitmap().size());
        jsonObject.put("method_bitmap", this.methodBitmap().toJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setName(json.getString("name"));
        this.setChecksum(json.getLong("checksum"));
        this.hotMethodList().fromJson(json.optJSONArray("hot_methods"));
        this.classList().fromJson(json.optJSONArray("classes"));
        this.methodBitmap().setSize(json.getInt("method_ids"));
        this.methodBitmap().fromJson(json.optJSONArray("method_bitmap"));
        this.setInitialized(true);
    }

    public String toString() {
        return "name=" + this.getName() + ", checksum=" + HexUtil.toHex(this.getChecksum(), 8) + ", methodList=" + this.hotMethodList() + ", classList=" + this.classList() + ", bitmap=" + this.methodBitmap();
    }
}

