/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.dexopt.BitItem;
import com.reandroid.dex.dexopt.BooleanBit;
import com.reandroid.dex.dexopt.BooleanList;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.MethodBitmapElement;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Predicate;

public class MethodBitmap
extends FixedBlockContainer
implements LinkableProfileItem,
JSONConvert<JSONArray> {
    private final IntegerReference countReference;
    private final BooleanList startupList;
    private final BooleanList postStartupList;

    public MethodBitmap(IntegerReference countReference) {
        super(2);
        this.countReference = countReference;
        this.startupList = new BooleanList(countReference);
        this.postStartupList = new BooleanList(countReference);
        this.addChild(0, this.startupList);
        this.addChild(1, this.postStartupList);
    }

    public int size() {
        return this.startupList.size();
    }

    public void setSize(int size) {
        this.startupList.setSize(size);
        this.postStartupList.setSize(size);
        this.countReference.set(size);
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public MethodBitmapElement get(int i) {
        int size = this.size();
        if (i < 0 || i >= size) {
            return null;
        }
        return new MethodBitmapElement((BooleanBit)this.startupList.get(i), (BooleanBit)this.postStartupList.get(i));
    }

    public MethodBitmapElement getOrCreate(int id) {
        this.ensureSize(id + 1);
        return this.get(id);
    }

    public Iterator<MethodBitmapElement> iterator() {
        return ArraySupplierIterator.of(new ArraySupplier<MethodBitmapElement>(){

            @Override
            public MethodBitmapElement get(int i) {
                return MethodBitmap.this.get(i);
            }

            @Override
            public int getCount() {
                return MethodBitmap.this.size();
            }
        });
    }

    public void moveTo(MethodBitmapElement element, int position) {
        this.ensureSize(position + 1);
        this.startupList.moveTo(element.startup(), position);
        this.postStartupList.moveTo(element.postStartup(), position);
    }

    public boolean remove(int i) {
        if (this.startupList.remove(i) != null) {
            this.postStartupList.remove(i);
            this.updateCountReference();
            return true;
        }
        return false;
    }

    public boolean remove(MethodBitmapElement element) {
        if (this.startupList.remove(element.startup())) {
            this.postStartupList.remove(element.postStartup());
            this.updateCountReference();
            return true;
        }
        return false;
    }

    public void removeIf(Predicate<? super MethodBitmapElement> predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(this.get(i)) || !this.remove(i)) continue;
            --i;
            size = this.size();
        }
    }

    private void updateCountReference() {
        this.countReference.set(this.size());
    }

    @Override
    public void link(DexFile dexFile) {
        LinkableProfileItem.linkAll(dexFile, this.iterator());
    }

    @Override
    public void update(DexFile dexFile) {
        this.update(dexFile, false);
    }

    public void update(DexFile dexFile, boolean initialize) {
        if (initialize) {
            this.setSize(dexFile.getCount(SectionType.METHOD_ID));
            this.link(dexFile);
        } else {
            LinkableProfileItem.updateAll(dexFile, this.iterator());
        }
    }

    @Override
    public int countBytes() {
        return BitItem.bitsToBytes(this.size() * 2);
    }

    @Override
    public byte[] getBytes() {
        int size = this.size();
        if (size == 0) {
            return new byte[0];
        }
        BitItem pool = new BitItem(size * 2);
        int offset = 0;
        offset = this.startupList.writeTo(pool, offset);
        this.postStartupList.writeTo(pool, offset);
        return pool.getBytes();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        BooleanList startupList = this.startupList;
        BooleanList postStartupList = this.postStartupList;
        int itemsCount = this.countReference.get();
        startupList.setSize(itemsCount);
        postStartupList.setSize(itemsCount);
        BitItem pool = new BitItem(itemsCount * 2);
        pool.onReadBytes(reader);
        int offset = 0;
        offset = startupList.readFrom(pool, offset);
        postStartupList.readFrom(pool, offset);
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        int length = bytes.length;
        stream.write(bytes, 0, length);
        return length;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateCountReference();
    }

    @Override
    public JSONArray toJson() {
        int size = this.size();
        JSONArray jsonArray = new JSONArray(size);
        for (int i = 0; i < size; ++i) {
            MethodBitmapElement element = this.get(i);
            if (element.getFlags() == 0) continue;
            jsonArray.put(element.toJson());
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        int size = json == null ? 0 : json.length();
        this.ensureSize(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = json.getJSONObject(i);
            int id = jsonObject.getInt("id");
            this.getOrCreate(id).fromJson(jsonObject);
        }
    }

    public String toString() {
        return "size=" + this.size();
    }
}

