/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.DeflatedBlockContainer;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.ProfileData;
import com.reandroid.dex.dexopt.ProfileVersion;
import com.reandroid.dex.model.DexFile;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class ProfileBody
extends DeflatedBlockContainer
implements LinkableProfileItem,
JSONConvert<JSONArray> {
    private final ProfileVersion version;

    public ProfileBody(int childesCount, ProfileVersion version, IntegerReference sizeUncompressed, IntegerReference sizeCompressed) {
        super(childesCount, version.isDeflatedBody(), sizeUncompressed, sizeCompressed);
        this.version = version;
    }

    public ProfileVersion version() {
        return this.version;
    }

    public abstract int size();

    public abstract void setSize(int var1);

    public abstract ProfileData get(int var1);

    public ProfileData get(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ProfileData data = this.get(i);
            if (!ObjectsUtil.equals(data.getName(), name)) continue;
            return data;
        }
        return null;
    }

    public abstract Iterator<? extends ProfileData> iterator();

    public abstract boolean removeIfName(Predicate<String> var1);

    public abstract boolean removeData(int var1);

    public boolean removeData(String name) {
        return this.removeIfName(s -> ObjectsUtil.equals(s, name));
    }

    public ProfileData createNew() {
        int size = this.size();
        this.setSize(size + 1);
        return this.get(size);
    }

    @Override
    public void link(DexFile dexFile) {
        ProfileData data = this.get(dexFile.getSimpleName());
        if (data != null) {
            data.link(dexFile);
        }
    }

    @Override
    public void update(DexFile dexFile) {
        ProfileData data = this.get(dexFile.getSimpleName());
        if (data != null) {
            data.update(dexFile);
        }
    }

    @Override
    public JSONArray toJson() {
        int size = this.size();
        JSONArray jsonArray = new JSONArray(size);
        for (int i = 0; i < size; ++i) {
            jsonArray.put(this.get(i).toJson());
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        int size = json == null ? 0 : json.length();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.get(i).fromJson(json.getJSONObject(i));
        }
    }

    public String toString() {
        return "size = " + this.size() + " [" + StringsUtil.join(ComputeIterator.of(this.iterator(), ProfileData::getName), (Object)", ") + "]";
    }
}

