/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.DexProfileData;
import com.reandroid.dex.dexopt.ProfileDataBody;
import com.reandroid.dex.dexopt.ProfileFile;
import com.reandroid.dex.dexopt.ProfileMagic;
import com.reandroid.dex.dexopt.ProfileVersion;
import com.reandroid.utils.Crc32;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ProfileDataFile
extends ProfileFile {
    private final ProfileMagic magic = new ProfileMagic();
    private final ProfileVersion version;
    private final ProfileDataBody body;

    public ProfileDataFile() {
        super(6);
        ProfileVersion version;
        this.version = version = new ProfileVersion();
        ByteItem count = new ByteItem();
        IntegerItem unCompressedSize = version.newBodySize();
        IntegerItem compressedSize = version.newBodySize();
        this.body = new ProfileDataBody(version, count, (IntegerReference)unCompressedSize, (IntegerReference)compressedSize);
        this.addChild(0, this.magic);
        this.addChild(1, version);
        this.addChild(2, count);
        this.addChild(3, unCompressedSize);
        this.addChild(4, compressedSize);
        this.addChild(5, this.body);
        this.magic.set(ProfileMagic.MAGIC_PROF);
        version.set(ProfileVersion.V010_P);
    }

    @Override
    public ProfileMagic magic() {
        return this.magic;
    }

    @Override
    public ProfileVersion version() {
        return this.version;
    }

    @Override
    public ProfileDataBody body() {
        return this.body;
    }

    @Override
    public DexProfileData get(String name) {
        return (DexProfileData)super.get(name);
    }

    public Iterator<DexProfileData> iterator() {
        return this.body().iterator();
    }

    public void updateFileChecksum(File file) throws IOException {
        DexProfileData data = this.get(file.getName());
        if (data != null) {
            data.setChecksum(Crc32.of(file));
        }
    }

    public void updateChecksum(ZipEntryMap zipEntryMap) throws IOException {
        this.removeIfName(name -> !zipEntryMap.contains((String)name));
        Iterator<DexProfileData> iterator = this.iterator();
        while (iterator.hasNext()) {
            DexProfileData data = iterator.next();
            InputSource inputSource = zipEntryMap.getInputSource(data.getName());
            data.setChecksum(inputSource.getCrc());
        }
    }

    public static ProfileDataFile read(File file) throws IOException {
        ProfileDataFile profileDataFile = new ProfileDataFile();
        profileDataFile.readBytes(new BlockReader(file));
        return profileDataFile;
    }

    public static ProfileDataFile read(InputStream inputStream) throws IOException {
        ProfileDataFile profileDataFile = new ProfileDataFile();
        profileDataFile.readBytes(new BlockReader(inputStream));
        return profileDataFile;
    }

    public static void update(ZipEntryMap apk) throws IOException {
        InputSource source = apk.getInputSource(PATH_PROF);
        if (source == null) {
            return;
        }
        ProfileDataFile profileDataFile = ProfileDataFile.read(source.openStream());
        profileDataFile.updateChecksum(apk);
        profileDataFile.refresh();
        ByteInputSource update = new ByteInputSource(profileDataFile.getBytes(), PATH_PROF);
        update.copyAttributes(source);
        apk.add(update);
    }
}

