/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.dex.dexopt.DexProfileData;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.ProfileDataFile;
import com.reandroid.dex.dexopt.ProfileFile;
import com.reandroid.dex.dexopt.ProfileMetadata;
import com.reandroid.dex.dexopt.ProfileMetadataFile;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.Crc32;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class ProfileDirectory
implements LinkableProfileItem,
Closeable {
    private ProfileDataFile mProfileFile;
    private ProfileMetadataFile mMetadataFile;

    public boolean hasProfile() {
        return this.getProfileFile() != null;
    }

    public ProfileDataFile getProfileFile() {
        return this.mProfileFile;
    }

    public void setProfileFile(ProfileDataFile profileFile) {
        this.mProfileFile = profileFile;
    }

    public ProfileMetadataFile getMetadataFile() {
        return this.mMetadataFile;
    }

    public void setMetadataFile(ProfileMetadataFile metadataFile) {
        this.mMetadataFile = metadataFile;
    }

    public DexProfileData getProfile(String name) {
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            return profile.get(name);
        }
        return null;
    }

    public ProfileMetadata getMetadata(String name) {
        ProfileMetadataFile metadata = this.getMetadataFile();
        if (metadata != null) {
            return metadata.get(name);
        }
        return null;
    }

    public void removeIfName(Predicate<String> predicate) {
        ProfileFile profileFile = this.getProfileFile();
        if (profileFile != null) {
            profileFile.removeIfName(predicate);
        }
        if ((profileFile = this.getMetadataFile()) != null) {
            profileFile.removeIfName(predicate);
        }
    }

    public void ensureDexFile(String name) {
        ProfileFile profileFile = this.getProfileFile();
        if (profileFile != null) {
            profileFile.getOrCreate(name);
        }
        if ((profileFile = this.getMetadataFile()) != null) {
            profileFile.getOrCreate(name);
        }
    }

    public void readApk(ZipEntryMap apk) throws IOException {
        InputSource source;
        if (this.getProfileFile() == null && (source = apk.getInputSource(ProfileFile.PATH_PROF)) != null) {
            this.setProfileFile(ProfileDataFile.read(source.openStream()));
        }
        if (this.getMetadataFile() == null && (source = apk.getInputSource(ProfileFile.PATH_PROFM)) != null) {
            this.setMetadataFile(ProfileMetadataFile.read(source.openStream()));
        }
    }

    public void encodeJsonDir(File decodeDir) throws IOException {
        File fileProfm;
        File fileProf = new File(decodeDir, ProfileFile.JSON_NAME_PROF);
        if (fileProf.isFile()) {
            ProfileDataFile profile = this.getProfileFile();
            if (profile == null) {
                this.setProfileFile(new ProfileDataFile());
                profile = this.getProfileFile();
            }
            profile.fromJson(new JSONObject(fileProf));
        }
        if ((fileProfm = new File(decodeDir, ProfileFile.JSON_NAME_PROFM)).isFile()) {
            ProfileMetadataFile metadata = this.getMetadataFile();
            if (metadata == null) {
                this.setMetadataFile(new ProfileMetadataFile());
                metadata = this.getMetadataFile();
            }
            metadata.fromJson(new JSONObject(fileProfm));
        }
    }

    public void decodeToJsonDir(File decodeDir) throws IOException {
        File fileProf = new File(decodeDir, ProfileFile.JSON_NAME_PROF);
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            profile.toJson().write(fileProf);
        }
        File fileProfm = new File(decodeDir, ProfileFile.JSON_NAME_PROFM);
        ProfileMetadataFile metadata = this.getMetadataFile();
        if (metadata != null) {
            metadata.toJson().write(fileProfm);
        }
    }

    public void writeTo(File dexOptDir) throws IOException {
        ProfileFile profileFile = this.getProfileFile();
        if (profileFile != null) {
            profileFile.write(new File(dexOptDir, ProfileFile.NAME_PROF));
        }
        if ((profileFile = this.getMetadataFile()) != null) {
            profileFile.write(new File(dexOptDir, ProfileFile.NAME_PROFM));
        }
    }

    public void writeTo(ZipEntryMap zipEntryMap) {
        ProfileFile profileFile = this.getProfileFile();
        if (profileFile != null) {
            zipEntryMap.add(new ByteInputSource(profileFile.getBytes(), ProfileFile.PATH_PROF));
        }
        if ((profileFile = this.getMetadataFile()) != null) {
            zipEntryMap.add(new ByteInputSource(profileFile.getBytes(), ProfileFile.PATH_PROFM));
        }
    }

    public void updateChecksum(ZipEntryMap zipEntryMap) throws IOException {
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            profile.updateChecksum(zipEntryMap);
        }
    }

    public void updateFileChecksum(File file) throws IOException {
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            profile.updateFileChecksum(file);
        }
    }

    public void updateFileChecksum(InputSource inputSource) throws IOException {
        DexProfileData data = this.getProfile(inputSource.getAlias());
        if (data != null) {
            data.setChecksum(inputSource.getCrc());
        }
    }

    public void updateChecksumInDexDirectory(File dexRoot) throws IOException {
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            Iterator<DexProfileData> iterator = profile.iterator();
            while (iterator.hasNext()) {
                DexProfileData data = iterator.next();
                File file = new File(dexRoot, data.getName());
                if (!file.isFile()) continue;
                data.setChecksum(Crc32.of(file));
            }
        }
    }

    private void linkUninitialized(InputSource dexInputSource) throws IOException {
        String name = dexInputSource.getAlias();
        if (!this.isUninitialized(name)) {
            return;
        }
        DexProfileData data = this.getProfile(name);
        ProfileMetadata metadata = this.getMetadata(name);
        DexFile dexFile = DexFile.read(dexInputSource.openStream(), SectionType.minimal());
        dexFile.setSimpleName(name);
        if (data != null && !data.isInitialized()) {
            data.update(dexFile);
        }
        if (metadata != null && !metadata.isInitialized()) {
            metadata.update(dexFile);
        }
    }

    private void linkUninitialized(File file) throws IOException {
        String name = file.getName();
        if (!this.isUninitialized(name)) {
            return;
        }
        DexProfileData data = this.getProfile(name);
        ProfileMetadata metadata = this.getMetadata(name);
        DexFile dexFile = DexFile.read(file, SectionType.minimal());
        dexFile.setSimpleName(name);
        if (data != null && !data.isInitialized()) {
            data.update(dexFile);
        }
        if (metadata != null && !metadata.isInitialized()) {
            metadata.update(dexFile);
        }
    }

    private boolean isUninitialized(String name) {
        DexProfileData data = this.getProfile(name);
        ProfileMetadata metadata = this.getMetadata(name);
        if (data == null && metadata == null) {
            return false;
        }
        if (data != null && data.isInitialized() && (metadata == null || metadata.isInitialized())) {
            return false;
        }
        return metadata == null || !metadata.isInitialized() || data != null && !data.isInitialized();
    }

    public void syncApk(ZipEntryMap zipEntryMap) throws IOException {
        List<InputSource> dexList = ProfileDirectory.listDexFiles(zipEntryMap);
        if (dexList.isEmpty()) {
            return;
        }
        this.removeIfName(name -> !zipEntryMap.contains((String)name));
        for (InputSource inputSource : dexList) {
            this.ensureDexFile(inputSource.getAlias());
            this.linkUninitialized(inputSource);
            this.updateFileChecksum(inputSource);
        }
    }

    public void syncDexDirectory(File dexRoot) throws IOException {
        List<File> dexList = FileUtil.listClassesDex(dexRoot);
        if (dexList.isEmpty()) {
            return;
        }
        this.removeIfName(name -> {
            File file = new File(dexRoot, (String)name);
            return !dexList.contains(file);
        });
        for (File file : dexList) {
            this.ensureDexFile(file.getName());
            this.updateFileChecksum(file);
            this.linkUninitialized(file);
        }
    }

    public void syncSmaliDirectory(File smaliRoot) {
        List<File> smaliList = ProfileDirectory.listSmaliDirectories(smaliRoot);
        if (smaliList.isEmpty()) {
            return;
        }
        this.removeIfName(name -> {
            String ext = ".dex";
            if (!name.endsWith(ext)) {
                return true;
            }
            File file = new File(smaliRoot, name = name.substring(0, name.length() - ext.length()));
            return !smaliList.contains(file);
        });
        for (File file : smaliList) {
            this.ensureDexFile(file.getName() + ".dex");
        }
    }

    public void linkApk(ZipEntryMap zipEntryMap) throws IOException {
        List<InputSource> dexList = ProfileDirectory.listDexFiles(zipEntryMap);
        for (InputSource source : dexList) {
            this.linkDex(source);
        }
    }

    public void linkDex(InputSource inputSource) throws IOException {
        String name = inputSource.getAlias();
        DexProfileData profile = this.getProfile(name);
        ProfileMetadata metadata = this.getMetadata(name);
        if (profile == null && metadata == null) {
            return;
        }
        DexFile dexFile = DexFile.read(inputSource.openStream(), SectionType.minimal());
        dexFile.setSimpleName(name);
        if (profile != null) {
            profile.link(dexFile);
        }
        if (metadata != null) {
            metadata.link(dexFile);
        }
        dexFile.close();
    }

    public void updateDexDirectory(File dexRoot) throws IOException {
        List<File> dexList = FileUtil.listClassesDex(dexRoot);
        for (File file : dexList) {
            this.updateDexFile(file);
        }
    }

    public void updateDexFile(File file) throws IOException {
        String name = file.getName();
        DexProfileData profile = this.getProfile(name);
        ProfileMetadata metadata = this.getMetadata(name);
        if (profile == null && metadata == null) {
            return;
        }
        DexFile dexFile = DexFile.read(file, SectionType.minimal());
        dexFile.setSimpleName(name);
        if (profile != null) {
            profile.update(dexFile);
        }
        if (metadata != null) {
            metadata.update(dexFile);
        }
        dexFile.close();
    }

    @Override
    public void link(DexFile dexFile) {
        ProfileMetadataFile metadata;
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            profile.link(dexFile);
        }
        if ((metadata = this.getMetadataFile()) != null) {
            metadata.link(dexFile);
        }
    }

    @Override
    public void update(DexFile dexFile) {
        ProfileMetadataFile metadata;
        ProfileDataFile profile = this.getProfileFile();
        if (profile != null) {
            profile.update(dexFile);
        }
        if ((metadata = this.getMetadataFile()) != null) {
            metadata.update(dexFile);
        }
    }

    public void refresh() {
        ProfileFile profileFile = this.getProfileFile();
        if (profileFile != null) {
            profileFile.refresh();
        }
        if ((profileFile = this.getMetadataFile()) != null) {
            profileFile.refresh();
        }
    }

    @Override
    public void close() {
        this.setProfileFile(null);
        this.setMetadataFile(null);
    }

    public String toString() {
        return "DexOpt{profile=" + this.mProfileFile + ", metadata=" + this.mMetadataFile + '}';
    }

    private static List<InputSource> listDexFiles(ZipEntryMap zipEntryMap) {
        List<InputSource> results = CollectionUtil.toList(zipEntryMap.iteratorWithPath(path -> DexFile.getDexFileNumber(path) >= 0));
        results.sort((i1, i2) -> CompareUtil.compare(DexFile.getDexFileNumber(i1.getAlias()), DexFile.getDexFileNumber(i2.getAlias())));
        return results;
    }

    private static List<File> listSmaliDirectories(File root) {
        ArrayCollection<File> results = new ArrayCollection<File>();
        if (!root.isDirectory()) {
            return results;
        }
        File[] files = root.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            String name;
            if (!file.isDirectory() || DexFile.getDexFileNumber(name = file.getName() + ".dex") < 0) continue;
            results.add(file);
        }
        return results;
    }
}

