/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.ProfileBody;
import com.reandroid.dex.dexopt.ProfileData;
import com.reandroid.dex.dexopt.ProfileMagic;
import com.reandroid.dex.dexopt.ProfileVersion;
import com.reandroid.dex.model.DexFile;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class ProfileFile
extends FixedBlockContainer
implements LinkableProfileItem,
JSONConvert<JSONObject> {
    public static final String DECODE_DIR_NAME = ObjectsUtil.of("dexopt");
    public static final String NAME_PROF = ObjectsUtil.of("baseline.prof");
    public static final String NAME_PROFM = ObjectsUtil.of("baseline.profm");
    public static final String JSON_NAME_PROF = ObjectsUtil.of("baseline.prof.json");
    public static final String JSON_NAME_PROFM = ObjectsUtil.of("baseline.profm.json");
    public static final String PATH_PROF = ObjectsUtil.of("assets/dexopt/baseline.prof");
    public static final String PATH_PROFM = ObjectsUtil.of("assets/dexopt/baseline.profm");

    public ProfileFile(int childesCount) {
        super(childesCount);
    }

    public abstract ProfileMagic magic();

    public abstract ProfileVersion version();

    public abstract ProfileBody body();

    public ProfileData get(String name) {
        return this.body().get(name);
    }

    public ProfileData getOrCreate(String name) {
        ProfileData data = this.get(name);
        if (data == null) {
            data = this.body().createNew();
            data.setName(name);
        }
        return data;
    }

    public Iterator<? extends ProfileData> iterator() {
        return this.body().iterator();
    }

    public boolean removeIfName(Predicate<String> predicate) {
        return this.body().removeIfName(predicate);
    }

    public boolean removeData(String name) {
        return this.body().removeData(name);
    }

    public void syncApk(ZipEntryMap zipEntryMap) {
        this.removeIfName(name -> !zipEntryMap.contains((String)name));
        Iterator<InputSource> iterator = zipEntryMap.iteratorWithPath(path -> DexFile.getDexFileNumber(path) >= 0);
        while (iterator.hasNext()) {
            InputSource inputSource = iterator.next();
            this.getOrCreate(inputSource.getAlias());
        }
    }

    public void ensureDex(DexFile dexFile) {
        String name = dexFile.getSimpleName();
        if (StringsUtil.isEmpty(name)) {
            throw new IllegalArgumentException("Unnamed dex: " + dexFile);
        }
        ProfileData data = this.get(name);
        if (data != null) {
            return;
        }
        data = this.getOrCreate(name);
        data.update(dexFile);
    }

    @Override
    public void link(DexFile dexFile) {
        this.body().link(dexFile);
    }

    @Override
    public void update(DexFile dexFile) {
        this.body().update(dexFile);
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.body().refresh();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("magic", this.magic().get());
        jsonObject.put("version", this.version().name());
        jsonObject.put("body", this.body().toJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.magic().set(json.getInt("magic"));
        this.version().name(json.getString("version"));
        this.body().fromJson(json.getJSONArray("body"));
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream();
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public void write(File file) throws IOException {
        OutputStream outputStream = FileUtil.outputStream(file);
        this.writeBytes(outputStream);
        outputStream.close();
    }

    public String toString() {
        return "magic=" + this.magic() + ", version=" + this.version() + ", body=" + this.body();
    }
}

