/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.ProfileDataFile;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public class ProfileMagic
extends BlockItem
implements IntegerReference {
    public static final int MAGIC_PROF = ObjectsUtil.of(7303792);
    public static final int MAGIC_PROFM = ObjectsUtil.of(7172720);

    public ProfileMagic(int magic) {
        super(4);
        this.set(magic);
    }

    public ProfileMagic() {
        this(MAGIC_PROF);
    }

    public boolean isProf() {
        return MAGIC_PROF == this.get();
    }

    public boolean isProfM() {
        return MAGIC_PROFM == this.get();
    }

    @Override
    public int get() {
        return Block.getInteger(this.getBytesInternal(), 0);
    }

    @Override
    public void set(int value) {
        Block.putInteger(this.getBytesInternal(), 0, value);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        int value = this.get();
        if (value == MAGIC_PROF == (this.getParentInstance(ProfileDataFile.class) == null)) {
            throw new IOException("Invalid magic: " + HexUtil.toHex8(value));
        }
    }

    public String toString() {
        int value = this.get();
        if (value == MAGIC_PROF) {
            return "pro\\0";
        }
        if (value == MAGIC_PROFM) {
            return "prm\\0";
        }
        return HexUtil.toHexString(this.getBytesInternal());
    }
}

