/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.BooleanReference;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.dexopt.ProfileDataFile;
import com.reandroid.dex.dexopt.ProfileMetadataFile;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public class ProfileVersion
extends BlockItem {
    public static final int V015_S = ObjectsUtil.of(3486000);
    public static final int V010_P = ObjectsUtil.of(0x303130);
    public static final int V009_O_MR1 = ObjectsUtil.of(0x393030);
    public static final int V005_O = ObjectsUtil.of(0x353030);
    public static final int V001_N = ObjectsUtil.of(0x313030);
    public static final int METADATA_V001_N = ObjectsUtil.of(0x313030);
    public static final int METADATA_V002 = ObjectsUtil.of(0x323030);

    public ProfileVersion() {
        super(4);
    }

    public int get() {
        return Block.getInteger(this.getBytesInternal(), 0);
    }

    public void set(int value) {
        Block.putInteger(this.getBytesInternal(), 0, value);
    }

    public void set(byte[] value) {
        System.arraycopy(value, 0, this.getBytesInternal(), 0, 4);
    }

    public String name() {
        int value = this.get();
        if (value == V015_S) {
            return "V015_S";
        }
        if (value == V010_P) {
            return "V010_P";
        }
        if (value == V009_O_MR1) {
            return "V009_O_MR1";
        }
        if (value == V005_O) {
            return "V005_O";
        }
        if (value == V001_N && this.getParentInstance(ProfileDataFile.class) != null) {
            return "V001_N";
        }
        if (value == METADATA_V001_N && this.getParentInstance(ProfileMetadataFile.class) != null) {
            return "METADATA_V001_N";
        }
        if (value == METADATA_V002) {
            return "METADATA_V002";
        }
        return HexUtil.toHex8(value);
    }

    public void name(String name) {
        int value;
        if ("V015_S".equals(name)) {
            value = V015_S;
        } else if ("V010_P".equals(name)) {
            value = V010_P;
        } else if ("V009_O_MR1".equals(name)) {
            value = V009_O_MR1;
        } else if ("V005_O".equals(name)) {
            value = V005_O;
        } else if ("V001_N".equals(name)) {
            value = V001_N;
        } else if ("METADATA_V001_N".equals(name)) {
            value = METADATA_V001_N;
        } else if ("METADATA_V002".equals(name)) {
            value = METADATA_V002;
        } else {
            throw new RuntimeException("Unknown version name: '" + name + "'");
        }
        this.set(value);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        if (!ProfileVersion.isSupported(this.get())) {
            throw new IOException("Unsupported version: " + this.get() + " (" + this.toString() + ")");
        }
    }

    boolean hasDeflatedBody() {
        int v = this.get();
        return v == V010_P || v == METADATA_V001_N || v == METADATA_V002;
    }

    public IntegerItem newBodySize() {
        return new IntegerItem(){

            @Override
            public boolean isNull() {
                return super.isNull() || !ProfileVersion.this.hasDeflatedBody();
            }
        };
    }

    public BooleanReference isMetadataV001() {
        return new BooleanReference(){

            @Override
            public boolean get() {
                return ProfileVersion.this.get() == METADATA_V001_N;
            }

            @Override
            public void set(boolean value) {
            }

            public String toString() {
                return Boolean.toString(this.get());
            }
        };
    }

    public BooleanReference isDeflatedBody() {
        return new BooleanReference(){

            @Override
            public boolean get() {
                return ProfileVersion.this.hasDeflatedBody();
            }

            @Override
            public void set(boolean value) {
            }

            public String toString() {
                return Boolean.toString(this.get());
            }
        };
    }

    public String toString() {
        return this.name();
    }

    public static boolean isSupported(int version) {
        return version == V010_P || version == METADATA_V002;
    }
}

