/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.IdItemIndirectReference;
import com.reandroid.dex.reference.IdItemIndirectShortReference;
import com.reandroid.dex.reference.IndirectStringReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class FieldId
extends IdItem
implements Comparable<FieldId> {
    private final IdItemIndirectReference<TypeId> defining = new IdItemIndirectShortReference<TypeId>(SectionType.TYPE_ID, this, 0, USAGE_FIELD_CLASS);
    private final IdItemIndirectReference<TypeId> fieldType = new IdItemIndirectShortReference<TypeId>(SectionType.TYPE_ID, this, 2, USAGE_FIELD_TYPE);
    private final IndirectStringReference nameReference = new IndirectStringReference(this, 4, USAGE_FIELD_NAME);

    public FieldId() {
        super(8);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.singleThree(this, SingleIterator.of(this.defining.getItem()), SingleIterator.of(this.nameReference.getItem()), SingleIterator.of(this.fieldType.getItem()));
    }

    public String getName() {
        return this.nameReference.getString();
    }

    public StringKey getNameKey() {
        return this.nameReference.getKey();
    }

    public void setName(StringKey name) {
        this.nameReference.setKey(name);
    }

    public void setName(String name) {
        this.nameReference.setString(name);
    }

    public StringId getNameId() {
        return (StringId)this.nameReference.getItem();
    }

    IndirectStringReference getNameReference() {
        return this.nameReference;
    }

    public String getClassName() {
        TypeId typeId = this.getDefiningId();
        if (typeId != null) {
            return typeId.getName();
        }
        return null;
    }

    public TypeKey getDefining() {
        return (TypeKey)this.defining.getKey();
    }

    public void setDefining(TypeKey typeKey) {
        this.defining.setKey(typeKey);
    }

    public TypeId getDefiningId() {
        return (TypeId)this.defining.getItem();
    }

    public void setDefining(TypeId typeId) {
        this.defining.setItem(typeId);
    }

    public TypeKey getFieldType() {
        return (TypeKey)this.fieldType.getKey();
    }

    public void setFieldType(TypeKey typeKey) {
        this.fieldType.setKey(typeKey);
    }

    public TypeId getFieldTypeId() {
        return (TypeId)this.fieldType.getItem();
    }

    public void setFieldType(TypeId typeId) {
        this.fieldType.setItem(typeId);
    }

    @Override
    public void refresh() {
        this.defining.refresh();
        this.fieldType.refresh();
        this.nameReference.refresh();
    }

    @Override
    void cacheItems() {
        this.defining.pullItem();
        this.fieldType.pullItem();
        this.nameReference.pullItem();
    }

    public SectionType<FieldId> getSectionType() {
        return SectionType.FIELD_ID;
    }

    @Override
    public FieldKey getKey() {
        return this.checkKey(FieldKey.create(this.getDefining(), this.getNameKey(), this.getFieldType()));
    }

    @Override
    public void setKey(Key key) {
        this.setKey((FieldKey)key);
    }

    public void setKey(FieldKey key) {
        FieldKey old = this.getKey();
        if (ObjectsUtil.equals(key, old)) {
            return;
        }
        this.defining.setKey(key.getDeclaring());
        this.nameReference.setKey(key.getNameKey());
        this.fieldType.setKey(key.getType());
        this.keyChanged(old);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.append(writer, true);
    }

    public void append(SmaliWriter writer, boolean appendDefining) throws IOException {
        if (appendDefining) {
            writer.appendRequired(this.getDefiningId());
            writer.append("->");
        }
        writer.append(this.getName());
        writer.append(':');
        writer.appendRequired(this.getFieldTypeId());
    }

    @Override
    public int compareTo(FieldId fieldId) {
        if (fieldId == null) {
            return -1;
        }
        int i = CompareUtil.compare(this.getDefiningId(), fieldId.getDefiningId());
        if (i != 0) {
            return i;
        }
        i = CompareUtil.compare(this.getNameReference(), fieldId.getNameReference());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getFieldTypeId(), fieldId.getFieldTypeId());
    }

    public String toString() {
        FieldKey key = this.getKey();
        if (key != null) {
            return key.toString();
        }
        return this.getDefiningId() + "->" + this.getNameId() + ":" + this.getFieldTypeId();
    }

    public static boolean equals(FieldId fieldId1, FieldId fieldId2) {
        return FieldId.equals(false, fieldId1, fieldId2);
    }

    public static boolean equals(boolean ignoreClass, FieldId fieldId1, FieldId fieldId2) {
        if (fieldId1 == fieldId2) {
            return true;
        }
        if (fieldId1 == null) {
            return false;
        }
        if (!IndirectStringReference.equals(fieldId1.getNameReference(), fieldId2.getNameReference())) {
            return false;
        }
        return ignoreClass || TypeId.equals(fieldId1.getDefiningId(), fieldId2.getDefiningId());
    }
}

