/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.StringData;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public class StringId
extends IdItem
implements IntegerReference,
Comparable<StringId> {
    private StringData stringData;

    public StringId() {
        super(4);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public SectionType<StringId> getSectionType() {
        return SectionType.STRING_ID;
    }

    @Override
    public StringKey getKey() {
        StringData stringData = this.getStringData();
        if (stringData != null) {
            return stringData.getKey();
        }
        return null;
    }

    @Override
    public void setKey(Key key) {
        this.requireStringData();
        StringKey oldKey = this.getKey();
        StringData stringData = this.getStringData();
        StringKey update = stringData.updateString((StringKey)key);
        if (oldKey != update) {
            this.keyChanged(oldKey);
        }
    }

    @Override
    public void onRemovedInternal() {
        StringData stringData = this.stringData;
        if (stringData != null) {
            stringData.removeSelf(this);
            this.stringData = null;
        }
    }

    public StringData getStringData() {
        return this.stringData;
    }

    public void linkStringData(StringData stringData) {
        if (this.stringData == stringData) {
            return;
        }
        if (this.stringData != null) {
            throw new IllegalArgumentException("String data already linked");
        }
        this.stringData = stringData;
        stringData.setOffsetReference(this);
    }

    @Override
    public void set(int value) {
        StringId.putInteger(this.getBytesInternal(), 0, value);
    }

    @Override
    public int get() {
        return StringId.getInteger(this.getBytesInternal(), 0);
    }

    @Override
    public void refresh() {
        this.set(this.stringData.getOffset());
    }

    @Override
    void cacheItems() {
    }

    private void requireStringData() {
        StringData stringData = this.getStringData();
        if (stringData == null) {
            if (this.isRemoved()) {
                throw new IllegalArgumentException("Removed string id, index = " + this.getIndex() + ", offset = " + this.get());
            }
            throw new IllegalArgumentException("Unlinked string id, index = " + this.getIndex() + ", offset = " + this.get());
        }
    }

    public String getString() {
        StringData stringData = this.getStringData();
        if (stringData != null) {
            return stringData.getString();
        }
        return null;
    }

    public void setString(String text) {
        this.setKey(StringKey.create(text));
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.getStringData().onReadBytes(reader);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        StringData stringData = this.getStringData();
        if (stringData != null) {
            stringData.append(writer);
        }
    }

    @Override
    public int compareTo(StringId stringId) {
        if (stringId == null) {
            return -1;
        }
        if (stringId == this) {
            return 0;
        }
        return SectionTool.compareIndex(this.getStringData(), stringId.getStringData());
    }

    public String toString() {
        StringData stringData = this.getStringData();
        if (stringData != null) {
            return stringData.toString();
        }
        if (this.isRemoved()) {
            return "REMOVED";
        }
        return "Unlinked index = " + this.getIndex() + ", offset = " + this.get();
    }

    public static boolean equals(StringId stringId1, StringId stringId2) {
        if (stringId1 == stringId2) {
            return true;
        }
        if (stringId1 == null) {
            return false;
        }
        return ObjectsUtil.equals(stringId1.getStringData(), stringId2.getStringData());
    }
}

