/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.ins.HandlerOffset;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class HandlerOffsetArray
extends CountedBlockList<HandlerOffset> {
    private int itemsStart;
    private static final Creator<HandlerOffset> CREATOR = HandlerOffset::new;

    public HandlerOffsetArray(IntegerReference itemCount) {
        super(CREATOR, itemCount);
    }

    public HandlerOffset getOrCreate(int index) {
        this.ensureSize(index + 1);
        return this.getHandlerOffset(index);
    }

    public HandlerOffset getHandlerOffset(int index) {
        HandlerOffset handlerOffset = (HandlerOffset)this.get(index);
        if (handlerOffset == null) {
            return null;
        }
        if (handlerOffset.getIdx() == index) {
            return handlerOffset;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            handlerOffset = (HandlerOffset)this.get(i);
            if (handlerOffset.getIdx() != index) continue;
            return handlerOffset;
        }
        return null;
    }

    int getOffset(int i) {
        HandlerOffset offset = (HandlerOffset)this.get(i);
        if (offset != null) {
            return offset.getOffset();
        }
        return -1;
    }

    @Override
    int indexOf(int value) {
        if (value < 0) {
            return -1;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (value != this.getOffset(i)) continue;
            return i;
        }
        return -1;
    }

    int getItemsStart() {
        return this.itemsStart;
    }

    int getMinStart() {
        int result = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int offset = this.getOffset(i);
            if (i != 0 && offset >= result) continue;
            result = offset;
        }
        return result;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.itemsStart = reader.getPosition();
    }

    public void merge(HandlerOffsetArray offsetArray) {
        if (offsetArray == this) {
            return;
        }
        int size = offsetArray.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            HandlerOffset coming = (HandlerOffset)offsetArray.get(i);
            HandlerOffset offset = (HandlerOffset)this.get(i);
            offset.merge(coming);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.size();
        builder.append("size = ");
        builder.append(size);
        builder.append('[');
        builder.append(StringsUtil.join(this.iterator(), (Object)", "));
        builder.append(']');
        return builder.toString();
    }
}

