/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.id.StringId;
import com.reandroid.dex.ins.ConstString;
import com.reandroid.dex.ins.Ins31c;
import com.reandroid.dex.ins.InsConstString;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.StringKey;

public class InsConstStringJumbo
extends Ins31c
implements ConstString {
    public InsConstStringJumbo() {
        super(Opcode.CONST_STRING_JUMBO);
    }

    @Override
    public String getString() {
        StringId stringId = this.getStringId();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    @Override
    public void setString(StringKey key) {
        super.setKey(key);
    }

    @Override
    public int getRegister() {
        return this.getRegister(0);
    }

    @Override
    public void setRegister(int register) {
        this.setRegister(0, register);
    }

    public StringId getStringId() {
        return this.getSectionId();
    }

    @Override
    public StringId getSectionId() {
        return (StringId)super.getSectionId();
    }

    @Override
    public StringKey getKey() {
        return (StringKey)super.getKey();
    }

    public InsConstString toConstString() {
        if (this.getParent() == null) {
            return null;
        }
        StringId stringId = this.getSectionId();
        if (stringId == null || !this.needsConvertToConstString(stringId)) {
            return null;
        }
        InsConstString constString = this.replace(Opcode.CONST_STRING);
        constString.setRegister(this.getRegister());
        constString.setSectionId(stringId);
        return constString;
    }

    private boolean needsConvertToConstString(StringId stringId) {
        int index = stringId.getIndex();
        return index == (index & 0xFFFF);
    }
}

