/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.Ins31t;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.Opcode;
import java.util.Iterator;

public abstract class InsSwitch
extends Ins31t {
    private InsSwitchPayload switchPayload;

    public InsSwitch(Opcode<?> opcode) {
        super(opcode);
    }

    public InsSwitchPayload getPayload() {
        InsSwitchPayload switchPayload = this.switchPayload;
        if (switchPayload == null && (switchPayload = this.findByAddress()) != null) {
            this.switchPayload = switchPayload;
            switchPayload.setSwitch(this);
        }
        return switchPayload;
    }

    public void setPayload(InsSwitchPayload switchPayload) {
        this.switchPayload = switchPayload;
        this.setTargetAddress(switchPayload.getAddress());
    }

    private InsSwitchPayload findByAddress() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            Iterator<? extends InsSwitchPayload> iterator = instructionList.iterator(this.getPayloadOpcode());
            int address = this.getTargetAddress();
            while (iterator.hasNext()) {
                InsSwitchPayload switchPayload = iterator.next();
                if (switchPayload.getAddress() != address) continue;
                return switchPayload;
            }
        }
        return null;
    }

    public abstract Opcode<? extends InsSwitchPayload> getPayloadOpcode();
}

