/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsNop;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadEntry;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.model.SmaliInstruction;
import java.util.Iterator;

public abstract class PayloadData<T extends PayloadEntry>
extends Ins
implements SmaliRegion,
Iterable<T> {
    public PayloadData(int childesCount, Opcode<?> opcode) {
        super(childesCount + 1, opcode);
        ShortItem opcodeItem = new ShortItem();
        opcodeItem.set(opcode.getValue());
        this.addChild(0, opcodeItem);
    }

    @Override
    public abstract Iterator<T> iterator();

    public abstract T get(int var1);

    public abstract int size();

    public abstract void setSize(int var1);

    public boolean isEmpty() {
        return this.size() == 0;
    }

    Object requestLock() {
        InsBlockList insBlockList = this.getInsBlockList();
        if (insBlockList != null) {
            return insBlockList.linkLocked();
        }
        return null;
    }

    void releaseLock(Object lock) {
        if (lock != null) {
            this.getInsBlockList().unlinkLocked(lock);
        }
    }

    void updateNopAlignment() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList == null) {
            return;
        }
        int position = instructionList.countUpTo(this);
        if (position % 4 == 0) {
            return;
        }
        InsNop insNop = this.getNopAlignment();
        if (insNop != null) {
            instructionList.remove(insNop);
        } else {
            instructionList.add(false, this.getIndex(), (Ins)Opcode.NOP.newInstance());
        }
    }

    private InsNop getNopAlignment() {
        Ins ins;
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null && (ins = instructionList.get(this.getIndex() - 1)) instanceof InsNop) {
            return (InsNop)ins;
        }
        return null;
    }

    @Override
    protected void onPreRefresh() {
        this.updateNopAlignment();
        super.onPreRefresh();
    }

    public abstract Iterator<IntegerReference> getReferences();

    @Override
    public abstract void fromSmali(SmaliInstruction var1);

    @Override
    void toSmaliOperand(SmaliInstruction instruction) {
        super.toSmaliOperand(instruction);
    }

    @Override
    void toSmaliOthers(SmaliInstruction instruction) {
        super.toSmaliOthers(instruction);
        this.toSmaliEntries(instruction);
    }

    void toSmaliEntries(SmaliInstruction instruction) {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PayloadData payloadData = (PayloadData)obj;
        if (this.getIndex() != payloadData.getIndex()) {
            return false;
        }
        return Block.areEqual(this.getChildes(), payloadData.getChildes());
    }

    public int hashCode() {
        return Block.hashCodeOf(this.getChildes()) + this.getIndex();
    }
}

