/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.RegistersSet;
import com.reandroid.dex.ins.RegistersSetEditor;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.util.Iterator;

public class RegistersEditor
implements ArraySupplier<RegistersSetEditor>,
Iterable<RegistersSetEditor> {
    private final RegistersTable registersTable;
    private RegistersSetEditor[] elements;
    private int size;
    public static final RegistersEditor EMPTY = new RegistersEditor(null){

        @Override
        public int getLocalRegistersCount() {
            throw new IllegalArgumentException("Empty RegistersEditor");
        }

        @Override
        public void setLocalRegistersCount(int count) {
            throw new IllegalArgumentException("Empty RegistersEditor");
        }

        @Override
        public void add(Iterator<RegistersSetEditor> iterator) {
            if (iterator == null || !iterator.hasNext()) {
                return;
            }
            throw new IllegalArgumentException("Empty RegistersEditor");
        }

        @Override
        public void add(RegistersSetEditor reg) {
            if (reg != null) {
                throw new IllegalArgumentException("Empty RegistersEditor");
            }
        }

        @Override
        public Iterator<RegistersSetEditor> iterator() {
            return EmptyIterator.of();
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public RegistersSetEditor get(int i) {
            throw new IllegalArgumentException("Empty RegistersEditor");
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public void trimToSize() {
        }
    };
    private static final int DEFAULT_CAPACITY = 100;

    public RegistersEditor(RegistersTable registersTable) {
        this.registersTable = registersTable;
    }

    public void apply() {
        for (RegistersSetEditor editor : this) {
            editor.apply();
        }
    }

    public void addLocalRegistersCount(int amount) {
        this.setLocalRegistersCount(this.getLocalRegistersCount() + amount);
    }

    public int getLocalRegistersCount() {
        RegistersTable table = this.getRegistersTable();
        return table.getRegistersCount() - table.getParameterRegistersCount();
    }

    public void setLocalRegistersCount(int count) {
        RegistersTable table = this.getRegistersTable();
        int param = table.getParameterRegistersCount();
        table.setRegistersCount(count + param);
    }

    public int getParameterRegistersCount() {
        RegistersTable table = this.getRegistersTable();
        return table.getParameterRegistersCount();
    }

    public RegistersTable getRegistersTable() {
        return this.registersTable;
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        RegistersSetEditor[] elements = this.elements;
        if (elements == null) {
            return false;
        }
        for (RegistersSetEditor reg : elements) {
            if (!obj.equals(reg)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.getCount() != 0;
    }

    @Override
    public Iterator<RegistersSetEditor> iterator() {
        return ArraySupplierIterator.of(this);
    }

    @Override
    public RegistersSetEditor get(int i) {
        if (this.elements != null) {
            return this.elements[i];
        }
        return null;
    }

    @Override
    public int getCount() {
        return this.size;
    }

    public void add(Iterator<RegistersSetEditor> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(RegistersSetEditor editor) {
        if (editor == null) {
            return;
        }
        this.ensureCapacity();
        this.elements[this.size] = editor;
        ++this.size;
    }

    public void trimToSize() {
        if (this.availableCapacity() == 0) {
            return;
        }
        int size = this.size;
        if (size == 0) {
            this.elements = null;
            return;
        }
        RegistersSetEditor[] update = new RegistersSetEditor[size];
        System.arraycopy(this.elements, 0, update, 0, size);
        this.elements = update;
    }

    private void ensureCapacity() {
        int capacity = this.size == 0 ? 1 : 100;
        this.ensureCapacity(capacity);
    }

    private void ensureCapacity(int capacity) {
        if (this.availableCapacity() >= capacity) {
            return;
        }
        int size = this.size;
        int length = size + capacity;
        RegistersSetEditor[] update = new RegistersSetEditor[length];
        RegistersSetEditor[] elements = this.elements;
        if (elements == null || size == 0) {
            this.elements = update;
            return;
        }
        System.arraycopy(elements, 0, update, 0, size);
        this.elements = update;
    }

    private int availableCapacity() {
        RegistersSetEditor[] elements = this.elements;
        if (elements != null) {
            return elements.length - this.size;
        }
        return 0;
    }

    public static RegistersEditor fromIns(RegistersTable registersTable, Iterator<Ins> iterator) {
        return RegistersEditor.of(registersTable, InstanceIterator.of(iterator, RegistersSet.class));
    }

    public static RegistersEditor of(RegistersTable registersTable, Iterator<RegistersSet> iterator) {
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        RegistersEditor registersEditor = new RegistersEditor(registersTable);
        while (iterator.hasNext()) {
            RegistersSet registersSet = iterator.next();
            RegistersSetEditor editor = RegistersSetEditor.of(registersTable, registersSet);
            registersEditor.add(editor);
        }
        return registersEditor;
    }
}

