/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.HandlerOffset;
import com.reandroid.dex.ins.HandlerOffsetArray;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.TryItem;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class TryBlock
extends FixedDexContainerWithTool
implements Creator<TryItem>,
Iterable<TryItem>,
LabelsSet,
IdUsageIterator {
    private final CodeItem codeItem;
    private HandlerOffsetArray handlerOffsetArray;
    private Ule128Item tryItemsCount;
    private ByteArray unknownBytes;
    private BlockList<TryItem> tryItemArray;
    private DexPositionAlign positionAlign;
    private static final int INDEX_offsetArray = 0;
    private static final int INDEX_itemsCount = 1;
    private static final int INDEX_unknownBytes = 2;
    private static final int INDEX_itemArray = 3;
    private static final int INDEX_positionAlign = 4;

    public TryBlock(CodeItem codeItem) {
        super(5);
        this.codeItem = codeItem;
    }

    InstructionList getInstructionList() {
        return this.getCodeItem().getInstructionList();
    }

    private CodeItem getCodeItem() {
        return this.codeItem;
    }

    public int getTryItemCount() {
        if (this.isNull()) {
            return 0;
        }
        return this.tryItemArray.getCount();
    }

    public Iterator<Label> getLabels() {
        return new ExpandIterator<Label>(this.iterator());
    }

    public TryItem createNext() {
        this.initialize();
        TryItem tryItem = this.newInstance();
        this.add(tryItem);
        return tryItem;
    }

    public TryItem createNextCopy(TryItem base) {
        TryItem tryItem = base.newCompact();
        this.add(tryItem);
        return tryItem;
    }

    private void add(TryItem tryItem) {
        if (this.tryItemArray != null) {
            this.tryItemArray.add(tryItem);
            this.handlerOffsetArray.ensureSize(this.tryItemArray.size());
        }
    }

    public TryItem get(int i) {
        if (this.tryItemArray != null) {
            return this.tryItemArray.get(i);
        }
        return null;
    }

    public Iterator<TryItem> getTriesForAddress(int address) {
        return FilterIterator.of(this.iterator(), tryItem -> tryItem.hasExceptionHandlersForAddress(address));
    }

    @Override
    public Iterator<TryItem> iterator() {
        if (this.isNull()) {
            return EmptyIterator.of();
        }
        return this.tryItemArray.iterator();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        if (this.isNull()) {
            return;
        }
        BlockList<TryItem> array = this.tryItemArray;
        array.removeIf(TryItem::isEmpty);
        this.updateHandlerOffsets();
        if (this.isEmpty()) {
            this.setNull(true);
        } else {
            this.positionAlign.align(this);
        }
    }

    private void updateHandlerOffsets() {
        Ule128Item tryItemsCount = this.tryItemsCount;
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null || tryItemsCount == null) {
            return;
        }
        int size = array.size();
        int realTryItemCount = 0;
        for (int i = 0; i < size; ++i) {
            TryItem tryItem = array.get(i);
            if (tryItem.isCompact()) continue;
            ++realTryItemCount;
        }
        tryItemsCount.set(realTryItemCount);
        int baseOffset = tryItemsCount.countBytes();
        HandlerOffsetArray offsetArray = this.handlerOffsetArray;
        offsetArray.setSize(size);
        for (int i = 0; i < size; ++i) {
            TryItem tryItem = array.get(i);
            HandlerOffset handlerOffset = (HandlerOffset)offsetArray.get(i);
            int offset = array.countUpTo(tryItem);
            handlerOffset.setOffset(offset += baseOffset);
        }
    }

    private HandlerOffsetArray initHandlersOffset() {
        if (this.handlerOffsetArray == null) {
            this.handlerOffsetArray = new HandlerOffsetArray(this.getCodeItem().getTryCountReference());
            this.addChild(0, this.handlerOffsetArray);
        }
        return this.handlerOffsetArray;
    }

    private void initTryItemArray() {
        if (this.tryItemArray != null) {
            return;
        }
        this.tryItemsCount = new Ule128Item();
        this.addChild(1, this.tryItemsCount);
        this.tryItemArray = new BlockList<TryItem>(this);
        this.addChild(3, this.tryItemArray);
    }

    public boolean isEmpty() {
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        return tryItemArray == null || tryItemArray.size() == 0;
    }

    @Override
    public boolean isNull() {
        return this.tryItemArray == null;
    }

    @Override
    public void setNull(boolean is_null) {
        if (is_null == this.isNull()) {
            return;
        }
        if (is_null) {
            this.clear();
        } else {
            this.initialize();
        }
    }

    private void initialize() {
        this.initHandlersOffset();
        this.initTryItemArray();
        if (this.positionAlign == null) {
            this.positionAlign = new DexPositionAlign();
            this.addChild(4, this.positionAlign);
        }
    }

    private void clear() {
        if (this.handlerOffsetArray != null) {
            this.handlerOffsetArray.setParent(null);
            this.handlerOffsetArray.setIndex(-1);
            this.handlerOffsetArray = null;
        }
        if (this.tryItemsCount != null) {
            this.tryItemsCount.setParent(null);
            this.tryItemsCount.setIndex(-1);
            this.tryItemArray = null;
        }
        if (this.tryItemArray != null) {
            this.tryItemArray.clearChildes();
            this.tryItemArray.setParent(null);
            this.tryItemArray.setIndex(-1);
            this.tryItemArray = null;
        }
        if (this.positionAlign != null) {
            this.positionAlign.setParent(null);
            this.positionAlign.setIndex(-1);
            this.positionAlign = null;
        }
        this.addChild(0, null);
        this.addChild(1, null);
        this.addChild(2, null);
        this.addChild(3, null);
        this.addChild(4, null);
    }

    public void remove(TryItem tryItem) {
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        if (tryItemArray != null && tryItemArray.remove(tryItem)) {
            tryItem.onRemove();
        }
    }

    public void moveTo(TryItem tryItem, int index) {
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        if (tryItemArray != null && tryItem.getIndex() != index) {
            tryItemArray.moveTo(tryItem, index);
            this.handlerOffsetArray.moveTo(tryItem.getHandlerOffset(), index);
        }
    }

    public void onRemove() {
        DexPositionAlign positionAlign;
        HandlerOffsetArray array;
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        if (tryItemArray != null) {
            this.tryItemArray = null;
            int count = tryItemArray.getCount();
            for (int i = 0; i < count; ++i) {
                TryItem tryItem = tryItemArray.getLast();
                tryItem.onRemove();
            }
            tryItemArray.clearChildes();
        }
        if ((array = this.handlerOffsetArray) != null) {
            array.setSize(0);
            this.handlerOffsetArray = null;
        }
        if ((positionAlign = this.positionAlign) != null) {
            this.positionAlign = null;
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean is_null = this.getCodeItem().getTryCountReference().get() == 0;
        this.setNull(is_null);
        if (is_null) {
            return;
        }
        this.handlerOffsetArray.onReadBytes(reader);
        this.tryItemsCount.onReadBytes(reader);
        this.readUnknownBytes(reader);
        this.tryItemArray.setSize(this.handlerOffsetArray.size());
        this.tryItemArray.readChildes(reader);
        this.positionAlign.onReadBytes(reader);
    }

    private void setUnknownBytes(int count) {
        if (count <= 0 || this.isNull()) {
            ByteArray unknown = this.unknownBytes;
            if (unknown != null) {
                unknown.setParent(null);
                unknown.setIndex(-1);
                unknown.setSize(0);
                this.unknownBytes = null;
            }
            return;
        }
        ByteArray unknown = this.unknownBytes;
        if (unknown == null) {
            this.unknownBytes = unknown = new ByteArray(count);
            unknown.setParent(this);
            this.addChild(2, unknown);
        } else {
            unknown.setSize(count);
        }
    }

    private void readUnknownBytes(BlockReader reader) throws IOException {
        int minStart = this.handlerOffsetArray.getMinStart();
        this.setUnknownBytes(minStart -= this.tryItemsCount.countBytes());
        ByteArray unknown = this.unknownBytes;
        if (unknown != null) {
            unknown.readBytes(reader);
        }
    }

    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    @Override
    public TryItem newInstance() {
        return new TryItem(this.initHandlersOffset());
    }

    @Override
    public TryItem newInstanceAt(int index) {
        BlockList<TryItem> tryItemArray = this.tryItemArray;
        HandlerOffsetArray offsetArray = this.initHandlersOffset();
        if (tryItemArray.size() < 2) {
            return new TryItem(offsetArray);
        }
        int i = offsetArray.indexOf(offsetArray.getOffset(index));
        TryItem tryItem = null;
        if (i >= 0 && i < index && (tryItem = tryItemArray.get(i)) != null) {
            tryItem = tryItem.newCompact();
        }
        if (tryItem == null) {
            tryItem = new TryItem(offsetArray);
        }
        return tryItem;
    }

    public boolean compactSimilarCatches() {
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null) {
            return false;
        }
        boolean result = false;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            TryItem base = array.get(i);
            if (base.isCompact()) continue;
            for (int j = i + 1; j < size; ++j) {
                TryItem tryItem = array.get(j);
                if (!base.compactWith(tryItem)) continue;
                result = true;
            }
        }
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean flattenCompactCatches() {
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null) {
            return false;
        }
        boolean result = false;
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            if (!array.get(i).flatten()) continue;
            result = true;
        }
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean splitTryHandlers() {
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null) {
            return false;
        }
        this.flattenCompactCatches();
        boolean result = false;
        for (int i = 0; i < array.size(); ++i) {
            TryItem tryItem = array.get(i);
            if (!tryItem.splitHandlers()) continue;
            result = true;
        }
        if (result) {
            this.refresh();
        }
        return result;
    }

    public boolean combineTries() {
        BlockList<TryItem> array = this.tryItemArray;
        if (array == null) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < array.size(); ++i) {
            TryItem base = array.get(i);
            if (base.isCompact()) continue;
            for (int j = i + 1; j < array.size(); ++j) {
                TryItem tryItem = array.get(j);
                if (!base.combineWith(tryItem)) continue;
                tryItem.removeSelf();
                result = true;
            }
        }
        if (result) {
            this.refresh();
        }
        return result;
    }

    public void merge(TryBlock tryBlock) {
        boolean is_null = tryBlock.isNull();
        this.setNull(is_null);
        if (is_null) {
            return;
        }
        int count = tryBlock.getTryItemCount();
        for (int i = 0; i < count; ++i) {
            TryItem comingSource;
            TryItem coming = tryBlock.get(i);
            TryItem tryItem = coming != (comingSource = coming.getTryItem()) ? this.get(comingSource.getIndex()).newCompact() : this.newInstance();
            this.add(tryItem);
            tryItem.merge(coming);
        }
        this.updateHandlerOffsets();
    }

    public void fromSmali(SmaliCodeTryItem smaliCodeTryItem) {
        this.createNext().fromSmali(smaliCodeTryItem);
        this.updateHandlerOffsets();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<TryItem, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(TryItem tryItem) {
                return tryItem.usedIds();
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryBlock tryBlock = (TryBlock)obj;
        if (this.isNull()) {
            return tryBlock.isNull();
        }
        return Objects.equals(this.handlerOffsetArray, tryBlock.handlerOffsetArray) && Objects.equals(this.tryItemArray, tryBlock.tryItemArray);
    }

    public int hashCode() {
        int hash = 1;
        BlockList obj = this.handlerOffsetArray;
        hash *= 31;
        if (obj != null) {
            hash += ((Object)obj).hashCode();
        }
        obj = this.tryItemArray;
        hash *= 31;
        if (obj != null) {
            hash += ((Object)obj).hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return "tryItems = " + this.tryItemArray.toString() + ", bytes=" + this.countBytes();
    }
}

