/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Sle128Item;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.CatchAllHandler;
import com.reandroid.dex.ins.CatchTypedHandler;
import com.reandroid.dex.ins.ExceptionHandler;
import com.reandroid.dex.ins.HandlerOffset;
import com.reandroid.dex.ins.HandlerOffsetArray;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.model.SmaliCodeCatch;
import com.reandroid.dex.smali.model.SmaliCodeCatchAll;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class TryItem
extends FixedDexContainerWithTool
implements Iterable<Label>,
IdUsageIterator {
    private final HandlerOffsetArray handlerOffsetArray;
    final Sle128Item handlersCount;
    private final BlockList<CatchTypedHandler> catchTypedHandlerList;
    private CatchAllHandler catchAllHandler;
    private HandlerOffset mHandlerOffset;

    public TryItem(HandlerOffsetArray handlerOffsetArray) {
        super(3);
        this.handlerOffsetArray = handlerOffsetArray;
        this.handlersCount = new Sle128Item();
        this.catchTypedHandlerList = new BlockList();
        this.addChild(0, this.handlersCount);
        this.addChild(1, this.catchTypedHandlerList);
    }

    private TryItem() {
        super(0);
        this.handlerOffsetArray = null;
        this.handlersCount = null;
        this.catchTypedHandlerList = null;
    }

    public boolean isCompact() {
        return false;
    }

    InstructionList getInstructionList() {
        return this.getTryBlock().getInstructionList();
    }

    TryBlock getTryBlock() {
        return this.getParent(TryBlock.class);
    }

    TryItem newCompact() {
        return new Compact(this);
    }

    public boolean compactWith(TryItem similar) {
        if (!this.isSimilarTo(similar)) {
            return false;
        }
        int index = similar.getIndex();
        TryBlock tryBlock = this.getTryBlock();
        TryItem replace = tryBlock.createNextCopy(this);
        replace.merge(similar);
        tryBlock.remove(similar);
        tryBlock.moveTo(replace, index);
        return true;
    }

    private boolean isSimilarTo(TryItem tryItem) {
        if (tryItem == this || this.isCompact() || tryItem.isCompact()) {
            return false;
        }
        if (this.getParent() != tryItem.getParent()) {
            return false;
        }
        if (!ExceptionHandler.areSimilar(this.getCatchAllHandler(), tryItem.getCatchAllHandler())) {
            return false;
        }
        int count = this.getCatchTypedHandlersCount();
        if (count != tryItem.getCatchTypedHandlersCount()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (ExceptionHandler.areSimilar(this.getCatchTypedHandler(i), tryItem.getCatchTypedHandler(i))) continue;
            return false;
        }
        return true;
    }

    public boolean flatten() {
        return false;
    }

    public boolean splitHandlers() {
        if (!this.hasMultipleHandlers()) {
            return false;
        }
        int index = this.getIndex() + 1;
        int count = this.getCatchTypedHandlersCount();
        for (int i = 1; i < count; ++i) {
            CatchTypedHandler handler = this.getCatchTypedHandler(1);
            index = this.transferHandlerToNewTryItem(handler, index);
        }
        this.transferHandlerToNewTryItem(this.getCatchAllHandler(), index);
        this.refresh();
        return true;
    }

    private int transferHandlerToNewTryItem(ExceptionHandler handler, int index) {
        if (handler == null) {
            return index;
        }
        TryBlock tryBlock = this.getTryBlock();
        TryItem destination = tryBlock.createNext();
        destination.mergeOffset(this);
        destination.mergeHandler(handler);
        this.remove(handler);
        tryBlock.moveTo(destination, index);
        destination.refresh();
        return index + 1;
    }

    public boolean combineWith(TryItem tryItem) {
        if (!this.equalsOffsetAndCodeUnit(tryItem)) {
            return false;
        }
        Iterator<ExceptionHandler> iterator = tryItem.getExceptionHandlers();
        while (iterator.hasNext()) {
            this.mergeHandler(iterator.next());
        }
        return true;
    }

    private boolean equalsOffsetAndCodeUnit(TryItem tryItem) {
        if (tryItem == this || this.isCompact() || tryItem.isCompact()) {
            return false;
        }
        if (this.getParent() != tryItem.getParent()) {
            return false;
        }
        HandlerOffset offset = this.getHandlerOffset();
        HandlerOffset other = tryItem.getHandlerOffset();
        return offset.getStartAddress() == other.getStartAddress() && offset.getCatchCodeUnit() == other.getCatchCodeUnit();
    }

    HandlerOffset getHandlerOffset() {
        HandlerOffset handlerOffset = this.mHandlerOffset;
        if (handlerOffset == null) {
            this.mHandlerOffset = handlerOffset = this.getHandlerOffsetArray().getOrCreate(this.getIndex());
            handlerOffset.setTryItem(this);
        }
        return handlerOffset;
    }

    HandlerOffsetArray getHandlerOffsetArray() {
        return this.handlerOffsetArray;
    }

    BlockList<CatchTypedHandler> getCatchTypedHandlerBlockList() {
        return this.catchTypedHandlerList;
    }

    Iterator<CatchTypedHandler> getCatchTypedHandlers() {
        return this.catchTypedHandlerList.iterator();
    }

    TryItem getTryItem() {
        return this;
    }

    void updateCount() {
        Sle128Item handlersCount = this.handlersCount;
        if (handlersCount == null) {
            return;
        }
        int count = this.catchTypedHandlerList.size();
        if (this.hasCatchAllHandler()) {
            count = -count;
        }
        handlersCount.set(count);
    }

    @Override
    public Iterator<Label> iterator() {
        return new ExpandIterator<Label>(this.getExceptionHandlers());
    }

    public boolean isEmpty() {
        return this.getCatchAllHandler() == null && this.getCatchTypedHandlersCount() == 0;
    }

    public int getCatchTypedHandlersCount() {
        return this.getCatchTypedHandlerBlockList().size();
    }

    public CatchTypedHandler getCatchTypedHandler(int i) {
        return this.getCatchTypedHandlerBlockList().get(i);
    }

    public boolean traps(TypeKey typeKey) {
        return this.getExceptionHandler(typeKey) != null;
    }

    public boolean traps(TypeKey typeKey, int address) {
        return this.getExceptionHandler(typeKey, address) != null;
    }

    public boolean hasExceptionHandlersForAddress(int address) {
        return this.getExceptionHandlersForAddress(address).hasNext();
    }

    public Iterator<ExceptionHandler> getExceptionHandlersForAddress(int address) {
        return FilterIterator.of(this.getExceptionHandlers(), handler -> handler.isAddressBounded(address));
    }

    public Iterator<ExceptionHandler> getExceptionHandlers() {
        Iterator<Object> iterator1 = EmptyIterator.of();
        CatchAllHandler handler = this.getCatchAllHandler();
        if (handler != null) {
            iterator1 = SingleIterator.of(handler);
        }
        return new CombiningIterator(this.getCatchTypedHandlers(), iterator1);
    }

    public ExceptionHandler getExceptionHandler(TypeKey typeKey) {
        Iterator<ExceptionHandler> iterator = this.getExceptionHandlers();
        while (iterator.hasNext()) {
            ExceptionHandler handler = iterator.next();
            if (!handler.traps(typeKey)) continue;
            return handler;
        }
        return null;
    }

    public ExceptionHandler getExceptionHandler(TypeKey typeKey, int address) {
        Iterator<ExceptionHandler> iterator = this.getExceptionHandlers();
        while (iterator.hasNext()) {
            ExceptionHandler handler = iterator.next();
            if (!handler.traps(typeKey) || !handler.isAddressBounded(address)) continue;
            return handler;
        }
        return null;
    }

    public int getStartAddress() {
        return this.getHandlerOffset().getStartAddress();
    }

    public void setStartAddress(int address) {
        this.getHandlerOffset().setStartAddress(address);
    }

    public int getCatchCodeUnit() {
        return this.getHandlerOffset().getCatchCodeUnit();
    }

    public void setCatchCodeUnit(int codeUnit) {
        this.getHandlerOffset().setCatchCodeUnit(codeUnit);
    }

    public boolean hasMultipleHandlers() {
        int typed = this.getCatchTypedHandlersCount();
        if (typed == 1) {
            return this.getCatchAllHandler() != null;
        }
        return typed != 0;
    }

    public boolean hasCatchAllHandler() {
        return this.getCatchAllHandler() != null;
    }

    public CatchAllHandler getCatchAllHandler() {
        return this.catchAllHandler;
    }

    public CatchAllHandler getOrCreateCatchAll() {
        CatchAllHandler handler = this.getCatchAllHandler();
        if (handler == null) {
            this.initCatchAllHandler();
            handler = this.getCatchAllHandler();
        }
        return handler;
    }

    private CatchAllHandler initCatchAllHandler() {
        CatchAllHandler catchAllHandler = this.getCatchAllHandler();
        if (catchAllHandler == null) {
            catchAllHandler = new CatchAllHandler();
            this.addChild(2, catchAllHandler);
            this.catchAllHandler = catchAllHandler;
        }
        return catchAllHandler;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateCount();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int maxPosition = reader.getPosition();
        int position = this.getHandlerOffsetArray().getItemsStart() + this.getHandlerOffset().getOffset();
        reader.seek(position);
        this.handlersCount.readBytes(reader);
        int count = this.handlersCount.get();
        boolean hasCatchAll = false;
        if (count <= 0) {
            count = -count;
            hasCatchAll = true;
        }
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        handlerList.ensureCapacity(count);
        for (int i = 0; i < count; ++i) {
            CatchTypedHandler handler = new CatchTypedHandler();
            handlerList.add(handler);
            handler.readBytes(reader);
        }
        if (hasCatchAll) {
            this.initCatchAllHandler().readBytes(reader);
        }
        if (maxPosition > reader.getPosition()) {
            reader.seek(maxPosition);
        }
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        TryItem tryItem;
        if (counter.FOUND) {
            return;
        }
        Block end = counter.END;
        if (end instanceof Compact && (tryItem = ((Compact)end).getTryItem()) == this) {
            counter.FOUND = true;
            return;
        }
        super.onCountUpTo(counter);
    }

    public void removeSelf() {
        TryBlock tryBlock = this.getTryBlock();
        if (tryBlock != null) {
            tryBlock.remove(this);
        }
    }

    public boolean isRemoved() {
        if (this.getParent() == null) {
            return true;
        }
        TryBlock tryBlock = this.getTryBlock();
        return tryBlock == null || tryBlock.getParent() == null;
    }

    public void remove(ExceptionHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler == this.catchAllHandler) {
            handler.onRemove();
            this.catchAllHandler = null;
        } else if (handler instanceof CatchTypedHandler && this.catchTypedHandlerList != null && this.catchTypedHandlerList.contains(handler)) {
            this.catchTypedHandlerList.remove((CatchTypedHandler)handler);
            handler.onRemove();
        }
    }

    public void onRemove() {
        HandlerOffset handlerOffset = this.mHandlerOffset;
        BlockList<CatchTypedHandler> list = this.catchTypedHandlerList;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                CatchTypedHandler handler = list.get(i);
                handler.onRemove();
                handler.setParent(null);
            }
            list.destroy();
        }
        this.remove(this.catchAllHandler);
        if (handlerOffset != null) {
            this.mHandlerOffset = null;
            handlerOffset.removeSelf();
        }
        this.setParent(null);
    }

    public void merge(TryItem tryItem) {
        this.mergeOffset(tryItem);
        this.mergeHandlers(tryItem);
    }

    public CatchTypedHandler createNext() {
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        CatchTypedHandler handler = new CatchTypedHandler();
        handlerList.add(handler);
        this.updateCount();
        return handler;
    }

    void mergeHandlers(TryItem tryItem) {
        BlockList<CatchTypedHandler> comingList = tryItem.getCatchTypedHandlerBlockList();
        int size = comingList.size();
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        handlerList.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            CatchTypedHandler coming = comingList.get(i);
            CatchTypedHandler handler = new CatchTypedHandler();
            handlerList.add(handler);
            handler.merge(coming);
        }
        if (tryItem.hasCatchAllHandler()) {
            this.initCatchAllHandler().merge(tryItem.getCatchAllHandler());
        }
        this.updateCount();
    }

    void mergeHandler(ExceptionHandler handler) {
        ExceptionHandler newHandler = handler instanceof CatchTypedHandler ? this.createNext() : this.getOrCreateCatchAll();
        newHandler.merge(handler);
    }

    void mergeOffset(TryItem tryItem) {
        HandlerOffset coming = tryItem.getHandlerOffset();
        HandlerOffset handlerOffset = this.getHandlerOffset();
        handlerOffset.setCatchCodeUnit(coming.getCatchCodeUnit());
        handlerOffset.setStartAddress(coming.getStartAddress());
    }

    public void fromSmali(SmaliCodeTryItem smaliCodeTryItem) {
        this.setStartAddress(smaliCodeTryItem.getStartAddress());
        SmaliSet<SmaliCodeCatch> smaliCodeCatchSet = smaliCodeTryItem.getCatchSet();
        BlockList<CatchTypedHandler> handlerList = this.getCatchTypedHandlerBlockList();
        int size = smaliCodeCatchSet.size();
        for (int i = 0; i < size; ++i) {
            SmaliCodeCatch smaliCodeCatch = smaliCodeCatchSet.get(i);
            CatchTypedHandler handler = new CatchTypedHandler();
            handlerList.add(handler);
            handler.fromSmali(smaliCodeCatch);
        }
        SmaliCodeCatchAll smaliCodeCatchAll = smaliCodeTryItem.getCatchAll();
        if (smaliCodeCatchAll != null) {
            CatchAllHandler catchAllHandler = this.initCatchAllHandler();
            catchAllHandler.fromSmali(smaliCodeCatchAll);
        }
        this.updateCount();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return ComputeIterator.of(this.getCatchTypedHandlers(), CatchTypedHandler::getTypeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryItem tryItem = (TryItem)obj;
        return ObjectsUtil.equals(this.getCatchTypedHandlerBlockList(), tryItem.getCatchTypedHandlerBlockList()) && ObjectsUtil.equals(this.getCatchAllHandler(), tryItem.getCatchAllHandler());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getCatchTypedHandlerBlockList(), this.getCatchAllHandler());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<ExceptionHandler> handlers = this.getExceptionHandlers();
        while (handlers.hasNext()) {
            if (builder.length() != 0) {
                builder.append('\n');
            }
            builder.append(handlers.next());
        }
        return builder.toString();
    }

    static class Compact
    extends TryItem {
        private final TryItem tryItem;

        public Compact(TryItem tryItem) {
            this.tryItem = tryItem;
        }

        @Override
        public boolean isCompact() {
            return true;
        }

        @Override
        TryBlock getTryBlock() {
            return this.tryItem.getTryBlock();
        }

        @Override
        TryItem newCompact() {
            return this.tryItem.newCompact();
        }

        @Override
        public boolean compactWith(TryItem similar) {
            return false;
        }

        @Override
        public boolean flatten() {
            TryBlock tryBlock = this.getTryBlock();
            if (tryBlock != null) {
                Compact self = this;
                int index = self.getIndex();
                TryItem replace = tryBlock.createNext();
                replace.merge(self);
                tryBlock.remove(self);
                tryBlock.moveTo(replace, index);
                replace.refresh();
                return true;
            }
            return false;
        }

        @Override
        HandlerOffsetArray getHandlerOffsetArray() {
            return this.tryItem.getHandlerOffsetArray();
        }

        @Override
        Iterator<CatchTypedHandler> getCatchTypedHandlers() {
            Iterator<CatchTypedHandler> iterator = this.getCatchTypedHandlerBlockList().iterator();
            Compact parent = this;
            return ComputeIterator.of(iterator, handler -> handler.newCompact(parent));
        }

        @Override
        public CatchTypedHandler getCatchTypedHandler(int i) {
            return super.getCatchTypedHandler(i).newCompact(this);
        }

        @Override
        BlockList<CatchTypedHandler> getCatchTypedHandlerBlockList() {
            return this.tryItem.getCatchTypedHandlerBlockList();
        }

        @Override
        TryItem getTryItem() {
            return this.tryItem.getTryItem();
        }

        @Override
        public CatchAllHandler getCatchAllHandler() {
            CatchAllHandler catchAllHandler = this.tryItem.getCatchAllHandler();
            if (catchAllHandler != null) {
                catchAllHandler = catchAllHandler.newCompact(this);
            }
            return catchAllHandler;
        }

        @Override
        public CatchAllHandler getOrCreateCatchAll() {
            this.tryItem.getOrCreateCatchAll();
            return this.getCatchAllHandler();
        }

        @Override
        public int countBytes() {
            return 0;
        }

        @Override
        public int onWriteBytes(OutputStream stream) throws IOException {
            return 0;
        }

        @Override
        public byte[] getBytes() {
            return null;
        }

        @Override
        protected void onPreRefresh() {
        }

        @Override
        protected void onRefreshed() {
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
        }

        @Override
        void updateCount() {
        }

        @Override
        void mergeHandlers(TryItem tryItem) {
        }

        @Override
        void mergeHandler(ExceptionHandler handler) {
        }

        @Override
        public int hashCode() {
            return ObjectsUtil.hash(this.getClass(), super.hashCode());
        }

        @Override
        public String toString() {
            if (this.getParent() == null) {
                return "NULL";
            }
            return super.toString();
        }
    }
}

