/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.AnnotationsKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.MethodProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.collection.ArrayUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class AnnotationGroupKey
extends AnnotationsKey<AnnotationSetKey> {
    private static final AnnotationGroupKey EMPTY = new AnnotationGroupKey(EMPTY_ARRAY);

    private AnnotationGroupKey(Key[] elements) {
        super(elements, false);
    }

    @Override
    public boolean isBlank() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public AnnotationGroupKey setParametersCount(int count) {
        if (count == 0 || this.isBlank()) {
            return AnnotationGroupKey.empty();
        }
        return this.setSize(count);
    }

    public AnnotationGroupKey setSize(int size) {
        int current = this.size();
        if (size == current) {
            return this;
        }
        if (size == 0) {
            return AnnotationGroupKey.empty();
        }
        Key[] elements = new Key[size];
        int min = NumbersUtil.min(current, size);
        for (int i = 0; i < min; ++i) {
            elements[i] = this.get(i);
        }
        AnnotationSetKey emptySetKey = null;
        for (int i = min; i < size; ++i) {
            if (emptySetKey == null) {
                emptySetKey = AnnotationSetKey.empty();
            }
            elements[i] = emptySetKey;
        }
        return AnnotationGroupKey.createNonNull(elements);
    }

    public AnnotationGroupKey merge(AnnotationsKey<? extends AnnotationSetKey> item) {
        if (item == null || item == this || item.isBlank()) {
            return this;
        }
        if (this.isBlank()) {
            return (AnnotationGroupKey)item;
        }
        AnnotationGroupKey result = this;
        int size = item.size();
        for (int i = 0; i < size; ++i) {
            result = result.merge(i, (AnnotationSetKey)item.get(i));
        }
        return result;
    }

    public AnnotationGroupKey merge(int i, AnnotationSetKey item) {
        return this.set(i, (AnnotationSetKey)this.getOrEmpty(i).merge((AnnotationsKey)item));
    }

    public AnnotationSetKey getOrEmpty(int i) {
        AnnotationSetKey key = this.get(i);
        if (key == null) {
            key = AnnotationSetKey.empty();
        }
        return key;
    }

    @Override
    public AnnotationSetKey get(int i) {
        return (AnnotationSetKey)super.get(i);
    }

    public AnnotationGroupKey add(AnnotationSetKey key) {
        return (AnnotationGroupKey)super.add(key);
    }

    public AnnotationGroupKey remove(AnnotationSetKey key) {
        return (AnnotationGroupKey)super.remove(key);
    }

    public AnnotationGroupKey remove(int index) {
        return (AnnotationGroupKey)super.remove(index);
    }

    public AnnotationGroupKey clearAt(int i) {
        if (i >= this.size()) {
            return this;
        }
        return this.set(i, AnnotationSetKey.empty());
    }

    public AnnotationGroupKey set(int i, AnnotationSetKey item) {
        int size;
        if (item == null) {
            item = AnnotationSetKey.empty();
        }
        if (i < (size = this.size())) {
            return AnnotationGroupKey.checkBlank((AnnotationGroupKey)super.set(i, item));
        }
        if (item.isEmpty() && this.isBlank()) {
            return AnnotationGroupKey.empty();
        }
        int length = i + 1;
        Key[] elements = new Key[length];
        for (int j = 0; j < size; ++j) {
            elements[j] = this.get(j);
        }
        AnnotationSetKey emptySetKey = AnnotationSetKey.empty();
        for (int j = size; j < length; ++j) {
            elements[j] = emptySetKey;
        }
        elements[i] = item;
        return AnnotationGroupKey.createNonNull(elements);
    }

    public AnnotationGroupKey sorted() {
        return this;
    }

    public AnnotationGroupKey clearDuplicates() {
        Key[] elements = this.getElements();
        Key[] results = null;
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            AnnotationSetKey key = (AnnotationSetKey)elements[i];
            AnnotationSetKey cleared = key.clearDuplicates();
            if (key == cleared) continue;
            if (results == null) {
                results = (Key[])elements.clone();
            }
            results[i] = cleared;
        }
        if (results == null) {
            return AnnotationGroupKey.checkBlank(this);
        }
        return AnnotationGroupKey.checkBlank(AnnotationGroupKey.createNonNull(results));
    }

    public AnnotationGroupKey clearDuplicates(Comparator<? super AnnotationSetKey> comparator) {
        return this;
    }

    AnnotationGroupKey newInstance(Key[] elements) {
        return AnnotationGroupKey.createKey(elements);
    }

    @Override
    public AnnotationGroupKey replaceKey(Key search, Key replace) {
        return (AnnotationGroupKey)super.replaceKey(search, replace);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        if (size == 0) {
            return;
        }
        Object[] fakeParams = new TypeKey[size];
        ArrayUtil.fill(fakeParams, TypeKey.TYPE_I);
        this.append(false, ProtoKey.create(TypeKey.TYPE_V, (TypeKey[])fakeParams), writer);
    }

    public void append(MethodProgram methodProgram, SmaliWriter writer) throws IOException {
        this.append(methodProgram.isStatic(), methodProgram.getProtoKey(), writer);
    }

    public void append(boolean is_static, ProtoKey protoKey, SmaliWriter writer) throws IOException {
        if (this.isBlank()) {
            return;
        }
        int size = NumbersUtil.min(this.size(), protoKey.getParametersCount());
        int instance = is_static ? 0 : 1;
        for (int i = 0; i < size; ++i) {
            AnnotationSetKey item = this.get(i);
            if (item.isEmpty()) continue;
            writer.newLine();
            SmaliDirective.PARAM.append(writer);
            writer.append('p');
            writer.appendInteger(instance + protoKey.getRegister(i));
            writer.appendComment(protoKey.getParameter(i).getTypeName());
            writer.indentPlus();
            item.append(writer);
            writer.indentMinus();
            SmaliDirective.PARAM.appendEnd(writer);
        }
    }

    @Override
    public String toString() {
        return SmaliWriter.toStringSafe(this, false);
    }

    public static AnnotationGroupKey empty() {
        return EMPTY;
    }

    public static AnnotationGroupKey empty(int length) {
        if (length == 0) {
            return EMPTY;
        }
        return AnnotationGroupKey.createKey(new Key[length]);
    }

    public static AnnotationGroupKey of(AnnotationSetKey ... elements) {
        return AnnotationGroupKey.createKey(elements);
    }

    public static AnnotationGroupKey combine(Iterator<AnnotationGroupKey> iterator) {
        AnnotationsKey result = AnnotationGroupKey.empty();
        while (iterator.hasNext()) {
            result = result.merge((AnnotationsKey)iterator.next());
        }
        return result;
    }

    private static AnnotationGroupKey checkBlank(AnnotationGroupKey groupKey) {
        if (groupKey == null || groupKey.isBlank()) {
            groupKey = AnnotationGroupKey.empty();
        }
        return groupKey;
    }

    private static AnnotationGroupKey createKey(Key[] elements) {
        if (elements == null || elements.length == 0) {
            return AnnotationGroupKey.empty();
        }
        int length = elements.length;
        AnnotationSetKey emptySetKey = null;
        for (int i = 0; i < length; ++i) {
            Key key = elements[i];
            if (key != null) continue;
            if (emptySetKey == null) {
                emptySetKey = AnnotationSetKey.empty();
            }
            elements[i] = emptySetKey;
        }
        return AnnotationGroupKey.createNonNull(elements);
    }

    private static AnnotationGroupKey createNonNull(Key[] elements) {
        return new AnnotationGroupKey(elements);
    }
}

