/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.CallSiteKey;
import com.reandroid.dex.key.EnumKey;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.IOException;
import java.util.Iterator;

public interface Key
extends Comparable<Object>,
SmaliFormat {
    public static final String DALVIK_accessFlags = ObjectsUtil.of("accessFlags");
    public static final String DALVIK_name = ObjectsUtil.of("name");
    public static final String DALVIK_value = ObjectsUtil.of("value");

    default public boolean uses(Key key) {
        return this.equals(key) || CollectionUtil.contains(this.mentionedKeys(), key);
    }

    default public TypeKey getDeclaring() {
        return null;
    }

    default public Iterator<? extends Key> mentionedKeys() {
        throw new RuntimeException("Method 'mentionedKeys()' Not implemented for: " + this.getClass());
    }

    default public Key replaceKey(Key search, Key replace) {
        return this;
    }

    @Override
    default public void append(SmaliWriter writer) throws IOException {
        writer.append(this.toString());
    }

    @Override
    public int compareTo(Object var1);

    public static Key parseBasic(String text) {
        if (StringsUtil.isEmpty(text)) {
            return null;
        }
        char first = text.charAt(0);
        if (first == '\"') {
            return StringKey.parseQuotedString(text);
        }
        if (first == 'L' || first == '[') {
            if (first == 'L' && text.indexOf(58) > 0) {
                return FieldKey.parse(text);
            }
            if (text.indexOf(40) > 0) {
                return MethodKey.parse(text);
            }
            return TypeKey.parse(text);
        }
        if (first == '(') {
            if (text.indexOf(44) > 0) {
                return CallSiteKey.parse(text);
            }
            return ProtoKey.parse(text);
        }
        if (first == '{') {
            return ArrayValueKey.parse(text);
        }
        if (text.startsWith(".annotation") || text.startsWith(".subannotation")) {
            return AnnotationItemKey.parse(text);
        }
        if (text.startsWith(".enum")) {
            return EnumKey.parse(text);
        }
        int i = text.indexOf(40);
        if (i > 0) {
            return MethodKey.parse(text);
        }
        i = text.indexOf(58);
        if (i > 0) {
            return FieldKey.parse(text);
        }
        return PrimitiveKey.parse(text);
    }
}

