/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.DalvikSignatureBuilder;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ParameterisedProtoKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class ParameterisedTypeKey
implements Key {
    private final ParameterName parameterName;
    private final ParameterisedProtoKey protoKey;

    private ParameterisedTypeKey(ParameterName parameterName, ParameterisedProtoKey protoKey) {
        this.parameterName = parameterName;
        this.protoKey = protoKey;
    }

    public String getName() {
        ParameterName name = this.getParameterName();
        if (name != null) {
            return name.getName();
        }
        return null;
    }

    public ParameterisedTypeKey getParameter(int i) {
        return (ParameterisedTypeKey)this.getProtoKey().get(i);
    }

    public int getParametersCount() {
        return this.getProtoKey().size();
    }

    public ParameterisedProtoKey getProtoKey() {
        return this.protoKey;
    }

    public boolean isTypeVariableDefinition() {
        return this.getParameterName() instanceof Definition;
    }

    public boolean isParametrisedType() {
        ParameterisedProtoKey protoKey = this.getProtoKey();
        return !protoKey.isMethod() && !protoKey.isEmpty();
    }

    public ParameterisedTypeKey changeProtoKey(ParameterisedProtoKey protoKey) {
        if (ObjectsUtil.equals(this.getProtoKey(), protoKey)) {
            return this;
        }
        return ParameterisedTypeKey.create(this.getParameterName(), protoKey);
    }

    ParameterName getParameterName() {
        return this.parameterName;
    }

    @Override
    public TypeKey getDeclaring() {
        TypeKey typeKey = this.getInnerClassKey();
        if (typeKey == null) {
            typeKey = this.getNameTypeKey();
        }
        return typeKey;
    }

    private TypeKey getNameTypeKey() {
        ParameterName name = this.getParameterName();
        if (name != null) {
            return name.getDeclaring();
        }
        return null;
    }

    private ParameterisedTypeKey changeParameterName(ParameterName name) {
        if (ObjectsUtil.equals(this.getParameterName(), name)) {
            return this;
        }
        return ParameterisedTypeKey.create(name, this.getProtoKey());
    }

    private ParameterisedTypeKey changeParameterName(TypeKey typeKey) {
        TypeKey key = this.getNameTypeKey();
        if (key == null || ObjectsUtil.equals(key, typeKey)) {
            return this;
        }
        return this.changeParameterName(this.getParameterName().changeName(typeKey));
    }

    private TypeKey getInnerClassKey() {
        ParameterisedTypeKey key = this.getProtoKey().getReturnType();
        if (key == null) {
            return null;
        }
        ParameterName innerName = key.getParameterName();
        if (innerName == null || !innerName.isInnerName()) {
            return null;
        }
        ParameterName parameterName = this.getParameterName();
        if (parameterName == null) {
            return null;
        }
        String name = parameterName.getName();
        String inner = innerName.getName().replace('.', '$');
        return TypeKey.create(name + inner + ";");
    }

    private ParameterisedTypeKey changeInnerKey(TypeKey innerKey) {
        TypeKey key = this.getInnerClassKey();
        if (key == null || key.equals(innerKey)) {
            return this;
        }
        ParameterisedProtoKey protoKey = this.getProtoKey();
        ParameterisedTypeKey returnType = protoKey.getReturnType();
        if (returnType == null) {
            return this;
        }
        ParameterName name = returnType.getParameterName();
        if (!(name instanceof InnerClassName)) {
            return this;
        }
        InnerClassName innerClassName = (InnerClassName)name;
        String inner = innerClassName.createInnerName(innerKey);
        if (inner == null) {
            return this;
        }
        TypeKey outerKey = innerClassName.createOuterKey(innerKey);
        if (outerKey == null) {
            return this;
        }
        innerClassName = innerClassName.changeName(inner);
        returnType = returnType.changeParameterName(innerClassName);
        protoKey = protoKey.changeReturnType(returnType);
        ParameterisedTypeKey result = this.changeProtoKey(protoKey);
        result = result.changeParameterName(outerKey);
        return result;
    }

    public Iterator<TypeKey> getTypes() {
        Iterator<TypeKey> iterator = CombiningIterator.singleTwo(this.getInnerClassKey(), this.getProtoKey().getTypes(), SingleIterator.of(this.getNameTypeKey()));
        return new IterableIterator<TypeKey, TypeKey>(iterator){

            @Override
            public Iterator<TypeKey> iterator(TypeKey element) {
                return element.mentionedKeys();
            }
        };
    }

    void buildSignature(DalvikSignatureBuilder builder) {
        ParameterName name = this.getParameterName();
        boolean needSemicolon = false;
        if (name != null) {
            name.buildSignature(builder);
            needSemicolon = name.isTypeUse();
        }
        this.getProtoKey().buildSignature(builder);
        if (needSemicolon) {
            builder.append(';');
            builder.flushPending();
        }
    }

    @Override
    public ParameterisedTypeKey replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return (ParameterisedTypeKey)replace;
        }
        ParameterisedTypeKey result = this;
        if (ObjectsUtil.equals(result.getInnerClassKey(), search)) {
            result = result.changeInnerKey((TypeKey)replace);
        }
        if (ObjectsUtil.equals(result.getNameTypeKey(), search)) {
            result = result.changeParameterName((TypeKey)replace);
        }
        ParameterisedProtoKey protoKey = result.getProtoKey();
        protoKey = protoKey.replaceKey(search, replace);
        result = result.changeProtoKey(protoKey);
        return result;
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        return this.getTypes();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof ParameterisedTypeKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        ParameterisedTypeKey key = (ParameterisedTypeKey)obj;
        int i = CompareUtil.compare(this.getParameterName(), key.getParameterName());
        if (i == 0) {
            i = CompareUtil.compare(this.getProtoKey(), key.getProtoKey());
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParameterisedTypeKey)) {
            return false;
        }
        ParameterisedTypeKey key = (ParameterisedTypeKey)obj;
        return ObjectsUtil.equals(this.getParameterName(), key.getParameterName()) && ObjectsUtil.equals(this.getProtoKey(), key.getProtoKey());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getParameterName(), this.getProtoKey());
    }

    public String getComment() {
        StringBuilder builder = new StringBuilder();
        this.appendString(builder, true);
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendString(builder, false);
        return builder.toString();
    }

    void appendString(StringBuilder builder, boolean comment) {
        ParameterName name = this.getParameterName();
        boolean needSemicolon = false;
        if (name != null) {
            name.appendString(builder, comment);
            needSemicolon = name.isTypeUse();
        }
        this.getProtoKey().appendString(builder, comment);
        if (needSemicolon) {
            builder.append(';');
        }
    }

    public static ParameterisedTypeKey create(ParameterName name, ParameterisedProtoKey protoKey) {
        if (protoKey == null || protoKey.isBlank()) {
            if (name == null) {
                return null;
            }
            protoKey = ParameterisedProtoKey.EMPTY;
        }
        return new ParameterisedTypeKey(name, protoKey);
    }

    public static ParameterisedTypeKey read(SmaliReader reader) throws IOException {
        ParameterisedTypeKey typeKey;
        int c;
        ParameterName name = ParameterisedTypeKey.readName(reader);
        ParameterisedProtoKey protoKey = null;
        if (!reader.finished() && ((c = reader.get() & 0xFF) == 60 || c == 40 && name == null)) {
            protoKey = ParameterisedProtoKey.read(reader);
        }
        if (name != null && name.isTypeUse()) {
            SmaliParseException.expect(reader, ';');
        }
        if ((typeKey = ParameterisedTypeKey.create(name, protoKey)) == null) {
            throw new SmaliParseException("Invalid ParameterisedTypeKey", reader);
        }
        return typeKey;
    }

    private static ParameterName readName(SmaliReader reader) {
        char c = reader.getASCII(reader.position());
        if (ParameterisedTypeKey.isNameStop(c)) {
            return null;
        }
        ParameterName name = Wild.readWild(reader);
        if (name == null) {
            name = InnerClassName.readInnerClassName(reader);
        }
        if (name == null) {
            name = Definition.readDefinition(reader);
        }
        if (name == null) {
            name = TypeUsePrimitive.readTypeUsePrimitive(reader);
        }
        if (name == null) {
            name = TypeUseVariable.readTypeUseVariable(reader);
        }
        if (name == null) {
            name = TypeUse.readTypeUse(reader);
        }
        return name;
    }

    static boolean isNameStop(char c) {
        return c == '<' || c == '>' || c == '(' || c == ')' || c == ';';
    }

    static boolean isWild(char c) {
        return c == ':' || c == '-' || c == '+' || c == '*';
    }

    static class TypeUsePrimitive
    extends ParameterName {
        TypeUsePrimitive(String name) {
            super(name);
        }

        @Override
        public TypeUsePrimitive changeName(String name) {
            if (this.getName().equals(name)) {
                return this;
            }
            return new TypeUsePrimitive(name);
        }

        static TypeUsePrimitive readTypeUsePrimitive(SmaliReader reader) {
            int start = reader.position();
            int end = start + reader.available();
            for (int i = start; i < end; ++i) {
                char next;
                char c = reader.getASCII(i);
                if (c == '[') {
                    continue;
                }
                if (!TypeKey.isPrimitive(c)) {
                    return null;
                }
                int i2 = i + 1;
                if (i2 < end && ((next = reader.getASCII(i2)) == ';' || next == '<')) {
                    return null;
                }
                String name = reader.readString(++i - start);
                return new TypeUsePrimitive(name);
            }
            return null;
        }
    }

    static class TypeUseVariable
    extends TypeUse {
        TypeUseVariable(String name) {
            super(name);
        }

        public String getVariableName() {
            String name = this.getName();
            int i = 0;
            while (name.charAt(i) == '[') {
                ++i;
            }
            return name.substring(0, i) + name.substring(i + 1);
        }

        @Override
        public boolean isClassType() {
            return false;
        }

        @Override
        public void appendString(StringBuilder builder, boolean comment) {
            if (comment) {
                builder.append(this.getVariableName());
            } else {
                builder.append(this.getName());
            }
        }

        static TypeUseVariable readTypeUseVariable(SmaliReader reader) {
            int start = reader.position();
            int end = start + reader.available();
            int i = start;
            boolean first = true;
            char c = '\u0000';
            while (i < end) {
                c = reader.getASCII(i);
                if (c == '[') {
                    if (!first) break;
                    ++i;
                    continue;
                }
                if (first && c != 'T') {
                    return null;
                }
                if (TypeUseVariable.isTypeUseVariableStop(c)) break;
                first = false;
                ++i;
            }
            if (i == start || c != ';' && c != '<') {
                return null;
            }
            String name = reader.readString(i - start);
            return new TypeUseVariable(name);
        }

        private static boolean isTypeUseVariableStop(char c) {
            return ParameterisedTypeKey.isNameStop(c) || ParameterisedTypeKey.isWild(c) || c == '/' || c == '.';
        }
    }

    static class TypeUse
    extends ParameterName {
        TypeUse(String name) {
            super(name);
        }

        @Override
        public TypeUse changeName(TypeKey typeKey) {
            String name = typeKey.getTypeName();
            name = name.substring(0, name.length() - 1);
            return this.changeName(name);
        }

        @Override
        public TypeUse changeName(String name) {
            if (this.getName().equals(name)) {
                return this;
            }
            return new TypeUse(name);
        }

        @Override
        boolean isTypeUse() {
            return true;
        }

        @Override
        public boolean isClassType() {
            int i;
            String name = this.getName();
            int length = name.length();
            for (i = 0; i < length && name.charAt(i) == '['; ++i) {
            }
            if (i + 2 >= length) {
                return false;
            }
            return name.charAt(i) == 'L';
        }

        @Override
        public TypeKey getDeclaring() {
            if (this.isClassType()) {
                return TypeKey.create(this.getName() + ";");
            }
            return null;
        }

        @Override
        public void buildSignature(DalvikSignatureBuilder builder) {
            boolean flushed = false;
            if (this.isClassType()) {
                builder.flush();
                flushed = true;
            }
            builder.append(this.getName());
            if (flushed) {
                builder.markFlush();
            }
        }

        static TypeUse readTypeUse(SmaliReader reader) {
            int start = reader.position();
            int end = start + reader.available();
            int i = start;
            boolean first = true;
            while (i < end) {
                char c = reader.getASCII(i);
                if (c == '[') {
                    if (!first) break;
                    ++i;
                    continue;
                }
                if (TypeUse.isTypeUseStop(c)) break;
                first = false;
                ++i;
            }
            if (i == start) {
                return null;
            }
            String name = reader.readString(i - start);
            return new TypeUse(name);
        }

        private static boolean isTypeUseStop(char c) {
            return ParameterisedTypeKey.isNameStop(c) || ParameterisedTypeKey.isWild(c);
        }
    }

    static class InnerClassName
    extends ParameterName {
        InnerClassName(String name) {
            super(name);
        }

        @Override
        boolean isInnerName() {
            return true;
        }

        @Override
        public void appendString(StringBuilder builder, boolean comment) {
            String name = this.getName();
            if (comment) {
                name = name.replace('.', '$');
            }
            builder.append(name);
        }

        @Override
        public InnerClassName changeName(String name) {
            if (this.getName().equals(name)) {
                return this;
            }
            return new InnerClassName(name);
        }

        public String createInnerName(TypeKey typeKey) {
            String name;
            String[] current;
            int length;
            String[] simpleNames = StringsUtil.split(typeKey.getSimpleName(), '$');
            int simpleNamesLength = simpleNames.length;
            int index = simpleNamesLength - (length = (current = StringsUtil.split((name = this.getName()).substring(1), '.')).length);
            if (index <= 0) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = index; i < simpleNamesLength; ++i) {
                builder.append('.');
                builder.append(simpleNames[i]);
            }
            return builder.toString();
        }

        public TypeKey createOuterKey(TypeKey typeKey) {
            String name;
            String[] current;
            int length;
            String[] simpleNames = StringsUtil.split(typeKey.getSimpleName(), '$');
            int simpleNamesLength = simpleNames.length;
            int end = simpleNamesLength - (length = (current = StringsUtil.split((name = this.getName()).substring(1), '.')).length);
            if (end <= 0) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(typeKey.getPackageName());
            for (int i = 0; i < end; ++i) {
                if (i != 0) {
                    builder.append('$');
                }
                builder.append(simpleNames[i]);
            }
            builder.append(';');
            return TypeKey.create(builder.toString());
        }

        static InnerClassName readInnerClassName(SmaliReader reader) {
            int start = reader.position();
            int end = start + reader.available();
            int i = start;
            boolean first = true;
            while (i < end) {
                char c = reader.getASCII(i);
                if (c == '[') {
                    if (!first) break;
                    ++i;
                    continue;
                }
                if (first && c != '.') {
                    return null;
                }
                if (ParameterisedTypeKey.isNameStop(c) || ParameterisedTypeKey.isWild(c)) break;
                first = false;
                ++i;
            }
            if (i == start) {
                return null;
            }
            String name = reader.readString(i - reader.position());
            return new InnerClassName(name);
        }
    }

    static class Definition
    extends ParameterName {
        private final int colons;

        Definition(String name, int colons) {
            super(name);
            this.colons = colons;
        }

        @Override
        public Definition changeName(String name) {
            if (this.getName().equals(name)) {
                return this;
            }
            return new Definition(name, this.colons);
        }

        @Override
        public void appendString(StringBuilder builder, boolean comment) {
            builder.append(this.getName());
            int colons = this.colons;
            for (int i = 0; i < colons; ++i) {
                builder.append(':');
            }
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.append(this.getName());
            int colons = this.colons;
            for (int i = 0; i < colons; ++i) {
                writer.append(':');
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.appendString(builder, false);
            return builder.toString();
        }

        static Definition readDefinition(SmaliReader reader) {
            int i;
            int colons = 0;
            int start = reader.position();
            int end = start + reader.available();
            for (i = start; i < end; ++i) {
                char c = reader.getASCII(i);
                if (c == ':') {
                    ++colons;
                    continue;
                }
                if (colons != 0 || Definition.isDefinitionStop(c)) break;
            }
            if (colons == 0) {
                return null;
            }
            int length = i - start - colons;
            String name = reader.readString(length);
            reader.position(reader.position() + colons);
            return new Definition(name, colons);
        }

        static boolean isDefinitionStop(char c) {
            return ParameterisedTypeKey.isNameStop(c) || ParameterisedTypeKey.isWild(c) || c == '/' || c == '.';
        }
    }

    static class Wild
    extends ParameterName {
        static final Wild SUPER = new Wild("-", "? super ");
        static final Wild EXTENDS = new Wild("+", "? extends ");
        static final Wild ANY = new Wild("*", "?;");
        private final String comment;

        Wild(String name, String comment) {
            super(name);
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        @Override
        public void appendString(StringBuilder builder, boolean comment) {
            if (comment) {
                builder.append(this.getComment());
            } else {
                builder.append(this.getName());
            }
        }

        @Override
        public Wild changeName(String name) {
            if (name.length() != 1 || this.getName().equals(name)) {
                return this;
            }
            Wild result = Wild.getWild(name.charAt(0));
            if (result == null) {
                result = this;
            }
            return result;
        }

        static Wild readWild(SmaliReader reader) {
            int position = reader.position();
            Wild wild = Wild.getWild(reader.getASCII(position));
            if (wild != null) {
                reader.position(position + 1);
                return wild;
            }
            return null;
        }

        static Wild getWild(char c) {
            if (c == '-') {
                return SUPER;
            }
            if (c == '+') {
                return EXTENDS;
            }
            if (c == '*') {
                return ANY;
            }
            return null;
        }
    }

    static abstract class ParameterName
    implements Key {
        private final String name;

        ParameterName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ParameterName changeName(TypeKey typeKey) {
            return this;
        }

        public abstract ParameterName changeName(String var1);

        boolean isTypeUse() {
            return false;
        }

        public boolean isClassType() {
            return false;
        }

        boolean isInnerName() {
            return false;
        }

        @Override
        public TypeKey getDeclaring() {
            return null;
        }

        public void buildSignature(DalvikSignatureBuilder builder) {
            this.appendString(builder.getStringBuilder(), false);
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            writer.append(this.getName());
        }

        public void appendString(StringBuilder builder, boolean comment) {
            builder.append(this.getName());
        }

        @Override
        public int compareTo(Object obj) {
            if (obj == this) {
                return 0;
            }
            if (obj == null) {
                return -1;
            }
            if (!this.getClass().isInstance(obj)) {
                return StringsUtil.compareToString(this, obj);
            }
            ParameterName name = (ParameterName)obj;
            return CompareUtil.compare(this.getName(), name.getName());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            ParameterName name = (ParameterName)obj;
            return ObjectsUtil.equals(this.getName(), name.getName());
        }

        public int hashCode() {
            return ObjectsUtil.hash(this.getName());
        }

        public String toString() {
            return this.getName();
        }
    }
}

