/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public class TypeKey
implements ProgramKey {
    private final String typeName;
    private String simpleName;
    public static final TypeKey TYPE_B = new PrimitiveTypeKey("B", "byte");
    public static final TypeKey TYPE_C = new PrimitiveTypeKey("C", "char");
    public static final TypeKey TYPE_D = new PrimitiveTypeKey("D", "double"){

        @Override
        public boolean isWide() {
            return true;
        }
    };
    public static final TypeKey TYPE_F = new PrimitiveTypeKey("F", "float");
    public static final TypeKey TYPE_I = new PrimitiveTypeKey("I", "int");
    public static final TypeKey TYPE_J = new PrimitiveTypeKey("J", "long"){

        @Override
        public boolean isWide() {
            return true;
        }
    };
    public static final TypeKey TYPE_S = new PrimitiveTypeKey("S", "short");
    public static final TypeKey TYPE_V = new PrimitiveTypeKey("V", "void");
    public static final TypeKey TYPE_Z = new PrimitiveTypeKey("Z", "boolean");
    public static final TypeKey CLASS = new TypeKey("Ljava/lang/Class;");
    public static final TypeKey OBJECT = new TypeKey("Ljava/lang/Object;");
    public static final TypeKey STRING = new TypeKey("Ljava/lang/String;");
    public static final TypeKey EXCEPTION = new TypeKey("Ljava/lang/Exception;");
    public static final TypeKey DALVIK_EnclosingClass = new TypeKey("Ldalvik/annotation/EnclosingClass;");
    public static final TypeKey DALVIK_EnclosingMethod = new TypeKey("Ldalvik/annotation/EnclosingMethod;");
    public static final TypeKey DALVIK_InnerClass = new TypeKey("Ldalvik/annotation/InnerClass;");
    public static final TypeKey DALVIK_MemberClass = new TypeKey("Ldalvik/annotation/MemberClasses;");
    public static final TypeKey DALVIK_Signature = new TypeKey("Ldalvik/annotation/Signature;");
    public static final TypeKey DALVIK_Throws = new TypeKey("Ldalvik/annotation/Throws;");

    public TypeKey(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public ElementType getElementType() {
        return ElementType.TYPE;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public char shorty() {
        String name = this.getTypeName();
        if (name.length() == 1) {
            return name.charAt(0);
        }
        return 'L';
    }

    public String getSourceName() {
        int array = this.getArrayDimension();
        if (array == 0) {
            TypeKey typeKey;
            String type = this.getTypeName();
            if (type.length() == 1 && (typeKey = PrimitiveTypeKey.primitiveType(type.charAt(0))) != null) {
                return typeKey.getSourceName();
            }
            return DexUtils.toSourceName(type);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDeclaring().getSourceName());
        for (int i = 0; i < array; ++i) {
            builder.append("[]");
        }
        return builder.toString();
    }

    @Override
    public TypeKey getDeclaring() {
        String main = this.getDeclaringName();
        if (main.equals(this.getTypeName())) {
            return this;
        }
        return TypeKey.create(main);
    }

    public Iterator<TypeKey> mentionedKeys() {
        Iterator<TypeKey> iterator = SingleIterator.of(this);
        if (this.isTypeArray()) {
            iterator = CombiningIterator.singleOne(this.getDeclaring(), iterator);
        }
        return iterator;
    }

    @Override
    public Key replaceKey(Key search, Key replace) {
        if (search.equals(this)) {
            return replace;
        }
        return this;
    }

    public String getDeclaringName() {
        return DexUtils.toDeclaringType(this.getTypeName());
    }

    public String getSignatureTypeName() {
        return DexUtils.toSignatureType(this.getTypeName());
    }

    public TypeKey setArrayDimension(int dimension) {
        if (dimension == this.getArrayDimension()) {
            return this;
        }
        return new TypeKey(this.getArrayType(dimension));
    }

    public String getArrayType(int dimension) {
        return DexUtils.makeArrayType(this.getTypeName(), dimension);
    }

    public int getArrayDimension() {
        return DexUtils.countArrayPrefix(this.getTypeName());
    }

    public boolean isTypeArray() {
        String name = this.getTypeName();
        return name.length() > 1 && name.charAt(0) == '[';
    }

    public boolean isTypeDefinition() {
        String name = this.getTypeName();
        int i = name.length() - 1;
        return i > 1 && name.charAt(0) == 'L' && name.charAt(i) == ';';
    }

    public boolean isTypeObject() {
        return DexUtils.isTypeObject(this.getTypeName());
    }

    public boolean isPrimitive() {
        return DexUtils.isPrimitive(this.getTypeName());
    }

    public boolean isWide() {
        String name = this.getTypeName();
        if (name.length() != 1) {
            return false;
        }
        return name.equals(TYPE_D.getTypeName()) || name.equals(TYPE_J.getTypeName());
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            this.simpleName = DexUtils.getSimpleName(this.getTypeName());
        }
        return this.simpleName;
    }

    public String getSimpleInnerName() {
        String simple = this.getSimpleName();
        int i = simple.lastIndexOf(36);
        if (i > 0 && i < simple.length() - 1) {
            return simple.substring(i + 1);
        }
        return null;
    }

    public boolean isInnerName() {
        return this.getSimpleInnerName() != null;
    }

    public String getPackageName() {
        return DexUtils.getPackageName(this.getTypeName());
    }

    public String getPackageSourceName() {
        String packageName = this.getPackageName();
        int i = packageName.length() - 1;
        if (i < 1) {
            return StringsUtil.EMPTY;
        }
        return packageName.substring(1, i).replace('/', '.');
    }

    public TypeKey changeTypeName(String typeName) {
        return this.changeTypeName(TypeKey.create(typeName));
    }

    public TypeKey changeTypeName(TypeKey typeKey) {
        if (this.equals(typeKey)) {
            return this;
        }
        return typeKey.setArrayDimension(this.getArrayDimension());
    }

    public TypeKey renamePackage(String from, String to) {
        String packageName = this.getPackageName();
        if (packageName.equals(from)) {
            return this.setPackage(packageName, to);
        }
        int i = from.length();
        if (i == 1 || packageName.length() < i || !packageName.startsWith(from)) {
            return this;
        }
        return this.setPackage(packageName, packageName.replace(from, to));
    }

    public TypeKey setPackage(String packageName) {
        return this.setPackage(this.getPackageName(), packageName);
    }

    private TypeKey setPackage(String myPackage, String packageName) {
        if (myPackage.equals(packageName)) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(packageName);
        int i = packageName.length() - 1;
        if (i > 0 && packageName.charAt(i) != '/') {
            builder.append('/');
        }
        builder.append(this.getSimpleName());
        String name = this.getTypeName();
        char postFix = name.charAt(name.length() - 1);
        if (postFix == ';' || postFix == '<') {
            builder.append(postFix);
        }
        TypeKey typeKey = new TypeKey(builder.toString());
        return typeKey.setArrayDimension(this.getArrayDimension());
    }

    public boolean isPackage(String packageName) {
        return this.isPackage(packageName, !"L".equals(packageName));
    }

    public boolean isPackage(String packageName, boolean checkSubPackage) {
        if (this.isPrimitive()) {
            return false;
        }
        String name = this.getPackageName();
        if (checkSubPackage) {
            return name.startsWith(packageName);
        }
        return name.equals(packageName);
    }

    public boolean startsWith(String prefix) {
        return this.getTypeName().startsWith(prefix);
    }

    public boolean isOuterOf(TypeKey typeKey) {
        return this.isOuterOf(typeKey, false);
    }

    public boolean isOuterOf(TypeKey typeKey, boolean immediate) {
        if (typeKey == null) {
            return false;
        }
        String name1 = this.getTypeName();
        String name2 = typeKey.getTypeName();
        if (name1.length() >= name2.length()) {
            return false;
        }
        int diff = StringsUtil.diffStart(name1, name2);
        if (diff < 0 || name1.charAt(diff) != ';' || name2.charAt(diff) != '$') {
            return false;
        }
        int i = diff + 1;
        if (name1.indexOf(47, i) > 0 || name2.indexOf(47, i) > 0) {
            return false;
        }
        if (immediate) {
            int length = name2.length();
            while (i < length && name2.charAt(i) == '$') {
                ++i;
            }
            return i != length && name2.indexOf(36, i) < 0;
        }
        return true;
    }

    public TypeKey getEnclosingClass() {
        String parent;
        String type = this.getTypeName();
        if (type.equals(parent = DexUtils.getParentClassName(type))) {
            return this;
        }
        return new TypeKey(parent);
    }

    public TypeKey createInnerClass(String simpleName) {
        String child;
        String type = this.getTypeName();
        if (type.equals(child = DexUtils.createChildClass(type, simpleName))) {
            return this;
        }
        return new TypeKey(child);
    }

    public Iterator<String> iteratePackageNames() {
        if (this.getTypeName().indexOf(47) < 0) {
            return EmptyIterator.of();
        }
        final String packageName = this.getPackageName();
        return new Iterator<String>(){
            String name;
            {
                this.name = packageName;
            }

            @Override
            public boolean hasNext() {
                String name = this.name;
                int i = name.length();
                if (i == 0) {
                    return false;
                }
                return name.charAt(i - 1) == '/';
            }

            @Override
            public String next() {
                String result;
                String name = result = this.name;
                while (name.charAt(name.length() - 1) == '/') {
                    name = name.substring(0, name.length() - 1);
                }
                int i = name.lastIndexOf(47);
                if (i > 0) {
                    name = name.substring(0, i + 1);
                }
                this.name = name;
                return result;
            }
        };
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getTypeName());
    }

    public int compareInnerFirst(TypeKey other) {
        String name2;
        if (this.equals(other)) {
            return 0;
        }
        String name1 = this.getSimpleName();
        int diff = StringsUtil.diffStart(name1, name2 = other.getSimpleName());
        if (diff > 0 && name1.charAt(diff) == '$' && diff > name1.lastIndexOf(47) + 1) {
            return CompareUtil.compare(name2, name1);
        }
        name1 = this.getTypeName();
        name2 = other.getTypeName();
        return CompareUtil.compare(name1, name2);
    }

    public boolean equalsPackage(TypeKey typeKey) {
        if (typeKey == this) {
            return true;
        }
        if (typeKey == null) {
            return false;
        }
        String name1 = StringsUtil.trimStart(this.getTypeName(), '[');
        String name2 = StringsUtil.trimStart(typeKey.getTypeName(), '[');
        if (name1.charAt(0) != 'L' || name2.charAt(0) != 'L') {
            return false;
        }
        if (name1.equals(name2)) {
            return true;
        }
        int start = StringsUtil.diffStart(name1, name2);
        if (start < 0) {
            return false;
        }
        return StringsUtil.indexOfFrom(name1, start, '/') < 0 && StringsUtil.indexOfFrom(name2, start, '/') < 0;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof TypeKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        TypeKey key = (TypeKey)obj;
        return CompareUtil.compare(this.getTypeName(), key.getTypeName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeKey)) {
            return false;
        }
        TypeKey key = (TypeKey)obj;
        return this.getTypeName().equals(key.getTypeName());
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public String toString() {
        return this.getTypeName();
    }

    public static TypeKey parse(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.indexOf(62) > 0 || name.indexOf(40) > 0 || name.indexOf(64) > 0) {
            return null;
        }
        if (name.indexOf(47) > 0 || name.indexOf(59) > 0 || name.charAt(0) == '[') {
            return new TypeKey(name.replace('.', '/'));
        }
        return TypeKey.parseSourceName(name);
    }

    private static TypeKey parseSourceName(String name) {
        TypeKey typeKey;
        int length = name.length();
        int arrayDimension = 0;
        for (int i = name.indexOf(91); i > 0 && i < length && name.charAt(i) == '['; ++i) {
            ++arrayDimension;
            if (++i != length && name.charAt(i) == ']') continue;
            return null;
        }
        length = name.length() - arrayDimension * 2;
        if (length == 0) {
            return null;
        }
        if (arrayDimension != 0) {
            name = name.substring(0, length);
        }
        if ((typeKey = TypeKey.primitiveType(name)) == null) {
            name = name.replace('.', '/');
            typeKey = new TypeKey('L' + name + ';');
        }
        return typeKey.setArrayDimension(arrayDimension);
    }

    public static TypeKey convert(Class<?> type) {
        String name = type.getName();
        if (type.isArray()) {
            return new TypeKey(name.replace('.', '/'));
        }
        if (type.isPrimitive()) {
            return TypeKey.primitiveType(name);
        }
        return new TypeKey('L' + name.replace('.', '/') + ';');
    }

    public static TypeKey create(String typeName) {
        if (typeName == null) {
            return null;
        }
        int length = typeName.length();
        if (length == 0) {
            return null;
        }
        if (length != 1) {
            return new TypeKey(typeName);
        }
        return TypeKey.primitiveType(typeName.charAt(0));
    }

    public static TypeKey read(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        int position = reader.position();
        StringBuilder builder = new StringBuilder();
        while (reader.get() == 91) {
            builder.append(reader.readASCII());
        }
        byte b = reader.get();
        if (b != 76) {
            builder.append(reader.readASCII());
        } else {
            int i = reader.indexOfBeforeLineEnd(';');
            if (i < 0) {
                reader.position(position);
                throw new SmaliParseException("Invalid type, missing ';'", reader);
            }
            builder.append(reader.readString(++i - reader.position()));
        }
        TypeKey typeKey = TypeKey.create(builder.toString());
        if (typeKey == null) {
            reader.position(position);
            throw new SmaliParseException("Invalid type", reader);
        }
        return typeKey;
    }

    static TypeKey parseBinaryType(String text, int start, int end) {
        int arrayDimension = 0;
        boolean begin = false;
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '[') {
                if (begin) {
                    return null;
                }
                ++arrayDimension;
                continue;
            }
            if (c == ';') {
                if (begin) {
                    return TypeKey.create(text.substring(start, i + 1));
                }
                return null;
            }
            if (begin) continue;
            if (c != 'L') {
                TypeKey typeKey = TypeKey.primitiveType(c);
                if (typeKey != null) {
                    typeKey = typeKey.setArrayDimension(arrayDimension);
                }
                return typeKey;
            }
            begin = true;
        }
        return null;
    }

    public static boolean isPrimitive(char ch) {
        return TypeKey.primitiveType(ch) != null;
    }

    public static TypeKey primitiveType(char ch) {
        switch (ch) {
            case 'B': {
                return TYPE_B;
            }
            case 'C': {
                return TYPE_C;
            }
            case 'D': {
                return TYPE_D;
            }
            case 'F': {
                return TYPE_F;
            }
            case 'I': {
                return TYPE_I;
            }
            case 'J': {
                return TYPE_J;
            }
            case 'S': {
                return TYPE_S;
            }
            case 'V': {
                return TYPE_V;
            }
            case 'Z': {
                return TYPE_Z;
            }
        }
        return null;
    }

    private static TypeKey primitiveType(String sourceName) {
        int length = sourceName.length();
        if (length < 3 || length > 7) {
            return null;
        }
        if (sourceName.equals(TYPE_B.getSourceName())) {
            return TYPE_B;
        }
        if (sourceName.equals(TYPE_D.getSourceName())) {
            return TYPE_D;
        }
        if (sourceName.equals(TYPE_F.getSourceName())) {
            return TYPE_F;
        }
        if (sourceName.equals(TYPE_I.getSourceName())) {
            return TYPE_I;
        }
        if (sourceName.equals(TYPE_J.getSourceName())) {
            return TYPE_J;
        }
        if (sourceName.equals(TYPE_S.getSourceName())) {
            return TYPE_S;
        }
        if (sourceName.equals(TYPE_V.getSourceName())) {
            return TYPE_V;
        }
        if (sourceName.equals(TYPE_Z.getSourceName())) {
            return TYPE_Z;
        }
        return null;
    }

    public static TypeKey parseSignature(String type) {
        if (DexUtils.isTypeOrSignature(type)) {
            return new TypeKey(type);
        }
        return null;
    }

    static class PrimitiveTypeKey
    extends TypeKey {
        private final String sourceName;

        public PrimitiveTypeKey(String type, String sourceName) {
            super(type);
            this.sourceName = sourceName;
        }

        @Override
        public boolean uses(Key key) {
            return this.equals(key);
        }

        @Override
        public String getSourceName() {
            return this.sourceName;
        }

        @Override
        public TypeKey getDeclaring() {
            return this;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public boolean isTypeObject() {
            return false;
        }

        @Override
        public boolean isTypeArray() {
            return false;
        }

        @Override
        public boolean isTypeDefinition() {
            return false;
        }

        @Override
        public boolean isOuterOf(TypeKey typeKey, boolean immediate) {
            return false;
        }

        @Override
        public boolean isInnerName() {
            return false;
        }
    }
}

