/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.IdDefinition;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.AccessibleDex;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.program.AccessibleProgram;
import java.util.Iterator;

public abstract class DexDeclaration
extends Dex
implements AccessibleDex {
    @Override
    public boolean uses(Key key) {
        if (this.getKey().equals(key)) {
            return false;
        }
        return this.getDefinition().uses(key);
    }

    public boolean isAccessibleTo(TypeKey typeKey) {
        if (this.getDefining().equals(typeKey)) {
            return true;
        }
        if (this.isInternal()) {
            return this.getPackageName().equals(typeKey.getPackageName());
        }
        return !this.isPrivate();
    }

    public boolean isAccessibleTo(DexClass dexClass) {
        TypeKey defining;
        DexClass myClass = this.getDexClass();
        if (!myClass.isAccessibleTo(defining = dexClass.getDefining())) {
            return false;
        }
        if (myClass.getDefining().equals(defining)) {
            return true;
        }
        return myClass == this || this.isAccessibleTo(defining);
    }

    public boolean hasAccessFlag(AccessFlag accessFlag) {
        return accessFlag.isSet(this.getAccessFlagsValue());
    }

    public boolean hasAccessFlag(AccessFlag flag1, AccessFlag flag2) {
        return this.hasAccessFlag(flag1) && this.hasAccessFlag(flag2);
    }

    public boolean hasAccessFlag(AccessFlag flag1, AccessFlag flag2, AccessFlag flag3) {
        return this.hasAccessFlag(flag1) && this.hasAccessFlag(flag2) && this.hasAccessFlag(flag3);
    }

    public abstract IdDefinition<?> getDefinition();

    @Override
    public abstract ProgramKey getKey();

    public abstract IdItem getId();

    public abstract DexClass getDexClass();

    @Override
    public boolean isRemoved() {
        IdDefinition<?> definition = this.getDefinition();
        return definition == null || definition.isRemoved();
    }

    @Override
    public Iterator<? extends Modifier> getAccessFlags() {
        return this.getDefinition().getAccessFlags();
    }

    @Override
    public void addAccessFlag(AccessFlag accessFlag) {
        this.getDefinition().addAccessFlag(accessFlag);
    }

    @Override
    public void removeAccessFlag(AccessFlag accessFlag) {
        this.getDefinition().removeAccessFlag(accessFlag);
    }

    public TypeKey getDefining() {
        return this.getKey().getDeclaring();
    }

    public DexLayout getDexLayout() {
        if (this.getClass() == DexClass.class) {
            throw new RuntimeException("getDexFile() must be override for: " + this.getClass());
        }
        return this.getDexClass().getDexLayout();
    }

    public DexFile getDexFile() {
        return this.getDexLayout().getDexFile();
    }

    public DexDirectory getDexDirectory() {
        DexFile dexFile = this.getDexFile();
        if (dexFile != null) {
            return dexFile.getDexDirectory();
        }
        return null;
    }

    @Override
    public DexClassRepository getClassRepository() {
        DexLayout dexLayout = this.getDexLayout();
        if (dexLayout != null) {
            return dexLayout.getRootRepository();
        }
        return null;
    }

    public String getPackageName() {
        return this.getDefining().getPackageName();
    }

    public boolean isInSameFile(DexDeclaration dexDeclaration) {
        if (dexDeclaration == null) {
            return false;
        }
        if (dexDeclaration == this) {
            return true;
        }
        DexLayout dexLayout = this.getDexLayout();
        if (dexLayout == null) {
            return false;
        }
        return dexLayout == dexDeclaration.getDexLayout();
    }

    public boolean isInSameDirectory(DexDirectory directory) {
        return this.getDexDirectory() == directory;
    }

    @Override
    public AccessibleProgram getProgramElement() {
        return this.getDefinition();
    }

    public int hashCode() {
        ProgramKey key = this.getKey();
        if (key != null) {
            return key.hashCode();
        }
        return 0;
    }

    @Override
    public String toString() {
        return Modifier.toString(this.getAccessFlags()) + this.getKey();
    }
}

