/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.sections.Marker;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DexFileInfo
implements JSONConvert<JSONObject> {
    private int version = 35;
    private final List<String> markerList = new ArrayCollection<String>();
    private final List<DexFileInfo> layoutList = new ArrayCollection<DexFileInfo>();
    public static final String FILE_NAME = ObjectsUtil.of("dex-file.json");
    public static final String NAME_layouts = ObjectsUtil.of("layouts");
    public static final String NAME_markers = ObjectsUtil.of("markers");
    public static final String NAME_version = ObjectsUtil.of("version");

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void addMarker(Marker marker) {
        if (marker != null) {
            this.addMarker(marker.toString());
        }
    }

    public void addMarker(String marker) {
        if (marker != null) {
            this.markerList.add(marker);
        }
    }

    public void addLayout(DexFileInfo layout) {
        if (layout != null && layout != this) {
            this.layoutList.add(layout);
        }
    }

    public Iterator<Marker> getMarkers() {
        return ComputeIterator.of(this.getMarkerList().iterator(), Marker::parse);
    }

    public List<String> getMarkerList() {
        return this.markerList;
    }

    public List<DexFileInfo> getLayoutList() {
        return this.layoutList;
    }

    public void saveToDirectory(File dir) throws IOException {
        File file = new File(dir, FILE_NAME);
        this.toJson().write(file);
    }

    @Override
    public JSONObject toJson() {
        List<DexFileInfo> layoutList;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_version, this.getVersion());
        List<String> markerList = this.getMarkerList();
        if (!markerList.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.putAll((Collection<?>)markerList);
            jsonObject.put(NAME_markers, jsonArray);
        }
        if (!(layoutList = this.getLayoutList()).isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            for (DexFileInfo info : layoutList) {
                jsonArray.put(info.toJson());
            }
            jsonObject.put(NAME_layouts, jsonArray);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        int i;
        int length;
        this.setVersion(jsonObject.optInt(NAME_version, this.getVersion()));
        JSONArray jsonArray = jsonObject.optJSONArray(NAME_markers);
        if (jsonArray != null) {
            length = jsonArray.length();
            for (i = 0; i < length; ++i) {
                this.addMarker(jsonArray.optString(i));
            }
        }
        if ((jsonArray = jsonObject.optJSONArray(NAME_layouts)) != null) {
            length = jsonArray.length();
            for (i = 0; i < length; ++i) {
                this.addLayout(DexFileInfo.convert(jsonArray.getJSONObject(i)));
            }
        }
    }

    public void applyTo(DexFile dexFile) {
        List<DexFileInfo> layoutList = this.getLayoutList();
        if (layoutList.isEmpty()) {
            this.applyTo(dexFile.getOrCreateFirst());
            return;
        }
        int size = layoutList.size();
        for (int i = 0; i < size; ++i) {
            DexLayout dexLayout = dexFile.getOrCreateAt(i);
            DexFileInfo info = layoutList.get(i);
            info.applyTo(dexLayout);
        }
    }

    public void applyTo(DexLayout dexLayout) {
        dexLayout.setVersion(this.getVersion());
        Iterator<Marker> iterator = this.getMarkers();
        while (iterator.hasNext()) {
            Marker marker = iterator.next();
            dexLayout.addMarker(marker);
        }
    }

    public String toString() {
        return this.toJson().toString(2);
    }

    public static DexFileInfo fromDex(DexFile dexFile) {
        DexFileInfo info = new DexFileInfo();
        info.setVersion(dexFile.getVersion());
        if (dexFile.isMultiLayout()) {
            int size = dexFile.size();
            for (int i = 0; i < size; ++i) {
                info.addLayout(DexFileInfo.fromDex(dexFile.getLayout(i)));
            }
        } else {
            Iterator<Marker> iterator = dexFile.getMarkers();
            while (iterator.hasNext()) {
                info.addMarker(iterator.next());
            }
        }
        return info;
    }

    public static DexFileInfo fromDex(DexLayout dexLayout) {
        DexFileInfo info = new DexFileInfo();
        info.setVersion(dexLayout.getVersion());
        Iterator<Marker> iterator = dexLayout.getMarkers();
        while (iterator.hasNext()) {
            info.addMarker(iterator.next());
        }
        return info;
    }

    public static DexFileInfo readJson(File file) throws IOException {
        return DexFileInfo.convert(new JSONObject(file));
    }

    public static DexFileInfo convert(JSONObject jsonObject) {
        DexFileInfo info = new DexFileInfo();
        info.fromJson(jsonObject);
        return info;
    }
}

