/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexSource;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class DexFileSourceSet
implements Iterable<DexSource<DexFile>>,
Closeable {
    private final ArrayCollection<DexSource<DexFile>> sourceList = new ArrayCollection();
    private ZipEntryMap zipEntryMap;
    private Predicate<SectionType<?>> readFilter;

    public ZipEntryMap getZipEntryMap() {
        return this.zipEntryMap;
    }

    public void setZipEntryMap(ZipEntryMap zipEntryMap) {
        this.zipEntryMap = zipEntryMap;
    }

    public Predicate<SectionType<?>> getReadFilter() {
        return this.readFilter;
    }

    public void setReadFilter(Predicate<SectionType<?>> readFilter) {
        this.readFilter = readFilter;
    }

    public void merge(DexFileSourceSet sourceSet) {
        if (sourceSet == this) {
            throw new IllegalArgumentException("Cyclic merge");
        }
        for (DexSource<DexFile> coming : sourceSet) {
            if (this.isEmpty(coming)) continue;
            DexSource<DexFile> source = this.createNext();
            source.set(coming.get());
            try {
                this.save(source);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void removeEmpty() {
        Iterator<DexSource<DexFile>> iterator = this.sourceList.clonedIterator();
        while (iterator.hasNext()) {
            DexSource<DexFile> source = iterator.next();
            if (!this.isEmpty(source)) continue;
            this.remove(source);
        }
    }

    public void saveAll(File dir) throws IOException {
        Iterator<DexSource<DexFile>> iterator = this.sourceList.clonedIterator();
        while (iterator.hasNext()) {
            DexSource<DexFile> source = iterator.next();
            File file = new File(dir, source.getSimpleName());
            DexSource<DexFile> dexSource = DexSource.create(file);
            dexSource.set(source.get());
            if (this.isEmpty(dexSource)) {
                dexSource.delete();
                continue;
            }
            dexSource.write(source.get().getBytes());
        }
    }

    public void saveAll() throws IOException {
        Iterator<DexSource<DexFile>> iterator = this.sourceList.clonedIterator();
        while (iterator.hasNext()) {
            this.save(iterator.next());
        }
    }

    private void save(DexSource<DexFile> source) throws IOException {
        if (this.isEmpty(source)) {
            this.delete(source);
            return;
        }
        DexFile dexFile = source.get();
        source.write(dexFile.getBytes());
    }

    private boolean isEmpty(DexSource<DexFile> source) {
        DexFile dexFile = source.get();
        return dexFile == null || dexFile.isEmpty();
    }

    public Iterator<DexFile> getClonedDexFiles() {
        return ComputeIterator.of(this.clonedIterator(), DexSource::get);
    }

    public Iterator<DexFile> getDexFiles() {
        return ComputeIterator.of(this.iterator(), DexSource::get);
    }

    @Override
    public Iterator<DexSource<DexFile>> iterator() {
        return this.sourceList.iterator();
    }

    public Iterator<DexSource<DexFile>> clonedIterator() {
        return this.sourceList.clonedIterator();
    }

    public void addAll(ZipEntryMap zipEntryMap) throws IOException {
        this.addAll(zipEntryMap, (String)null);
    }

    public void addAll(ZipEntryMap zipEntryMap, String directory) throws IOException {
        String path = "";
        if (directory != null && directory.length() > 0) {
            if (directory.charAt(0) == '/') {
                directory = directory.substring(1);
            }
            path = directory;
        }
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        String pathPrefix = path + "classes";
        Predicate<InputSource> filter = inputSource -> {
            String name = inputSource.getAlias();
            return name.startsWith(pathPrefix) && DexFile.getDexFileNumber(name) >= 0;
        };
        this.addAll(zipEntryMap, filter);
    }

    public void addAll(ZipEntryMap zipEntryMap, Predicate<InputSource> filter) throws IOException {
        this.addAll(zipEntryMap, zipEntryMap.iterator(filter));
    }

    public void addAll(ZipEntryMap zipEntryMap, Iterator<InputSource> iterator) throws IOException {
        while (iterator.hasNext()) {
            this.add(zipEntryMap, iterator.next().getAlias());
        }
    }

    public void add(ZipEntryMap zipEntryMap, InputSource inputSource) throws IOException {
        String name = inputSource.getAlias();
        if (zipEntryMap.getInputSource(name) == null) {
            zipEntryMap.add(inputSource);
        }
        this.add(zipEntryMap, name);
    }

    public void add(ZipEntryMap zipEntryMap, String name) throws IOException {
        this.add(DexSource.create(zipEntryMap, name));
        if (this.getZipEntryMap() == null) {
            this.setZipEntryMap(zipEntryMap);
        }
    }

    public void add(ZipEntryMap zipEntryMap, String name, DexFile dexFile) throws IOException {
        this.add(DexSource.create(zipEntryMap, name, dexFile));
        if (this.getZipEntryMap() == null) {
            this.setZipEntryMap(zipEntryMap);
        }
    }

    public void addAll(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("No such directory: " + dir);
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile() || DexFile.getDexFileNumber(file.getName()) < 0) continue;
            this.add(file);
        }
    }

    public DexSource<DexFile> add(File file) throws IOException {
        return this.add(DexSource.create(file));
    }

    public DexSource<DexFile> add(DexSource<DexFile> source) throws IOException {
        DexSource<DexFile> exist = this.sourceList.getElement(source);
        if (exist != null) {
            if (exist == source) {
                this.load(source);
                return exist;
            }
            throw new IOException("Duplicate dex source: " + source);
        }
        this.load(source);
        this.sourceList.remove(source);
        this.sourceList.add(source);
        this.sourceList.sort(CompareUtil.getComparableComparator());
        return source;
    }

    public DexFile getDexFile(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.getSource(index).get();
    }

    public DexSource<DexFile> getSource(int index) {
        return this.sourceList.get(index);
    }

    public DexSource<DexFile> getSource(DexFile dexFile) {
        if (dexFile != null) {
            for (DexSource<DexFile> source : this) {
                if (dexFile != source.get()) continue;
                return source;
            }
        }
        return null;
    }

    public DexSource<DexFile> getFirst() {
        return this.sourceList.getFirst();
    }

    public DexSource<DexFile> getLast() {
        this.sourceList.sort(CompareUtil.getComparableComparator());
        return this.sourceList.getLast();
    }

    public DexSource<DexFile> createNext() {
        DexSource<DexFile> last = this.getLast();
        if (last == null) {
            ZipEntryMap zipEntryMap = this.getZipEntryMap();
            if (zipEntryMap == null) {
                throw new NullPointerException("Null ZipEntryMap");
            }
            DexSource<DexFile> source = DexSource.create(zipEntryMap, "classes.dex", DexFile.createDefault());
            this.sourceList.add(source);
            return source;
        }
        DexSource<DexFile> source = last.createNext();
        this.sourceList.add(source);
        this.sourceList.sort(CompareUtil.getComparableComparator());
        return source;
    }

    public int size() {
        return this.sourceList.size();
    }

    public void delete(DexSource<DexFile> dexSource) {
        this.remove(dexSource);
        dexSource.delete();
    }

    public void remove(DexSource<DexFile> dexSource) {
        this.sourceList.remove(dexSource);
        dexSource.set(null);
    }

    @Override
    public void close() throws IOException {
        for (DexSource<DexFile> dexSource : this.sourceList) {
            dexSource.close();
        }
        this.sourceList.clear();
    }

    private void load(DexSource<DexFile> dexSource) throws IOException {
        DexFile dexFile = dexSource.get();
        if (dexFile != null) {
            return;
        }
        dexFile = DexFile.read(dexSource.openStream(), this.getReadFilter());
        dexSource.set(dexFile);
        dexFile.setSimpleName(dexSource.getSimpleName());
    }

    public String toString() {
        return "size = " + this.size();
    }
}

