/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.SizeXIns;
import com.reandroid.dex.ins.TryBlock;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethodParameter;
import com.reandroid.dex.model.DexTry;
import com.reandroid.dex.program.MethodProgram;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.EmptyList;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.MergingIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DexMethod
extends DexDeclaration
implements MethodProgram {
    private final DexClass dexClass;
    private final MethodDef methodDef;
    private int mEditIndex;

    public DexMethod(DexClass dexClass, MethodDef methodDef) {
        this.dexClass = dexClass;
        this.methodDef = methodDef;
    }

    public DexMethod getDeclared() {
        DexMethod dexMethod;
        DexClass dexClass = this.getDexClass().getSuperClass();
        if (dexClass != null && (dexMethod = dexClass.getMethod(this.getKey())) != null) {
            return dexMethod.getDeclared();
        }
        dexClass = this.getDexClass();
        Iterator<DexClass> iterator = dexClass.getInterfaceClasses();
        while (iterator.hasNext()) {
            dexClass = iterator.next();
            DexMethod dexMethod2 = dexClass.getMethod(this.getKey());
            if (dexMethod2 == null) continue;
            return dexMethod2.getDeclared();
        }
        return this;
    }

    public DexMethod getSuperMethod() {
        return CollectionUtil.getFirst(this.getSuperMethods());
    }

    public Iterator<DexMethod> getSuperMethods() {
        MethodKey key = this.getKey();
        return ComputeIterator.of(this.getDexClass().getSuperTypes(), dexClass -> dexClass.getDeclaredMethod(key));
    }

    public Iterator<DexMethod> getOverriding() {
        return CombiningIterator.two(this.getExtending(), this.getImplementations());
    }

    public DexMethod getBridgingMethod() {
        MethodKey bridging = this.getBridging();
        if (bridging != null) {
            return this.getDexClass().getDeclaredMethod(bridging);
        }
        return null;
    }

    public MethodKey getBridging() {
        MethodKey methodKey;
        MethodKey key;
        DexInstruction instruction;
        if (this.isBridge() && (instruction = CollectionUtil.getSingle(FilterIterator.of(this.getInstructions(), ins -> ins.is(Opcode.INVOKE_VIRTUAL) || ins.is(Opcode.INVOKE_VIRTUAL_RANGE)))) != null && this.equalsForBridging(key = this.getKey(), methodKey = (MethodKey)instruction.getKey())) {
            return methodKey;
        }
        return null;
    }

    public MethodKey getBridge() {
        DexMethod bridge = this.getBridgeMethod();
        if (bridge != null) {
            return bridge.getKey();
        }
        return null;
    }

    public DexMethod getBridgeMethod() {
        if (!this.isBridge() && this.isVirtual()) {
            MethodKey methodKey = this.getKey();
            return CollectionUtil.getSingle(FilterIterator.of(this.getDexClass().getVirtualMethods(), dexMethod -> {
                DexMethod bridging = dexMethod.getBridgingMethod();
                if (bridging != null) {
                    return methodKey.equals(bridging.getKey());
                }
                return false;
            }));
        }
        return null;
    }

    private boolean equalsForBridging(MethodKey key1, MethodKey key2) {
        if (!key1.getDeclaring().equals(key2.getDeclaring()) || key1.equals(key2)) {
            return false;
        }
        int count = key1.getParametersCount();
        if (count != key2.getParametersCount()) {
            return false;
        }
        TypeKey typeKey = key1.getReturnType();
        if (this.differentPrimitiveForBridging(typeKey, key2.getReturnType())) {
            return false;
        }
        boolean allPrimitive = typeKey.isPrimitive();
        for (int i = 0; i < count; ++i) {
            typeKey = key1.getParameter(i);
            if (this.differentPrimitiveForBridging(key1.getParameter(i), key2.getParameter(i))) {
                return false;
            }
            if (!allPrimitive) continue;
            allPrimitive = typeKey.isPrimitive();
        }
        return !allPrimitive;
    }

    private boolean differentPrimitiveForBridging(TypeKey key1, TypeKey key2) {
        if (key1.isPrimitive()) {
            return !key1.equals(key2);
        }
        return key2.isPrimitive();
    }

    public Iterator<DexMethod> getExtending() {
        return new MergingIterator<DexMethod>(ComputeIterator.of(this.getDexClass().getExtending(), dexClass -> dexClass.getExtending(this.getKey())));
    }

    public Iterator<DexMethod> getImplementations() {
        return new MergingIterator<DexMethod>(ComputeIterator.of(this.getDexClass().getImplementations(), dexClass -> dexClass.getImplementations(this.getKey())));
    }

    public Iterator<MethodKey> getOverridingKeys() {
        return new MergingIterator<MethodKey>(ComputeIterator.of(this.getDexClass().getOverriding(), dexClass -> dexClass.getOverridingKeys(this.getKey())));
    }

    @Override
    public String getName() {
        return this.getDefinition().getName();
    }

    public void setName(String name) {
        this.getDefinition().setName(name);
    }

    public Iterator<DexInstruction> getInstructionsIfKey(Predicate<? super Key> predicate) {
        return this.getInstructionsIfIns(ins -> {
            if (ins instanceof SizeXIns) {
                return predicate.test(((SizeXIns)ins).getKey());
            }
            return false;
        });
    }

    public Iterator<DexInstruction> getInstructionsIfMethodKey(Predicate<? super MethodKey> predicate) {
        return this.getInstructionsIfIns(ins -> {
            if (ins instanceof SizeXIns) {
                Key key = ((SizeXIns)ins).getKey();
                if (key instanceof MethodKey) {
                    return predicate.test((MethodKey)key);
                }
                return false;
            }
            return false;
        });
    }

    public Iterator<DexInstruction> getInstructionsIfFieldKey(Predicate<? super FieldKey> predicate) {
        return this.getInstructionsIfIns(ins -> {
            if (ins instanceof SizeXIns) {
                Key key = ((SizeXIns)ins).getKey();
                if (key instanceof FieldKey) {
                    return predicate.test((FieldKey)key);
                }
                return false;
            }
            return false;
        });
    }

    public Iterator<DexInstruction> getInstructionsIfTypeKey(Predicate<? super TypeKey> predicate) {
        return this.getInstructionsIfIns(ins -> {
            if (ins instanceof SizeXIns) {
                Key key = ((SizeXIns)ins).getKey();
                if (key instanceof TypeKey) {
                    return predicate.test((TypeKey)key);
                }
                return false;
            }
            return false;
        });
    }

    public Iterator<DexInstruction> getInstructionsIfStringKey(Predicate<? super StringKey> predicate) {
        return this.getInstructionsIfIns(ins -> {
            if (ins instanceof SizeXIns) {
                Key key = ((SizeXIns)ins).getKey();
                if (key instanceof StringKey) {
                    return predicate.test((StringKey)key);
                }
                return false;
            }
            return false;
        });
    }

    @Deprecated
    public Iterator<DexInstruction> getInstructions(Opcode<?> opcode) {
        return this.getInstructionsWithOpcode(opcode);
    }

    public Iterator<DexInstruction> getInstructionsWithOpcode(Opcode<?> opcode) {
        return this.getInstructionsIfOpcode(op -> op == opcode);
    }

    public Iterator<DexInstruction> getInstructionsWithOpcode(Opcode<?> opcode, Opcode<?> alt) {
        return this.getInstructionsIfOpcode(op -> op == opcode || op == alt);
    }

    public Iterator<DexInstruction> getInstructionsIfOpcode(Predicate<Opcode<?>> predicate) {
        return this.getInstructionsIfIns(ins -> predicate.test(ins.getOpcode()));
    }

    @Deprecated
    public Iterator<DexInstruction> getInstructions(Predicate<? super Ins> filter) {
        return this.getInstructionsIfIns(filter);
    }

    public Iterator<DexInstruction> getInstructionsIfIns(Predicate<? super Ins> filter) {
        Iterator<? super Ins> iterator = FilterIterator.of(this.getDefinition().getInstructions(), filter);
        return ComputeIterator.of(iterator, this::create);
    }

    public Iterator<DexInstruction> getInstructions() {
        return DexInstruction.create(this, this.getDefinition().getInstructions());
    }

    int getEditIndex() {
        return this.mEditIndex;
    }

    void setEditIndex(int index) {
        this.mEditIndex = index;
    }

    public void clearCode() {
        this.getDefinition().clearCode();
    }

    public void clearDebug() {
        this.getDefinition().clearDebug();
    }

    public Iterator<DexTry> getDexTry() {
        return this.getDexTry(-1);
    }

    public Iterator<DexTry> getDexTry(int address) {
        TryBlock tryBlock = this.getDefinition().getTryBlock();
        if (tryBlock == null) {
            return EmptyIterator.of();
        }
        return DexTry.create(this, address, tryBlock.getTriesForAddress(address));
    }

    public DexTry createDexTry() {
        TryBlock tryBlock = this.getDefinition().getOrCreateTryBlock();
        return DexTry.create(this, tryBlock.createNext());
    }

    public DexInstruction getInstruction(int i) {
        return this.create(this.getDefinition().getInstruction(i));
    }

    public DexInstruction getInstructionAt(int address) {
        return this.create(this.getDefinition().getInstructionAt(address));
    }

    public DexInstruction addInstruction(Opcode<?> opcode) {
        return this.create((Ins)this.getDefinition().getOrCreateInstructionList().createNext(opcode));
    }

    public DexInstruction parseInstruction(String smaliString) throws IOException {
        return this.parseInstruction(SmaliReader.of(smaliString));
    }

    public DexInstruction parseInstruction(SmaliReader reader) throws IOException {
        int index = this.getInstructionsCount();
        return this.parseInstruction(index, reader);
    }

    public DexInstruction parseInstruction(int index, SmaliReader reader) throws IOException {
        SmaliInstruction smaliInstruction = new SmaliInstruction();
        smaliInstruction.parse(reader);
        InstructionList instructionList = this.getDefinition().getOrCreateInstructionList();
        Object ins = instructionList.createAt(index, smaliInstruction.getOpcode());
        ((Ins)ins).fromSmali(smaliInstruction);
        return this.create((Ins)ins);
    }

    public DexInstruction createInstruction(int index, Opcode<?> opcode) {
        return this.create((Ins)this.getDefinition().getOrCreateInstructionList().createAt(index, opcode));
    }

    public int getInstructionsCount() {
        return this.getDefinition().getInstructionsCount();
    }

    public RegistersTable getRegistersTable() {
        return this.getDefinition().getCodeItem();
    }

    public RegistersTable getOrCreateRegistersTable() {
        return this.getDefinition().getOrCreateCodeItem();
    }

    public List<Register> getLocalFreeRegisters(int instructionIndex) {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            return instructionList.getLocalFreeRegisters(instructionIndex);
        }
        return EmptyList.of();
    }

    public void ensureLocalRegistersCount(int locals) {
        if (locals == 0) {
            return;
        }
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable != null && locals <= registersTable.getLocalRegistersCount()) {
            return;
        }
        registersTable = this.getOrCreateRegistersTable();
        registersTable.ensureLocalRegistersCount(locals);
    }

    public int refreshParameterRegistersCount() {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable == null) {
            return 0;
        }
        int parameterCount = this.getKey().getParameterRegistersCount();
        if (!this.isStatic()) {
            ++parameterCount;
        }
        int locals = registersTable.getLocalRegistersCount();
        registersTable.setParameterRegistersCount(parameterCount);
        registersTable.setRegistersCount(locals + parameterCount);
        return parameterCount;
    }

    private InstructionList getInstructionList() {
        return this.getDefinition().getInstructionList();
    }

    public int getLocalRegistersCount() {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable != null) {
            return registersTable.getLocalRegistersCount();
        }
        return 0;
    }

    public int getRegistersCount() {
        RegistersTable registersTable = this.getRegistersTable();
        if (registersTable != null) {
            return registersTable.getRegistersCount();
        }
        return 0;
    }

    public void setParameterRegistersCount(int count) {
        CodeItem codeItem = this.getDefinition().getOrCreateCodeItem();
        if (codeItem != null) {
            codeItem.setParameterRegistersCount(count);
        }
    }

    public void setLocalRegistersCount(int count) {
        CodeItem codeItem = this.getDefinition().getOrCreateCodeItem();
        if (codeItem != null) {
            codeItem.setRegistersCount(codeItem.getParameterRegistersCount() + count);
        }
    }

    private DexInstruction create(Ins ins) {
        return DexInstruction.create(this, ins);
    }

    @Override
    public MethodKey getKey() {
        return this.getId().getKey();
    }

    @Override
    public MethodId getId() {
        return (MethodId)this.getDefinition().getId();
    }

    @Override
    public DexClass getDexClass() {
        return this.dexClass;
    }

    public MethodDef getDefinition() {
        return this.methodDef;
    }

    @Override
    public int getParametersCount() {
        return this.getDefinition().getParametersCount();
    }

    @Override
    public DexMethodParameter getParameter(int i) {
        return DexMethodParameter.create(this, this.getDefinition().getParameter(i));
    }

    public Iterator<DexMethodParameter> getParameters() {
        return ComputeIterator.of(this.getDefinition().getParameters(), parameter -> DexMethodParameter.create(this, parameter));
    }

    public void removeParameter(int index) {
        this.getDefinition().removeParameter(index);
    }

    public boolean hasParameter(int index) {
        return this.getDefinition().hasParameter(index);
    }

    @Override
    public void removeSelf() {
        this.getDefinition().removeSelf();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDefinition().append(writer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexMethod dexMethod = (DexMethod)obj;
        return MethodId.equals(true, this.getId(), dexMethod.getId());
    }
}

