/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.data.MethodParameterDef;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.AnnotatedDex;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.program.MethodParameter;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public class DexMethodParameter
extends Dex
implements AnnotatedDex,
MethodParameter {
    private final DexMethod dexMethod;
    private final MethodParameterDef parameterDef;

    public DexMethodParameter(DexMethod dexMethod, MethodParameterDef parameterDef) {
        this.dexMethod = dexMethod;
        this.parameterDef = parameterDef;
    }

    @Override
    public TypeKey getKey() {
        return this.getProgramElement().getKey();
    }

    @Override
    public String getDebugName() {
        return this.getProgramElement().getDebugName();
    }

    @Override
    public void setDebugName(String name) {
        this.getProgramElement().setDebugName(name);
    }

    public TypeKey getType() {
        return this.getKey();
    }

    @Override
    public int getDefinitionIndex() {
        return this.getProgramElement().getDefinitionIndex();
    }

    @Override
    public int getRegister() {
        return this.getProgramElement().getRegister();
    }

    public DexMethod getDexMethod() {
        return this.dexMethod;
    }

    @Override
    public boolean uses(Key key) {
        if (ObjectsUtil.equals(this.getType(), key)) {
            return true;
        }
        return this.getAnnotation().uses(key);
    }

    @Override
    public DexClassRepository getClassRepository() {
        return this.getDexMethod().getClassRepository();
    }

    @Override
    public void removeSelf() {
        this.getDexMethod().removeParameter(this.getDefinitionIndex());
    }

    @Override
    public boolean isRemoved() {
        DexMethod dexMethod = this.getDexMethod();
        return dexMethod.isRemoved() || !dexMethod.hasParameter(this.getDefinitionIndex());
    }

    @Override
    public MethodParameterDef getProgramElement() {
        return this.parameterDef;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getProgramElement().append(writer);
    }

    public static DexMethodParameter create(DexMethod dexMethod, MethodParameterDef parameter) {
        if (dexMethod != null && parameter != null) {
            return new DexMethodParameter(dexMethod, parameter);
        }
        return null;
    }
}

