/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.sections.MapItem;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;

public class DexSectionInfo {
    private final DexLayout dexLayout;
    private final MapItem mapItem;

    public DexSectionInfo(DexLayout dexLayout, MapItem mapItem) {
        this.dexLayout = dexLayout;
        this.mapItem = mapItem;
    }

    public DexLayout getDexLayout() {
        return this.dexLayout;
    }

    private MapItem getMapItem() {
        return this.mapItem;
    }

    public int getIndex() {
        return this.getMapItem().getIndex();
    }

    public int getType() {
        return this.getMapItem().getType().get();
    }

    public SectionType<?> getSectionType() {
        return this.getMapItem().getSectionType();
    }

    public int getCount() {
        return this.getMapItem().getCountValue();
    }

    public int getOffset() {
        return this.getMapItem().getOffsetValue();
    }

    public String getName() {
        SectionType<?> sectionType = this.getSectionType();
        if (sectionType != null) {
            return sectionType.getName();
        }
        return HexUtil.toHex("UNKNOWN_", this.getType(), 1);
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("index", this.getIndex());
        jsonObject.put("name", this.getName());
        jsonObject.put("count", this.getCount());
        jsonObject.put("offset", this.getOffset());
        return jsonObject;
    }

    public String print(boolean hex) {
        int i;
        int pad;
        String num;
        StringBuilder builder = new StringBuilder();
        String name = this.getName();
        builder.append(name);
        builder.append(' ');
        int fill = 24 - name.length();
        for (int i2 = 0; i2 < fill; ++i2) {
            builder.append('-');
        }
        builder.append("[");
        if (hex) {
            num = HexUtil.toHex(this.getCount(), 1);
            pad = 8;
        } else {
            num = Integer.toString(this.getCount());
            pad = 6;
        }
        builder.append(num);
        fill = pad - num.length();
        for (i = 0; i < fill; ++i) {
            builder.append(' ');
        }
        builder.append(',');
        builder.append(' ');
        if (hex) {
            num = HexUtil.toHex(this.getOffset(), 8);
            pad = 10;
        } else {
            num = Integer.toString(this.getOffset());
            pad = 8;
        }
        fill = pad - num.length();
        for (i = 0; i < fill; ++i) {
            builder.append(' ');
        }
        builder.append(num);
        builder.append(']');
        return builder.toString();
    }

    public String toString() {
        return this.print(false);
    }
}

