/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.program;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.program.AccessibleProgram;
import com.reandroid.dex.program.MethodParameter;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public interface MethodProgram
extends AccessibleProgram {
    @Override
    public MethodKey getKey();

    public MethodParameter getParameter(int var1);

    public Iterator<? extends MethodParameter> getParameters();

    @Override
    default public ElementType getElementType() {
        return ElementType.METHOD;
    }

    default public int getParametersCount() {
        ProtoKey protoKey = this.getProtoKey();
        if (protoKey != null) {
            return protoKey.getParametersCount();
        }
        return 0;
    }

    default public ProtoKey getProtoKey() {
        MethodKey key = this.getKey();
        if (key != null) {
            return key.getProto();
        }
        return null;
    }

    default public String getName() {
        MethodKey key = this.getKey();
        if (key != null) {
            return key.getName();
        }
        return null;
    }

    default public boolean isConstructor() {
        return AccessFlag.CONSTRUCTOR.isSet(this.getAccessFlagsValue());
    }

    default public boolean isBridge() {
        return AccessFlag.BRIDGE.isSet(this.getAccessFlagsValue());
    }

    default public boolean isDirect() {
        return this.isConstructor() || this.isStatic() || this.isPrivate();
    }

    default public boolean isVirtual() {
        return !this.isDirect();
    }

    default public boolean isVarArgs() {
        return AccessFlag.VARARGS.isSet(this.getAccessFlagsValue());
    }
}

