/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.refactor;

import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.KeyPair;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.refactor.Rename;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RenameMethods
extends Rename<MethodKey, MethodKey> {
    public void add(DexClassRepository classRepository, MethodKey search, String replace) {
        this.add(classRepository, search, search.changeName(replace));
    }

    public void add(DexClassRepository classRepository, MethodKey search, MethodKey replace) {
        KeyPair<MethodKey, MethodKey> start = new KeyPair<MethodKey, MethodKey>(search, replace);
        if (!start.isValid() || this.isLocked(start)) {
            return;
        }
        if (this.containsDeclaration(classRepository, replace)) {
            this.lock(start);
            return;
        }
        ArrayCollection list = new ArrayCollection();
        list.add(start);
        Iterator<MethodKey> iterator = classRepository.findEquivalentMethods(search);
        while (iterator.hasNext()) {
            MethodKey equivalent = iterator.next();
            KeyPair<MethodKey, MethodKey> pair = new KeyPair<MethodKey, MethodKey>(equivalent, equivalent.changeName(replace.getName()));
            if (this.isLocked(pair)) {
                this.lockAll(list);
                list.clear();
                break;
            }
            list.add(pair);
        }
        this.addAll(list);
    }

    @Override
    public int apply(DexClassRepository classRepository) {
        List<KeyPair<MethodKey, MethodKey>> list = this.toList();
        int count = this.applyToMethodIds(classRepository, list);
        return count += this.applyToAnnotations(classRepository, list);
    }

    private int applyToMethodIds(DexClassRepository classRepository, List<KeyPair<MethodKey, MethodKey>> keyPairList) {
        int count = 0;
        for (KeyPair<MethodKey, MethodKey> pair : keyPairList) {
            MethodKey search = pair.getFirst();
            MethodKey replace = pair.getSecond();
            Iterator<MethodId> iterator = classRepository.getItems(SectionType.METHOD_ID, search);
            while (iterator.hasNext()) {
                MethodId methodId = iterator.next();
                methodId.setKey(replace);
                ++count;
            }
        }
        return count;
    }

    private int applyToAnnotations(DexClassRepository classRepository, List<KeyPair<MethodKey, MethodKey>> list) {
        Map<TypeKey, Set<KeyPair<MethodKey, MethodKey>>> map = this.mapDeclaring(list);
        int count = 0;
        Iterator<AnnotationItem> iterator = classRepository.getItems(SectionType.ANNOTATION_ITEM);
        while (iterator.hasNext()) {
            AnnotationItem annotationItem = iterator.next();
            count += this.renameAnnotation(map, annotationItem);
        }
        return count;
    }

    private int renameAnnotation(Map<TypeKey, Set<KeyPair<MethodKey, MethodKey>>> map, AnnotationItem annotationItem) {
        TypeKey typeKey = annotationItem.getType();
        Set<KeyPair<MethodKey, MethodKey>> set = map.get(typeKey);
        if (set == null) {
            return 0;
        }
        int result = 0;
        for (KeyPair<MethodKey, MethodKey> pair : set) {
            AnnotationItemKey update;
            MethodKey search = pair.getFirst();
            MethodKey replace = pair.getSecond();
            AnnotationItemKey key = annotationItem.getKey();
            if (key == (update = key.replaceKey(search, replace))) continue;
            annotationItem.setKey(update);
            ++result;
        }
        return result;
    }

    private Map<TypeKey, Set<KeyPair<MethodKey, MethodKey>>> mapDeclaring(List<KeyPair<MethodKey, MethodKey>> list) {
        HashMap<TypeKey, Set<KeyPair<MethodKey, MethodKey>>> map = new HashMap<TypeKey, Set<KeyPair<MethodKey, MethodKey>>>();
        for (KeyPair<MethodKey, MethodKey> pair : list) {
            TypeKey typeKey = pair.getFirst().getDeclaring();
            HashSet<KeyPair<MethodKey, MethodKey>> set = (HashSet<KeyPair<MethodKey, MethodKey>>)map.get(typeKey);
            if (set == null) {
                set = new HashSet<KeyPair<MethodKey, MethodKey>>();
                set.add(pair);
                map.put(typeKey, set);
            } else {
                set.add(pair);
            }
            set.add(pair);
        }
        return map;
    }

    @Override
    protected boolean containsDeclaration(DexClassRepository classRepository, MethodKey replaceKey) {
        return classRepository.getDeclaredMethod(replaceKey, false) != null;
    }
}

