/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.reference.IdItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.HexUtil;

public class IdItemIndirectShortReference<T extends IdItem>
extends IdItemIndirectReference<T> {
    public IdItemIndirectShortReference(SectionType<T> sectionType, SectionItem blockItem, int offset, int usage) {
        super(sectionType, blockItem, offset, usage);
        Block.putShort(this.getBytesInternal(), this.getOffset(), 65535);
    }

    @Override
    public int get() {
        return Block.getShortUnsigned(this.getBytesInternal(), this.getOffset());
    }

    @Override
    public void set(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new DexException("Short value out of range " + HexUtil.toHex(value, 4) + " > 0xffff");
        }
        Block.putShort(this.getBytesInternal(), this.getOffset(), value);
    }

    @Override
    protected T pullItem(int i) {
        if (i == 65535) {
            return null;
        }
        return super.pullItem(i);
    }
}

