/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public abstract class RTypeItem {
    private final DexClass dexClass;

    public RTypeItem(DexClass dexClass) {
        this.dexClass = dexClass;
    }

    public String getName() {
        return this.getKey().getSimpleInnerName();
    }

    public TypeKey getKey() {
        return this.getDexClass().getKey();
    }

    public DexClass getDexClass() {
        return this.dexClass;
    }

    public abstract boolean isValid();

    public abstract void appendJavaEntries(SmaliWriter var1) throws IOException;

    public void appendJava(SmaliWriter writer) throws IOException {
        DexClass dexClass = this.getDexClass();
        writer.appendModifiers(dexClass.getAccessFlags());
        writer.append("class ");
        writer.append(this.getName());
        writer.append(" {");
        writer.indentPlus();
        this.appendJavaEntries(writer);
        writer.indentMinus();
        writer.newLine();
        writer.append('}');
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RTypeItem other = (RTypeItem)obj;
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getKey().toString();
    }
}

