/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.DataSection;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionType;

public class AnnotationSetSection
extends DataSection<AnnotationSet> {
    public AnnotationSetSection(IntegerPair countAndOffset, SectionType<AnnotationSet> sectionType) {
        super(countAndOffset, sectionType);
    }

    @Override
    public boolean sort() {
        AnnotationSet annotationSet = this.getEmptySet();
        if (annotationSet != null && annotationSet.getIndex() != 0) {
            this.getItemArray().moveTo(annotationSet, 0);
            return true;
        }
        return false;
    }

    private AnnotationSet getEmptySet() {
        SectionArray array = this.getItemArray();
        AnnotationSet annotationSet = (AnnotationSet)array.getFirst();
        if (annotationSet != null && annotationSet.isEmpty()) {
            return annotationSet;
        }
        DexSectionPool pool = this.getLoadedPool();
        if (pool != null) {
            return (AnnotationSet)pool.get(AnnotationSetKey.empty());
        }
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            annotationSet = (AnnotationSet)array.get(i);
            if (!annotationSet.isEmpty()) continue;
            return annotationSet;
        }
        return null;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.ensureNotEmpty();
    }

    private void ensureNotEmpty() {
        if (!this.isEmpty()) {
            return;
        }
        this.add(new AnnotationSet.EmptyAnnotationSet());
    }
}

