/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.IdSectionArray;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClassIdSectionArray
extends IdSectionArray<ClassId> {
    private boolean mDefinitionSortDisabled;

    public ClassIdSectionArray(IntegerPair countAndOffset) {
        super(countAndOffset, SectionType.CLASS_ID.getCreator());
    }

    @Override
    public boolean sort(Comparator<? super ClassId> comparator) {
        Section section = this.getParentSection();
        if (section == null) {
            return false;
        }
        SectionList sectionList = section.getSectionList();
        if (sectionList == null) {
            return false;
        }
        DexHeader dexHeader = sectionList.getHeader();
        if (dexHeader.isClassDefinitionOrderEnforced()) {
            return this.sortDefinition();
        }
        return this.comparatorSort(comparator);
    }

    public boolean comparatorSort(Comparator<? super ClassId> comparator) {
        return super.sort(comparator);
    }

    public boolean sortDefinition() {
        if (this.mDefinitionSortDisabled) {
            return false;
        }
        boolean sorted = false;
        DexSectionPool<ClassId> pool = this.getParentSection().getPool();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ClassId classId = (ClassId)iterator.next();
            if (!this.sortDefinition(null, pool, classId)) continue;
            sorted = true;
        }
        return sorted && !this.mDefinitionSortDisabled;
    }

    private boolean sortDefinition(Set<TypeKey> cyclicSet, DexSectionPool<ClassId> pool, ClassId classId) {
        boolean sorted = false;
        TypeKey key = classId.getKey();
        Iterator<TypeKey> superKeys = classId.getInstanceKeys();
        while (superKeys.hasNext()) {
            int i2;
            int i1;
            TypeKey typeKey = superKeys.next();
            ClassId other = (ClassId)pool.get(typeKey);
            if (other == null || (i1 = classId.getIndex()) > (i2 = other.getIndex())) continue;
            if (i1 == i2) {
                this.onCyclicInheritance(classId);
                return false;
            }
            this.moveTo(other, i1);
            if (cyclicSet == null) {
                cyclicSet = new HashSet<TypeKey>();
                cyclicSet.add(key);
            } else if (cyclicSet.contains(typeKey)) {
                this.onCyclicInheritance(classId);
                return false;
            }
            cyclicSet.add(typeKey);
            this.sortDefinition(cyclicSet, pool, other);
            sorted = true;
        }
        return sorted;
    }

    private void onCyclicInheritance(ClassId classId) {
        this.mDefinitionSortDisabled = true;
        String message = "WARN: Cyclic inheritance involving '" + classId.getKey() + "'";
        System.err.println(message);
    }
}

